/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;

public class HmtxWriter
extends Hmtx
implements FontTableWriter {
    private static final long serialVersionUID = 514149709527353256L;
    int glyphCount;
    int[] advanceWidth;
    int[] leftSideBearing;

    public HmtxWriter(PdfJavaGlyphs glyphs, int[] advanceWidth, int[] lsbs) {
        this.glyphCount = glyphs.getGlyphCount();
        this.advanceWidth = advanceWidth;
        this.leftSideBearing = lsbs == null ? new int[65535] : lsbs;
    }

    @Override
    public byte[] writeTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < this.glyphCount; ++i) {
            bos.write(FontWriter.setNextUint16(this.advanceWidth[i]));
            bos.write(FontWriter.setNextInt16(this.leftSideBearing[i]));
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    @Override
    public int getIntValue(int key) {
        return 0;
    }
}

