/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

public class ImageOps {
    private static int[] bitCheck = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    private static byte[] invertByteImage(int w, int h, int componentCount, byte[] data) {
        int temp = data.length / (w * h);
        if (temp != componentCount) {
            componentCount = temp;
        }
        int bytesInRow = w * componentCount;
        int topByte = 0;
        for (int bottomByte = (h - 1) * bytesInRow; topByte < bottomByte; topByte += bytesInRow, bottomByte -= bytesInRow) {
            for (int row = 0; row < bytesInRow; row += componentCount) {
                for (int c = 0; c < componentCount; ++c) {
                    byte tempByte = data[topByte + row + c];
                    data[topByte + row + c] = data[bottomByte + row + c];
                    data[bottomByte + row + c] = tempByte;
                }
            }
        }
        return data;
    }

    private static byte[] invertOneBitImage(int w, int h, byte[] data) {
        int bytesInRow = (w + 7) / 8;
        int topByte = 0;
        for (int bottomByte = (h - 1) * bytesInRow; topByte < bottomByte; topByte += bytesInRow, bottomByte -= bytesInRow) {
            for (int row = 0; row < bytesInRow; ++row) {
                byte tempByte = data[topByte + row];
                data[topByte + row] = data[bottomByte + row];
                data[bottomByte + row] = tempByte;
            }
        }
        return data;
    }

    private static byte[] rotateOneBitImage(int w, int h, byte[] data, int newH, int newW) {
        int bytesInRow = (w + 7) / 8;
        int newBytesInRow = (newW + 7) / 8;
        byte[] newData = new byte[newBytesInRow * newH];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int byteUsed = (h - 1 - y) * bytesInRow + (x >> 3);
                byte pixelByte = data[byteUsed];
                if (pixelByte == 0) {
                    x += 7;
                    continue;
                }
                int bitUsed = x & 7;
                if ((pixelByte & bitCheck[bitUsed]) != bitCheck[bitUsed]) continue;
                int newByteUsed = x * newBytesInRow + (y >> 3);
                byte newPixelByte = newData[newByteUsed];
                int newBitUsed = y & 7;
                newData[newByteUsed] = newPixelByte = (byte)(newPixelByte | bitCheck[newBitUsed]);
            }
        }
        return newData;
    }

    private static byte[] rotateByteImage(int w, int h, int componentCount, byte[] data) {
        int temp = data.length / (w * h);
        if (temp != componentCount) {
            componentCount = temp;
        }
        int bytesInRow = w * componentCount;
        int newBytesInRow = h * componentCount;
        byte[] rotatedData = new byte[data.length];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < bytesInRow; x += componentCount) {
                int convertPoint = x / componentCount * newBytesInRow + (newBytesInRow - y * componentCount - componentCount);
                for (int c = 0; c < componentCount; ++c) {
                    rotatedData[convertPoint + c] = data[y * bytesInRow + (x + c)];
                }
            }
        }
        return rotatedData;
    }

    public static byte[] invertImage(byte[] data, int w, int h, int d, int comp, byte[] index) {
        if (d == 8) {
            if (index != null) {
                comp = 1;
            } else {
                data = ImageOps.checkSize(data, w, h, comp);
            }
            return ImageOps.invertByteImage(w, h, comp, data);
        }
        if (d == 1) {
            return ImageOps.invertOneBitImage(w, h, data);
        }
        return null;
    }

    public static byte[] rotateImage(byte[] data, int w, int h, int d, int comp, byte[] index) {
        if (d == 8) {
            if (index != null) {
                comp = 1;
            }
            return ImageOps.rotateByteImage(w, h, comp, data);
        }
        if (d != 4 && d == 1) {
            return ImageOps.rotateOneBitImage(w, h, data, w, h);
        }
        return null;
    }

    public static byte[] checkSize(byte[] data, int w, int h, int comp) {
        int correctSize = w * h * comp;
        if (data.length < correctSize) {
            byte[] newData = new byte[correctSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
        }
        return data;
    }
}

