/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

public class JAITiffHelper {
    private ImageDecoder dec;
    private int pageCount;

    public JAITiffHelper(String file) {
        block2: {
            this.pageCount = 0;
            try {
                File imgFile = new File(file);
                FileSeekableStream s = new FileSeekableStream(imgFile);
                this.dec = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)s, null);
                this.pageCount = this.dec.getNumPages();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    public int getTiffPageCount() {
        return this.pageCount;
    }

    public BufferedImage getImage(int tiffImageToLoad) {
        BufferedImage img;
        block2: {
            img = null;
            try {
                NullOpImage op = new NullOpImage(this.dec.decodeAsRenderedImage(tiffImageToLoad), null, null, 2);
                img = JAI.create((String)"affine", (RenderedImage)op, null, (Object)new InterpolationBicubic(1)).getAsBufferedImage();
                img = ColorSpaceConvertor.convertColorspace(img, 10);
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return img;
    }
}

