/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class LinearizedHintTable {
    private final Map startRefs = new HashMap();
    private final Map endRefs = new HashMap();
    private static final int[] mask = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    private static final int[] shift = new int[]{0, 8, 16, 24};
    private int[] pageObjectCount = null;
    private int[] obj = null;
    private int[] pageLength;
    private long[] pageStart;
    private FileChannel fos = null;
    private boolean finishedReading = false;

    public LinearizedHintTable(FileChannel fos) {
        this.fos = fos;
    }

    public void readTable(PdfObject hintObj, PdfObject linearObj, int O, long Ooffset) {
        byte[] hintTableData = hintObj.getDecodedStream();
        int N = linearObj.getInt(30);
        if (hintTableData != null) {
            this.parseHintTable(N, O, Ooffset, hintTableData);
        }
    }

    private void parseHintTable(int N, int O, long Ooffset, byte[] hintTableData) {
        int pageReached;
        int startByte = 0;
        this.pageObjectCount = new int[N + 1];
        this.obj = new int[N + 1];
        this.pageStart = new long[N + 1];
        this.pageLength = new int[N + 1];
        int[] sharedObjects = new int[N + 1];
        boolean showHeader = false;
        int leastNumberOfObjects = ((hintTableData[startByte] & 0xFF) << 24) + ((hintTableData[startByte + 1] & 0xFF) << 16) + ((hintTableData[startByte + 2] & 0xFF) << 8) + (hintTableData[startByte + 3] & 0xFF);
        startByte += 4;
        int bitsNeededforObjectCount = ((hintTableData[startByte += 4] & 0xFF) << 8) + (hintTableData[startByte + 1] & 0xFF);
        int smallestPageSize = ((hintTableData[startByte += 2] & 0xFF) << 24) + ((hintTableData[startByte + 1] & 0xFF) << 16) + ((hintTableData[startByte + 2] & 0xFF) << 8) + (hintTableData[startByte + 3] & 0xFF);
        int bitsNeededforPageSize = ((hintTableData[startByte += 4] & 0xFF) << 8) + (hintTableData[startByte + 1] & 0xFF);
        startByte += 2;
        startByte += 4;
        startByte += 2;
        startByte += 4;
        int bitsNeededforSharedObject = ((hintTableData[startByte += 2] & 0xFF) << 8) + (hintTableData[startByte + 1] & 0xFF);
        int bitsNeededforSharedObjectIdentifier = ((hintTableData[startByte += 2] & 0xFF) << 8) + (hintTableData[startByte + 1] & 0xFF);
        startByte += 2;
        startByte += 2;
        int bitReached = (startByte += 2) << 3;
        int objectCount = 0;
        for (pageReached = 0; pageReached < N; ++pageReached) {
            this.pageObjectCount[pageReached + 1] = leastNumberOfObjects + LinearizedHintTable.getBitsFromByteStream(bitReached, bitsNeededforObjectCount, hintTableData);
            objectCount += this.pageObjectCount[pageReached + 1];
            bitReached += bitsNeededforObjectCount;
        }
        this.obj[1] = O;
        if (N > 1) {
            this.obj[2] = 1;
        }
        for (pageReached = 3; pageReached < N; ++pageReached) {
            this.obj[pageReached] = this.obj[pageReached - 1] + this.pageObjectCount[pageReached - 1];
        }
        bitReached = bitReached + 7 >> 3 << 3;
        for (pageReached = 0; pageReached < N; ++pageReached) {
            this.pageLength[pageReached + 1] = smallestPageSize + LinearizedHintTable.getBitsFromByteStream(bitReached, bitsNeededforPageSize, hintTableData);
            bitReached += bitsNeededforPageSize;
        }
        for (pageReached = 0; pageReached < N; ++pageReached) {
            this.pageStart[pageReached + 1] = pageReached == 0 ? Ooffset : this.pageStart[pageReached] + (long)this.pageLength[pageReached];
        }
        bitReached = bitReached + 7 >> 3 << 3;
        for (pageReached = 0; pageReached < N; ++pageReached) {
            sharedObjects[pageReached + 1] = LinearizedHintTable.getBitsFromByteStream(bitReached, bitsNeededforSharedObject, hintTableData);
            bitReached += bitsNeededforPageSize;
        }
        bitReached = bitReached + 7 >> 3 << 3;
    }

    private static int getBitsFromByteStream(int bitReached, int bitsNeededforObjectCount, byte[] hintTableData) {
        boolean debug = false;
        int value = 0;
        int startByte = bitReached >> 3;
        int startOffset = bitReached & 7;
        int bytesNeeded = (bitsNeededforObjectCount + startOffset >> 3) + 1;
        int endShift = (bytesNeeded << 3) - startOffset - bitsNeededforObjectCount;
        if (startOffset == 0) {
            endShift = (bytesNeeded << 3) - bitsNeededforObjectCount & 7;
        }
        if (bytesNeeded > 4) {
            return 0;
        }
        for (int ii = 0; ii < bytesNeeded; ++ii) {
            int nextValue = hintTableData[startByte + ii] & 0xFF;
            if (ii == 0) {
                nextValue &= mask[startOffset];
            }
            value += nextValue << shift[bytesNeeded - (ii + 1)];
        }
        return value >>= endShift;
    }

    public int getPageObjectRef(int rawPage) {
        if (this.obj == null || this.obj.length <= rawPage) {
            return -1;
        }
        return this.obj[rawPage];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getObjData(int objID) {
        byte[] data;
        if (this.finishedReading) {
            return null;
        }
        Integer key = objID;
        if (!this.startRefs.containsKey(key) || !this.endRefs.containsKey(key)) {
            return null;
        }
        int start = (Integer)this.startRefs.get(key);
        int end = (Integer)this.endRefs.get(key);
        int bufSize = end - start + 1;
        long size = 0L;
        try {
            if (this.fos.isOpen()) {
                size = this.fos.size() - 200L;
            }
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            size = 0L;
        }
        if (size < (long)end || end - start < 1) {
            return null;
        }
        try {
            FileChannel fileChannel = this.fos;
            synchronized (fileChannel) {
                ByteBuffer buf = ByteBuffer.allocateDirect(bufSize);
                this.fos.read(buf, start);
                buf.clear();
                data = new byte[buf.capacity()];
                buf.get(data, 0, data.length);
            }
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            data = null;
        }
        return data;
    }

    public void storeOffset(int ref, int startObjPtr, int endObjPtr) {
        this.startRefs.put(ref, startObjPtr);
        this.endRefs.put(ref, endObjPtr);
    }

    public void setFinishedReading() {
        this.finishedReading = true;
    }
}

