/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.ArithmeticDecoder;
import org.jpedal.jbig2.decoders.DecodeIntResult;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.decoders.MMRDecoder;
import org.jpedal.jbig2.image.BitmapPointer;
import org.jpedal.jbig2.util.BinaryOperation;

public final class JBIG2Bitmap {
    private int width;
    private int height;
    private int line;
    private int bitmapNumber;
    public FastBitSet data;
    private ArithmeticDecoder arithmeticDecoder;
    private HuffmanDecoder huffmanDecoder;
    private MMRDecoder mmrDecoder;

    public JBIG2Bitmap(int width, int height, ArithmeticDecoder arithmeticDecoder, HuffmanDecoder huffmanDecoder, MMRDecoder mmrDecoder) {
        this.width = width;
        this.height = height;
        this.arithmeticDecoder = arithmeticDecoder;
        this.huffmanDecoder = huffmanDecoder;
        this.mmrDecoder = mmrDecoder;
        this.line = width + 7 >> 3;
        this.data = new FastBitSet(width * height);
    }

    public void readBitmap(boolean useMMR, int template, boolean typicalPredictionGenericDecodingOn, boolean useSkip, JBIG2Bitmap skipBitmap, short[] adaptiveTemplateX, short[] adaptiveTemplateY, int mmrDataLength) throws IOException, JBIG2Exception {
        block64: {
            block62: {
                block63: {
                    if (!useMMR) break block62;
                    this.mmrDecoder.reset();
                    int[] referenceLine = new int[this.width + 2];
                    int[] codingLine = new int[this.width + 2];
                    codingLine[0] = codingLine[1] = this.width;
                    for (int row = 0; row < this.height; ++row) {
                        int i = 0;
                        while (codingLine[i] < this.width) {
                            referenceLine[i] = codingLine[i];
                            ++i;
                        }
                        int n = this.width;
                        referenceLine[i + 1] = n;
                        referenceLine[i] = n;
                        int referenceI = 0;
                        int codingI = 0;
                        int a0 = 0;
                        block25: do {
                            int code1 = this.mmrDecoder.get2DCode();
                            switch (code1) {
                                case 0: {
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    a0 = referenceLine[referenceI + 1];
                                    referenceI += 2;
                                    break;
                                }
                                case 1: {
                                    int code2;
                                    int code3;
                                    if (codingI & true) {
                                        code1 = 0;
                                        do {
                                            code3 = this.mmrDecoder.getBlackCode();
                                            code1 += code3;
                                        } while (code3 >= 64);
                                        code2 = 0;
                                        do {
                                            code3 = this.mmrDecoder.getWhiteCode();
                                            code2 += code3;
                                        } while (code3 >= 64);
                                    } else {
                                        code1 = 0;
                                        do {
                                            code3 = this.mmrDecoder.getWhiteCode();
                                            code1 += code3;
                                        } while (code3 >= 64);
                                        code2 = 0;
                                        do {
                                            code3 = this.mmrDecoder.getBlackCode();
                                            code2 += code3;
                                        } while (code3 >= 64);
                                    }
                                    if (code1 <= 0 && code2 <= 0) continue block25;
                                    int n2 = codingI++;
                                    int n3 = a0 + code1;
                                    codingLine[n2] = n3;
                                    a0 = n3;
                                    int n4 = codingI++;
                                    int n5 = a0 + code2;
                                    codingLine[n4] = n5;
                                    a0 = n5;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 2: {
                                    int n6 = codingI++;
                                    int n7 = referenceLine[referenceI];
                                    codingLine[n6] = n7;
                                    a0 = n7;
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    ++referenceI;
                                    break;
                                }
                                case 3: {
                                    int n8 = codingI++;
                                    int n9 = referenceLine[referenceI] + 1;
                                    codingLine[n8] = n9;
                                    a0 = n9;
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 5: {
                                    int n10 = codingI++;
                                    int n11 = referenceLine[referenceI] + 2;
                                    codingLine[n10] = n11;
                                    a0 = n11;
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 7: {
                                    int n12 = codingI++;
                                    int n13 = referenceLine[referenceI] + 3;
                                    codingLine[n12] = n13;
                                    a0 = n13;
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 4: {
                                    int n14 = codingI++;
                                    int n15 = referenceLine[referenceI] - 1;
                                    codingLine[n14] = n15;
                                    a0 = n15;
                                    referenceI = referenceI > 0 ? --referenceI : ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 6: {
                                    int n16 = codingI++;
                                    int n17 = referenceLine[referenceI] - 2;
                                    codingLine[n16] = n17;
                                    a0 = n17;
                                    referenceI = referenceI > 0 ? --referenceI : ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 8: {
                                    int n18 = codingI++;
                                    int n19 = referenceLine[referenceI] - 3;
                                    codingLine[n18] = n19;
                                    a0 = n19;
                                    referenceI = referenceI > 0 ? --referenceI : ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                default: {
                                    if (!JBIG2StreamDecoder.debug) continue block25;
                                    System.out.println("Illegal code in JBIG2 MMR bitmap data");
                                }
                            }
                        } while (a0 < this.width);
                        codingLine[codingI++] = this.width;
                        int j = 0;
                        while (codingLine[j] < this.width) {
                            for (int col = codingLine[j]; col < codingLine[j + 1]; ++col) {
                                this.setPixel(col, row, 1);
                            }
                            j += 2;
                        }
                    }
                    if (mmrDataLength < 0) break block63;
                    this.mmrDecoder.skipTo(mmrDataLength);
                    break block64;
                }
                if (this.mmrDecoder.get24Bits() == 4097L || !JBIG2StreamDecoder.debug) break block64;
                System.out.println("Missing EOFB in JBIG2 MMR bitmap data");
                break block64;
            }
            BitmapPointer cxPtr0 = new BitmapPointer(this);
            BitmapPointer cxPtr1 = new BitmapPointer(this);
            BitmapPointer atPtr0 = new BitmapPointer(this);
            BitmapPointer atPtr1 = new BitmapPointer(this);
            BitmapPointer atPtr2 = new BitmapPointer(this);
            BitmapPointer atPtr3 = new BitmapPointer(this);
            long ltpCX = 0L;
            if (typicalPredictionGenericDecodingOn) {
                switch (template) {
                    case 0: {
                        ltpCX = 14675L;
                        break;
                    }
                    case 1: {
                        ltpCX = 1946L;
                        break;
                    }
                    case 2: {
                        ltpCX = 227L;
                        break;
                    }
                    case 3: {
                        ltpCX = 394L;
                    }
                }
            }
            boolean ltp = false;
            block39: for (int row = 0; row < this.height; ++row) {
                if (typicalPredictionGenericDecodingOn) {
                    int bit = this.arithmeticDecoder.decodeBit(ltpCX, this.arithmeticDecoder.genericRegionStats);
                    if (bit != 0) {
                        boolean bl = ltp = !ltp;
                    }
                    if (ltp) {
                        this.duplicateRow(row, row - 1);
                        continue;
                    }
                }
                switch (template) {
                    case 0: {
                        int pixel;
                        long cx;
                        int col;
                        cxPtr0.setPointer(0, row - 2);
                        long cx0 = cxPtr0.nextPixel() << 1;
                        cx0 |= (long)cxPtr0.nextPixel();
                        cxPtr1.setPointer(0, row - 1);
                        long cx1 = cxPtr1.nextPixel() << 2;
                        cx1 |= (long)(cxPtr1.nextPixel() << 1);
                        cx1 |= (long)cxPtr1.nextPixel();
                        long cx2 = 0L;
                        atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
                        atPtr1.setPointer(adaptiveTemplateX[1], row + adaptiveTemplateY[1]);
                        atPtr2.setPointer(adaptiveTemplateX[2], row + adaptiveTemplateY[2]);
                        atPtr3.setPointer(adaptiveTemplateX[3], row + adaptiveTemplateY[3]);
                        for (col = 0; col < this.width; ++col) {
                            cx = BinaryOperation.bit32ShiftL(cx0, 13) | BinaryOperation.bit32ShiftL(cx1, 8) | BinaryOperation.bit32ShiftL(cx2, 4) | (long)(atPtr0.nextPixel() << 3) | (long)(atPtr1.nextPixel() << 2) | (long)(atPtr2.nextPixel() << 1) | (long)atPtr3.nextPixel();
                            if (useSkip && skipBitmap.getPixel(col, row) != 0) {
                                pixel = 0;
                            } else {
                                pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                                if (pixel != 0) {
                                    this.data.set(row * this.width + col);
                                }
                            }
                            cx0 = (BinaryOperation.bit32ShiftL(cx0, 1) | (long)cxPtr0.nextPixel()) & 7L;
                            cx1 = (BinaryOperation.bit32ShiftL(cx1, 1) | (long)cxPtr1.nextPixel()) & 0x1FL;
                            cx2 = (BinaryOperation.bit32ShiftL(cx2, 1) | (long)pixel) & 0xFL;
                        }
                        continue block39;
                    }
                    case 1: {
                        int pixel;
                        long cx;
                        int col;
                        cxPtr0.setPointer(0, row - 2);
                        long cx0 = cxPtr0.nextPixel() << 2;
                        cx0 |= (long)(cxPtr0.nextPixel() << 1);
                        cx0 |= (long)cxPtr0.nextPixel();
                        cxPtr1.setPointer(0, row - 1);
                        long cx1 = cxPtr1.nextPixel() << 2;
                        cx1 |= (long)(cxPtr1.nextPixel() << 1);
                        cx1 |= (long)cxPtr1.nextPixel();
                        long cx2 = 0L;
                        atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
                        for (col = 0; col < this.width; ++col) {
                            cx = BinaryOperation.bit32ShiftL(cx0, 9) | BinaryOperation.bit32ShiftL(cx1, 4) | BinaryOperation.bit32ShiftL(cx2, 1) | (long)atPtr0.nextPixel();
                            if (useSkip && skipBitmap.getPixel(col, row) != 0) {
                                pixel = 0;
                            } else {
                                pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                                if (pixel != 0) {
                                    this.data.set(row * this.width + col);
                                }
                            }
                            cx0 = (BinaryOperation.bit32ShiftL(cx0, 1) | (long)cxPtr0.nextPixel()) & 0xFL;
                            cx1 = (BinaryOperation.bit32ShiftL(cx1, 1) | (long)cxPtr1.nextPixel()) & 0x1FL;
                            cx2 = (BinaryOperation.bit32ShiftL(cx2, 1) | (long)pixel) & 7L;
                        }
                        continue block39;
                    }
                    case 2: {
                        int pixel;
                        long cx;
                        int col;
                        cxPtr0.setPointer(0, row - 2);
                        long cx0 = cxPtr0.nextPixel() << 1;
                        cx0 |= (long)cxPtr0.nextPixel();
                        cxPtr1.setPointer(0, row - 1);
                        long cx1 = cxPtr1.nextPixel() << 1;
                        cx1 |= (long)cxPtr1.nextPixel();
                        long cx2 = 0L;
                        atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
                        for (col = 0; col < this.width; ++col) {
                            cx = BinaryOperation.bit32ShiftL(cx0, 7) | BinaryOperation.bit32ShiftL(cx1, 3) | BinaryOperation.bit32ShiftL(cx2, 1) | (long)atPtr0.nextPixel();
                            if (useSkip && skipBitmap.getPixel(col, row) != 0) {
                                pixel = 0;
                            } else {
                                pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                                if (pixel != 0) {
                                    this.data.set(row * this.width + col);
                                }
                            }
                            cx0 = (BinaryOperation.bit32ShiftL(cx0, 1) | (long)cxPtr0.nextPixel()) & 7L;
                            cx1 = (BinaryOperation.bit32ShiftL(cx1, 1) | (long)cxPtr1.nextPixel()) & 0xFL;
                            cx2 = (BinaryOperation.bit32ShiftL(cx2, 1) | (long)pixel) & 3L;
                        }
                        continue block39;
                    }
                    case 3: {
                        int pixel;
                        long cx;
                        int col;
                        cxPtr1.setPointer(0, row - 1);
                        long cx1 = cxPtr1.nextPixel() << 1;
                        cx1 |= (long)cxPtr1.nextPixel();
                        long cx2 = 0L;
                        atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
                        for (col = 0; col < this.width; ++col) {
                            cx = BinaryOperation.bit32ShiftL(cx1, 5) | BinaryOperation.bit32ShiftL(cx2, 1) | (long)atPtr0.nextPixel();
                            if (useSkip && skipBitmap.getPixel(col, row) != 0) {
                                pixel = 0;
                            } else {
                                pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                                if (pixel != 0) {
                                    this.data.set(row * this.width + col);
                                }
                            }
                            cx1 = (BinaryOperation.bit32ShiftL(cx1, 1) | (long)cxPtr1.nextPixel()) & 0x1FL;
                            cx2 = (BinaryOperation.bit32ShiftL(cx2, 1) | (long)pixel) & 0xFL;
                        }
                        continue block39;
                    }
                }
            }
        }
    }

    public void readGenericRefinementRegion(int template, boolean typicalPredictionGenericRefinementOn, JBIG2Bitmap referredToBitmap, int referenceDX, int referenceDY, short[] adaptiveTemplateX, short[] adaptiveTemplateY) throws IOException, JBIG2Exception {
        BitmapPointer typicalPredictionGenericRefinementCXPtr2;
        BitmapPointer typicalPredictionGenericRefinementCXPtr1;
        BitmapPointer typicalPredictionGenericRefinementCXPtr0;
        BitmapPointer cxPtr6;
        BitmapPointer cxPtr5;
        BitmapPointer cxPtr4;
        BitmapPointer cxPtr3;
        BitmapPointer cxPtr2;
        BitmapPointer cxPtr1;
        BitmapPointer cxPtr0;
        long ltpCX;
        if (template != 0) {
            ltpCX = 8L;
            cxPtr0 = new BitmapPointer(this);
            cxPtr1 = new BitmapPointer(this);
            cxPtr2 = new BitmapPointer(referredToBitmap);
            cxPtr3 = new BitmapPointer(referredToBitmap);
            cxPtr4 = new BitmapPointer(referredToBitmap);
            cxPtr5 = new BitmapPointer(this);
            cxPtr6 = new BitmapPointer(this);
            typicalPredictionGenericRefinementCXPtr0 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr1 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr2 = new BitmapPointer(referredToBitmap);
        } else {
            ltpCX = 16L;
            cxPtr0 = new BitmapPointer(this);
            cxPtr1 = new BitmapPointer(this);
            cxPtr2 = new BitmapPointer(referredToBitmap);
            cxPtr3 = new BitmapPointer(referredToBitmap);
            cxPtr4 = new BitmapPointer(referredToBitmap);
            cxPtr5 = new BitmapPointer(this);
            cxPtr6 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr0 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr1 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr2 = new BitmapPointer(referredToBitmap);
        }
        boolean ltp = false;
        for (int row = 0; row < this.height; ++row) {
            long cx;
            int pixel;
            int decodeBit;
            int col;
            long typicalPredictionGenericRefinementCX0;
            long typicalPredictionGenericRefinementCX1;
            long typicalPredictionGenericRefinementCX2;
            long cx4;
            long cx3;
            long cx0;
            if (template != 0) {
                cxPtr0.setPointer(0, row - 1);
                cx0 = cxPtr0.nextPixel();
                cxPtr1.setPointer(-1, row);
                cxPtr2.setPointer(-referenceDX, row - 1 - referenceDY);
                cxPtr3.setPointer(-1 - referenceDX, row - referenceDY);
                cx3 = cxPtr3.nextPixel();
                cx3 = BinaryOperation.bit32ShiftL(cx3, 1) | (long)cxPtr3.nextPixel();
                cxPtr4.setPointer(-referenceDX, row + 1 - referenceDY);
                cx4 = cxPtr4.nextPixel();
                typicalPredictionGenericRefinementCX2 = 0L;
                typicalPredictionGenericRefinementCX1 = 0L;
                typicalPredictionGenericRefinementCX0 = 0L;
                if (typicalPredictionGenericRefinementOn) {
                    typicalPredictionGenericRefinementCXPtr0.setPointer(-1 - referenceDX, row - 1 - referenceDY);
                    typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCXPtr0.nextPixel();
                    typicalPredictionGenericRefinementCX0 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX0, 1) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                    typicalPredictionGenericRefinementCX0 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX0, 1) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                    typicalPredictionGenericRefinementCXPtr1.setPointer(-1 - referenceDX, row - referenceDY);
                    typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCXPtr1.nextPixel();
                    typicalPredictionGenericRefinementCX1 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX1, 1) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                    typicalPredictionGenericRefinementCX1 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX1, 1) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                    typicalPredictionGenericRefinementCXPtr2.setPointer(-1 - referenceDX, row + 1 - referenceDY);
                    typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCXPtr2.nextPixel();
                    typicalPredictionGenericRefinementCX2 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX2, 1) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                    typicalPredictionGenericRefinementCX2 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX2, 1) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                }
                for (col = 0; col < this.width; ++col) {
                    cx0 = (BinaryOperation.bit32ShiftL(cx0, 1) | (long)cxPtr0.nextPixel()) & 7L;
                    cx3 = (BinaryOperation.bit32ShiftL(cx3, 1) | (long)cxPtr3.nextPixel()) & 7L;
                    cx4 = (BinaryOperation.bit32ShiftL(cx4, 1) | (long)cxPtr4.nextPixel()) & 3L;
                    if (typicalPredictionGenericRefinementOn) {
                        typicalPredictionGenericRefinementCX0 = (BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX0, 1) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel()) & 7L;
                        typicalPredictionGenericRefinementCX1 = (BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX1, 1) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel()) & 7L;
                        typicalPredictionGenericRefinementCX2 = (BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX2, 1) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel()) & 7L;
                        decodeBit = this.arithmeticDecoder.decodeBit(ltpCX, this.arithmeticDecoder.refinementRegionStats);
                        if (decodeBit != 0) {
                            boolean bl = ltp = !ltp;
                        }
                        if (typicalPredictionGenericRefinementCX0 == 0L && typicalPredictionGenericRefinementCX1 == 0L && typicalPredictionGenericRefinementCX2 == 0L) {
                            this.setPixel(col, row, 0);
                            continue;
                        }
                        if (typicalPredictionGenericRefinementCX0 == 7L && typicalPredictionGenericRefinementCX1 == 7L && typicalPredictionGenericRefinementCX2 == 7L) {
                            this.setPixel(col, row, 1);
                            continue;
                        }
                    }
                    if ((pixel = this.arithmeticDecoder.decodeBit(cx = BinaryOperation.bit32ShiftL(cx0, 7) | (long)(cxPtr1.nextPixel() << 6) | (long)(cxPtr2.nextPixel() << 5) | BinaryOperation.bit32ShiftL(cx3, 2) | cx4, this.arithmeticDecoder.refinementRegionStats)) != 1) continue;
                    this.data.set(row * this.width + col);
                }
                continue;
            }
            cxPtr0.setPointer(0, row - 1);
            cx0 = cxPtr0.nextPixel();
            cxPtr1.setPointer(-1, row);
            cxPtr2.setPointer(-referenceDX, row - 1 - referenceDY);
            long cx2 = cxPtr2.nextPixel();
            cxPtr3.setPointer(-1 - referenceDX, row - referenceDY);
            cx3 = cxPtr3.nextPixel();
            cx3 = BinaryOperation.bit32ShiftL(cx3, 1) | (long)cxPtr3.nextPixel();
            cxPtr4.setPointer(-1 - referenceDX, row + 1 - referenceDY);
            cx4 = cxPtr4.nextPixel();
            cx4 = BinaryOperation.bit32ShiftL(cx4, 1) | (long)cxPtr4.nextPixel();
            cxPtr5.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
            cxPtr6.setPointer(adaptiveTemplateX[1] - referenceDX, row + adaptiveTemplateY[1] - referenceDY);
            typicalPredictionGenericRefinementCX2 = 0L;
            typicalPredictionGenericRefinementCX1 = 0L;
            typicalPredictionGenericRefinementCX0 = 0L;
            if (typicalPredictionGenericRefinementOn) {
                typicalPredictionGenericRefinementCXPtr0.setPointer(-1 - referenceDX, row - 1 - referenceDY);
                typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCXPtr0.nextPixel();
                typicalPredictionGenericRefinementCX0 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX0, 1) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                typicalPredictionGenericRefinementCX0 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX0, 1) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                typicalPredictionGenericRefinementCXPtr1.setPointer(-1 - referenceDX, row - referenceDY);
                typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCXPtr1.nextPixel();
                typicalPredictionGenericRefinementCX1 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX1, 1) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                typicalPredictionGenericRefinementCX1 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX1, 1) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                typicalPredictionGenericRefinementCXPtr2.setPointer(-1 - referenceDX, row + 1 - referenceDY);
                typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCXPtr2.nextPixel();
                typicalPredictionGenericRefinementCX2 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX2, 1) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                typicalPredictionGenericRefinementCX2 = BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX2, 1) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
            }
            for (col = 0; col < this.width; ++col) {
                cx0 = (BinaryOperation.bit32ShiftL(cx0, 1) | (long)cxPtr0.nextPixel()) & 3L;
                cx2 = (BinaryOperation.bit32ShiftL(cx2, 1) | (long)cxPtr2.nextPixel()) & 3L;
                cx3 = (BinaryOperation.bit32ShiftL(cx3, 1) | (long)cxPtr3.nextPixel()) & 7L;
                cx4 = (BinaryOperation.bit32ShiftL(cx4, 1) | (long)cxPtr4.nextPixel()) & 7L;
                if (typicalPredictionGenericRefinementOn) {
                    typicalPredictionGenericRefinementCX0 = (BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX0, 1) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel()) & 7L;
                    typicalPredictionGenericRefinementCX1 = (BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX1, 1) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel()) & 7L;
                    typicalPredictionGenericRefinementCX2 = (BinaryOperation.bit32ShiftL(typicalPredictionGenericRefinementCX2, 1) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel()) & 7L;
                    decodeBit = this.arithmeticDecoder.decodeBit(ltpCX, this.arithmeticDecoder.refinementRegionStats);
                    if (decodeBit == 1) {
                        boolean bl = ltp = !ltp;
                    }
                    if (typicalPredictionGenericRefinementCX0 == 0L && typicalPredictionGenericRefinementCX1 == 0L && typicalPredictionGenericRefinementCX2 == 0L) {
                        this.setPixel(col, row, 0);
                        continue;
                    }
                    if (typicalPredictionGenericRefinementCX0 == 7L && typicalPredictionGenericRefinementCX1 == 7L && typicalPredictionGenericRefinementCX2 == 7L) {
                        this.setPixel(col, row, 1);
                        continue;
                    }
                }
                if ((pixel = this.arithmeticDecoder.decodeBit(cx = BinaryOperation.bit32ShiftL(cx0, 11) | (long)(cxPtr1.nextPixel() << 10) | BinaryOperation.bit32ShiftL(cx2, 8) | BinaryOperation.bit32ShiftL(cx3, 5) | BinaryOperation.bit32ShiftL(cx4, 2) | (long)(cxPtr5.nextPixel() << 1) | (long)cxPtr6.nextPixel(), this.arithmeticDecoder.refinementRegionStats)) != 1) continue;
                this.setPixel(col, row, 1);
            }
        }
    }

    public void readTextRegion(boolean huffman, boolean symbolRefine, int noOfSymbolInstances, int logStrips, int noOfSymbols, int[][] symbolCodeTable, int symbolCodeLength, JBIG2Bitmap[] symbols, int defaultPixel, int combinationOperator, boolean transposed, int referenceCorner, int sOffset, int[][] huffmanFSTable, int[][] huffmanDSTable, int[][] huffmanDTTable, int[][] huffmanRDWTable, int[][] huffmanRDHTable, int[][] huffmanRDXTable, int[][] huffmanRDYTable, int[][] huffmanRSizeTable, int template, short[] symbolRegionAdaptiveTemplateX, short[] symbolRegionAdaptiveTemplateY, JBIG2StreamDecoder decoder) throws JBIG2Exception, IOException {
        int strips = 1 << logStrips;
        this.clear(defaultPixel);
        int t = huffman ? this.huffmanDecoder.decodeInt(huffmanDTTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadtStats).intResult();
        t *= -strips;
        int firstS = 0;
        block12: for (int currentInstance = 0; currentInstance < noOfSymbolInstances; ++currentInstance) {
            int dt = huffman ? this.huffmanDecoder.decodeInt(huffmanDTTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadtStats).intResult();
            t += dt * strips;
            int ds = huffman ? this.huffmanDecoder.decodeInt(huffmanFSTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iafsStats).intResult();
            int s = firstS += ds;
            while (true) {
                dt = strips == 1 ? 0 : (huffman ? decoder.readBits(logStrips) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaitStats).intResult());
                int tt = t + dt;
                long symbolID = huffman ? (symbolCodeTable != null ? (long)this.huffmanDecoder.decodeInt(symbolCodeTable).intResult() : (long)decoder.readBits(symbolCodeLength)) : this.arithmeticDecoder.decodeIAID(symbolCodeLength, this.arithmeticDecoder.iaidStats);
                if (symbolID >= (long)noOfSymbols) {
                    if (!JBIG2StreamDecoder.debug) continue block12;
                    System.out.println("Invalid symbol number in JBIG2 text region");
                    continue block12;
                }
                JBIG2Bitmap symbolBitmap = null;
                int ri = symbolRefine ? (huffman ? decoder.readBit() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iariStats).intResult()) : 0;
                if (ri != 0) {
                    int refinementDeltaY;
                    int refinementDeltaX;
                    int refinementDeltaHeight;
                    int refinementDeltaWidth;
                    if (huffman) {
                        refinementDeltaWidth = this.huffmanDecoder.decodeInt(huffmanRDWTable).intResult();
                        refinementDeltaHeight = this.huffmanDecoder.decodeInt(huffmanRDHTable).intResult();
                        refinementDeltaX = this.huffmanDecoder.decodeInt(huffmanRDXTable).intResult();
                        refinementDeltaY = this.huffmanDecoder.decodeInt(huffmanRDYTable).intResult();
                        decoder.consumeRemainingBits();
                        this.arithmeticDecoder.start();
                    } else {
                        refinementDeltaWidth = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardwStats).intResult();
                        refinementDeltaHeight = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardhStats).intResult();
                        refinementDeltaX = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardxStats).intResult();
                        refinementDeltaY = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardyStats).intResult();
                    }
                    refinementDeltaX = (refinementDeltaWidth >= 0 ? refinementDeltaWidth : refinementDeltaWidth - 1) / 2 + refinementDeltaX;
                    refinementDeltaY = (refinementDeltaHeight >= 0 ? refinementDeltaHeight : refinementDeltaHeight - 1) / 2 + refinementDeltaY;
                    symbolBitmap = new JBIG2Bitmap(refinementDeltaWidth + symbols[(int)symbolID].width, refinementDeltaHeight + symbols[(int)symbolID].height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
                    symbolBitmap.readGenericRefinementRegion(template, false, symbols[(int)symbolID], refinementDeltaX, refinementDeltaY, symbolRegionAdaptiveTemplateX, symbolRegionAdaptiveTemplateY);
                } else {
                    symbolBitmap = symbols[(int)symbolID];
                }
                int bitmapWidth = symbolBitmap.width - 1;
                int bitmapHeight = symbolBitmap.height - 1;
                if (transposed) {
                    switch (referenceCorner) {
                        case 0: {
                            this.combine(symbolBitmap, tt, s, combinationOperator);
                            break;
                        }
                        case 1: {
                            this.combine(symbolBitmap, tt, s, combinationOperator);
                            break;
                        }
                        case 2: {
                            this.combine(symbolBitmap, tt - bitmapWidth, s, combinationOperator);
                            break;
                        }
                        case 3: {
                            this.combine(symbolBitmap, tt - bitmapWidth, s, combinationOperator);
                        }
                    }
                    s += bitmapHeight;
                    continue block12;
                }
                switch (referenceCorner) {
                    case 0: {
                        this.combine(symbolBitmap, s, tt - bitmapHeight, combinationOperator);
                        break;
                    }
                    case 1: {
                        this.combine(symbolBitmap, s, tt, combinationOperator);
                        break;
                    }
                    case 2: {
                        this.combine(symbolBitmap, s, tt - bitmapHeight, combinationOperator);
                        break;
                    }
                    case 3: {
                        this.combine(symbolBitmap, s, tt, combinationOperator);
                    }
                }
                s += bitmapWidth;
                DecodeIntResult decodeIntResult = huffman ? this.huffmanDecoder.decodeInt(huffmanDSTable) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadsStats);
                if (!decodeIntResult.booleanResult()) continue block12;
                ds = decodeIntResult.intResult();
                s += sOffset + ds;
            }
        }
    }

    public void clear(int defPixel) {
        this.data.setAll(defPixel == 1);
    }

    public void combine(JBIG2Bitmap bitmap, int x, int y, long combOp) {
        block22: {
            int indx;
            int srcIndx;
            int minWidth;
            int srcHeight;
            int srcWidth;
            block25: {
                block24: {
                    block23: {
                        block21: {
                            srcWidth = bitmap.width;
                            srcHeight = bitmap.height;
                            minWidth = srcWidth;
                            if (x + srcWidth > this.width) {
                                minWidth = this.width - x;
                            }
                            if (y + srcHeight > this.height) {
                                srcHeight = this.height - y;
                            }
                            srcIndx = 0;
                            indx = y * this.width + x;
                            if (combOp != 0L) break block21;
                            if (x == 0 && y == 0 && srcHeight == this.height && srcWidth == this.width) {
                                for (int i = 0; i < this.data.w.length; ++i) {
                                    int n = i;
                                    this.data.w[n] = this.data.w[n] | bitmap.data.w[i];
                                }
                            }
                            for (int row = y; row < y + srcHeight; ++row) {
                                indx = row * this.width + x;
                                this.data.or(indx, bitmap.data, srcIndx, minWidth);
                                srcIndx += srcWidth;
                            }
                            break block22;
                        }
                        if (combOp != 1L) break block23;
                        if (x == 0 && y == 0 && srcHeight == this.height && srcWidth == this.width) {
                            for (int i = 0; i < this.data.w.length; ++i) {
                                int n = i;
                                this.data.w[n] = this.data.w[n] & bitmap.data.w[i];
                            }
                        }
                        for (int row = y; row < y + srcHeight; ++row) {
                            indx = row * this.width + x;
                            for (int col = 0; col < minWidth; ++col) {
                                this.data.set(indx, bitmap.data.get(srcIndx + col) && this.data.get(indx));
                                ++indx;
                            }
                            srcIndx += srcWidth;
                        }
                        break block22;
                    }
                    if (combOp != 2L) break block24;
                    if (x == 0 && y == 0 && srcHeight == this.height && srcWidth == this.width) {
                        for (int i = 0; i < this.data.w.length; ++i) {
                            int n = i;
                            this.data.w[n] = this.data.w[n] ^ bitmap.data.w[i];
                        }
                    } else {
                        for (int row = y; row < y + srcHeight; ++row) {
                            indx = row * this.width + x;
                            for (int col = 0; col < minWidth; ++col) {
                                this.data.set(indx, bitmap.data.get(srcIndx + col) ^ this.data.get(indx));
                                ++indx;
                            }
                            srcIndx += srcWidth;
                        }
                    }
                    break block22;
                }
                if (combOp != 3L) break block25;
                for (int row = y; row < y + srcHeight; ++row) {
                    indx = row * this.width + x;
                    for (int col = 0; col < minWidth; ++col) {
                        boolean srcPixel = bitmap.data.get(srcIndx + col);
                        boolean pixel = this.data.get(indx);
                        this.data.set(indx, pixel == srcPixel);
                        ++indx;
                    }
                    srcIndx += srcWidth;
                }
                break block22;
            }
            if (combOp != 4L) break block22;
            if (x == 0 && y == 0 && srcHeight == this.height && srcWidth == this.width) {
                for (int i = 0; i < this.data.w.length; ++i) {
                    this.data.w[i] = bitmap.data.w[i];
                }
            } else {
                for (int row = y; row < y + srcHeight; ++row) {
                    indx = row * this.width + x;
                    for (int col = 0; col < minWidth; ++col) {
                        this.data.set(indx, bitmap.data.get(srcIndx + col));
                        ++srcIndx;
                        ++indx;
                    }
                    srcIndx += srcWidth;
                }
            }
        }
    }

    private void duplicateRow(int yDest, int ySrc) {
        for (int i = 0; i < this.width; ++i) {
            this.setPixel(i, yDest, this.getPixel(i, ySrc));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getData(boolean switchPixelColor) {
        byte[] bytes = new byte[this.height * this.line];
        int count = 0;
        int offset = 0;
        long k = 0L;
        for (int row = 0; row < this.height; ++row) {
            for (int col = 0; col < this.width; ++col) {
                if ((count & 0x3F) == 0) {
                    k = this.data.w[count >>> 6];
                }
                int bit = 7 - (offset & 7);
                int n = offset >> 3;
                bytes[n] = (byte)((long)bytes[n] | (k >>> count & 1L) << bit);
                ++count;
                ++offset;
            }
            offset = this.line * 8 * (row + 1);
        }
        if (switchPixelColor) {
            int i = 0;
            while (i < bytes.length) {
                int n = i++;
                bytes[n] = (byte)(bytes[n] ^ 0xFF);
            }
        }
        return bytes;
    }

    public JBIG2Bitmap getSlice(int x, int y, int width, int height) {
        JBIG2Bitmap slice = new JBIG2Bitmap(width, height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
        int sliceIndx = 0;
        for (int row = y; row < height; ++row) {
            int indx = row * this.width + x;
            for (int col = x; col < x + width; ++col) {
                if (this.data.get(indx)) {
                    slice.data.set(sliceIndx);
                }
                ++sliceIndx;
                ++indx;
            }
        }
        return slice;
    }

    private void setPixel(int col, int row, FastBitSet data, int value) {
        int index = row * this.width + col;
        data.set(index, value == 1);
    }

    public void setPixel(int col, int row, int value) {
        this.setPixel(col, row, this.data, value);
    }

    public int getPixel(int col, int row) {
        return this.data.get(row * this.width + col) ? 1 : 0;
    }

    public void expand(int newHeight, int defaultPixel) {
        FastBitSet newData = new FastBitSet(newHeight * this.width);
        for (int row = 0; row < this.height; ++row) {
            for (int col = 0; col < this.width; ++col) {
                this.setPixel(col, row, newData, this.getPixel(col, row));
            }
        }
        this.height = newHeight;
        this.data = newData;
    }

    public void setBitmapNumber(int segmentNumber) {
        this.bitmapNumber = segmentNumber;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public BufferedImage getBufferedImage() {
        byte[] bytes = this.getData(true);
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        byte[] copy = new byte[len];
        System.arraycopy(bytes, 0, copy, 0, len);
        DataBufferByte db = new DataBufferByte(copy, copy.length);
        WritableRaster raster = Raster.createPackedRaster(db, this.width, this.height, 1, null);
        BufferedImage image = new BufferedImage(this.width, this.height, 12);
        image.setData(raster);
        return image;
    }

    static final class FastBitSet {
        long[] w;
        static final int pot = 6;
        static final int mask = 63;
        int length;

        public FastBitSet(int length) {
            this.length = length;
            int wcount = length / 64;
            if (length % 64 != 0) {
                ++wcount;
            }
            this.w = new long[wcount];
        }

        public final int size() {
            return this.length;
        }

        public void setAll(boolean value) {
            if (value) {
                for (int i = 0; i < this.w.length; ++i) {
                    this.w[i] = -1L;
                }
            } else {
                for (int i = 0; i < this.w.length; ++i) {
                    this.w[i] = 0L;
                }
            }
        }

        public void set(int start, int end, boolean value) {
            if (value) {
                for (int i = start; i < end; ++i) {
                    this.set(i);
                }
            } else {
                for (int i = start; i < end; ++i) {
                    this.clear(i);
                }
            }
        }

        public void or(int startindex, FastBitSet set, int setStartIndex, int length) {
            int shift = startindex - setStartIndex;
            long k = set.w[setStartIndex >> 6];
            k = k << shift | k >>> 64 - shift;
            if ((setStartIndex & 0x3F) + length <= 64) {
                setStartIndex += shift;
                for (int i = 0; i < length; ++i) {
                    int n = startindex >>> 6;
                    this.w[n] = this.w[n] | k & 1L << setStartIndex;
                    ++setStartIndex;
                    ++startindex;
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    if ((setStartIndex & 0x3F) == 0) {
                        k = set.w[setStartIndex >> 6];
                        k = k << shift | k >>> 64 - shift;
                    }
                    int n = startindex >>> 6;
                    this.w[n] = this.w[n] | k & 1L << setStartIndex + shift;
                    ++setStartIndex;
                    ++startindex;
                }
            }
        }

        public void set(int index, boolean value) {
            if (value) {
                this.set(index);
            } else {
                this.clear(index);
            }
        }

        public void set(int index) {
            int windex;
            int n = windex = index >>> 6;
            this.w[n] = this.w[n] | 1L << index;
        }

        public void clear(int index) {
            int windex;
            int n = windex = index >>> 6;
            this.w[n] = this.w[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public final boolean get(int index) {
            int windex = index >>> 6;
            return (this.w[windex] & 1L << index) != 0L;
        }
    }
}

