/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.layers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.layers.Layer;
import org.jpedal.objects.raw.OCObject;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;

public class PdfLayerList {
    private static boolean debug = false;
    private int OCpageNumber = -1;
    private String padding = "";
    public static String deliminator = "\uffff";
    private Map layerNames = new LinkedHashMap();
    private Map streamToName = new HashMap();
    private Map layersEnabled = new HashMap();
    private Map jsCommands = null;
    private Map metaData = new HashMap();
    private Map layersTested = new HashMap();
    private Map layerLocks = new HashMap();
    private boolean changesMade = false;
    private Map propertyMap;
    private Map refToPropertyID;
    private Map refTolayerName;
    private Map RBconstraints;
    private Map minScale = new HashMap();
    private Map maxScale = new HashMap();
    private int layerCount = 0;
    private Object[] order;
    private PdfObjectReader currentPdfFile = null;
    private Layer[] layers = null;

    public void init(PdfObject OCProperties, PdfObject PropertiesObj, PdfObjectReader currentPdfFile, int pageNumber) {
        String val;
        PdfObject layerDict;
        this.OCpageNumber = pageNumber;
        this.propertyMap = new HashMap();
        this.refToPropertyID = new HashMap();
        this.refTolayerName = new HashMap();
        this.RBconstraints = new HashMap();
        this.currentPdfFile = currentPdfFile;
        if (PropertiesObj != null) {
            this.setupOCMaps(PropertiesObj, currentPdfFile);
        }
        if ((layerDict = OCProperties.getDictionary(20)) == null) {
            return;
        }
        int OCBaseState = layerDict.getNameAsConstant(1970567530);
        if (OCBaseState == -1) {
            OCBaseState = 7966;
        }
        this.order = layerDict.getObjectArray(1110717793);
        if (debug) {
            System.out.println("PropertiesObj=" + PropertiesObj);
            System.out.println("layerDict=" + layerDict);
            System.out.println("propertyMap=" + this.propertyMap);
            System.out.println("propertyMap=" + this.propertyMap);
            System.out.println("refToPropertyID=" + this.refToPropertyID);
            System.out.println("refTolayerName=" + this.refTolayerName);
            System.out.println("OCBaseState=" + OCBaseState + " (ON=" + 7966 + ')');
            System.out.println("order=" + this.order);
            PdfLayerList.showValues("ON=", 7966, layerDict);
            PdfLayerList.showValues("OFF=", 0x1F1616, layerDict);
            PdfLayerList.showValues("RBGroups=", 1633113989, layerDict);
        }
        this.addLayer(OCBaseState, this.order, null);
        if (OCBaseState != 7966) {
            this.addLayer(7966, layerDict.getKeyArray(7966), null);
        }
        if (OCBaseState != 0x1F1616) {
            this.addLayer(0x1F1616, layerDict.getKeyArray(0x1F1616), null);
        }
        if (OCBaseState == 7966) {
            for (Object ref : this.refToPropertyID.keySet()) {
                Object layerName = this.refToPropertyID.get(ref);
                this.refTolayerName.put(ref, layerName);
                if (this.layersTested.containsKey(layerName)) continue;
                this.layersTested.put(layerName, "x");
                this.layersEnabled.put(layerName, "x");
            }
        }
        this.setLocks(currentPdfFile, layerDict.getKeyArray(859525491));
        this.setConstraints(layerDict.getKeyArray(1633113989));
        this.setAS(layerDict.getKeyArray(4387), currentPdfFile);
        Object keys = new int[]{506543413, 827818359};
        String[] titles = new String[]{"Name", "Creator"};
        int count = ((Object)keys).length;
        for (int jj = 0; jj < count; ++jj) {
            val = layerDict.getTextStreamValue((int)keys[jj]);
            if (val == null) continue;
            this.metaData.put(titles[jj], val);
        }
        val = layerDict.getName(964196217);
        if (val != null) {
            this.metaData.put("ListMode", val);
        }
    }

    private static void showValues(String s, int key, PdfObject layerDict) {
        byte[][] keyValues = layerDict.getKeyArray(key);
        if (keyValues != null) {
            String values = "";
            for (byte[] keyValue : keyValues) {
                values = keyValue == null ? values + "null " : values + new String(keyValue) + ' ';
            }
            System.out.println(s + values);
        }
    }

    public void setChangesMade(boolean flag) {
        this.changesMade = flag;
    }

    private void setConstraints(byte[][] layer) {
        int ii;
        if (layer == null) {
            return;
        }
        int layerCount = layer.length;
        String[] layers = new String[layerCount];
        for (ii = 0; ii < layerCount; ++ii) {
            String ref = new String(layer[ii]);
            layers[ii] = (String)this.refTolayerName.get(ref);
        }
        for (ii = 0; ii < layerCount; ++ii) {
            if (!this.isLayerName(layers[ii])) continue;
            String effectedLayers = "";
            for (int ii2 = 0; ii2 < layerCount; ++ii2) {
                if (ii == ii2) continue;
                effectedLayers = effectedLayers + layers[ii2] + ',';
            }
            this.RBconstraints.put(layers[ii], effectedLayers);
        }
    }

    private void setupOCMaps(PdfObject propertiesObj, PdfObjectReader currentPdfFile) {
        PdfKeyPairsIterator keyPairs = propertiesObj.getKeyPairsIterator();
        while (keyPairs.hasMorePairs()) {
            String glyphKey = keyPairs.getNextKeyAsString();
            PdfObject glyphObj = keyPairs.getNextValueAsDictionary();
            String ref = glyphObj.getObjectRefAsString();
            currentPdfFile.checkResolved(glyphObj);
            byte[][] childPairs = glyphObj.getKeyArray(521344835);
            if (childPairs != null) {
                this.setupchildOCMaps(childPairs, glyphKey, currentPdfFile);
            } else {
                this.propertyMap.put(ref, glyphObj);
                String currentNames = (String)this.refToPropertyID.get(ref);
                if (currentNames == null) {
                    this.refToPropertyID.put(ref, glyphKey);
                } else {
                    this.refToPropertyID.put(ref, currentNames + ',' + glyphKey);
                }
            }
            keyPairs.nextPair();
        }
    }

    private void setupchildOCMaps(byte[][] keys, String glyphKey, PdfObjectReader currentPdfFile) {
        for (byte[] key : keys) {
            String ref = new String(key);
            OCObject glyphObj = new OCObject(ref);
            currentPdfFile.readObject(glyphObj);
            currentPdfFile.checkResolved(glyphObj);
            byte[][] childPairs = ((PdfObject)glyphObj).getKeyArray(521344835);
            if (childPairs != null) {
                this.setupchildOCMaps(childPairs, glyphKey, currentPdfFile);
                continue;
            }
            this.propertyMap.put(ref, glyphObj);
            String currentNames = (String)this.refToPropertyID.get(ref);
            if (currentNames == null) {
                this.refToPropertyID.put(ref, glyphKey);
                continue;
            }
            this.refToPropertyID.put(ref, currentNames + ',' + glyphKey);
        }
    }

    private void addLayer(int status, Object[] layer, String parentName) {
        int len;
        if (layer == null) {
            return;
        }
        if (debug) {
            this.padding = this.padding + "   ";
        }
        int layers = layer.length;
        String layerName = null;
        for (int ii = 0; ii < layers; ++ii) {
            if (layer[ii] instanceof String) continue;
            if (layer[ii] instanceof byte[]) {
                byte[] rawRef = (byte[])layer[ii];
                String ref = new String(rawRef);
                String name = (String)this.refToPropertyID.get(ref);
                PdfObject nextObject = (PdfObject)this.propertyMap.get(ref);
                if (nextObject == null) {
                    if (rawRef != null && rawRef[rawRef.length - 1] == 82) {
                        nextObject = new OCObject(ref);
                        this.currentPdfFile.readObject(nextObject);
                        name = ref;
                    } else {
                        parentName = parentName == null ? ref : ref + deliminator + parentName;
                    }
                }
                if (nextObject == null) continue;
                ++this.layerCount;
                layerName = nextObject.getTextStreamValue(506543413);
                if (parentName != null) {
                    layerName = layerName + deliminator + parentName;
                }
                if (debug) {
                    System.out.println(this.padding + "[layer1] add layer=" + layerName + " ref=" + ref + " parent=" + parentName + " refToLayerName=" + this.refTolayerName.get(ref) + " ref=" + ref);
                }
                this.refTolayerName.put(ref, layerName);
                layer[ii] = layerName;
                this.layerNames.put(layerName, status);
                if (name.indexOf(44) == -1) {
                    String oldValue = (String)this.streamToName.get(name);
                    if (oldValue == null) {
                        this.streamToName.put(name, layerName);
                    } else {
                        this.streamToName.put(name, oldValue + ',' + layerName);
                    }
                } else {
                    StringTokenizer names = new StringTokenizer(name, ",");
                    while (names.hasMoreTokens()) {
                        name = names.nextToken();
                        String oldValue = (String)this.streamToName.get(name);
                        if (oldValue == null) {
                            this.streamToName.put(name, layerName);
                            continue;
                        }
                        this.streamToName.put(name, oldValue + ',' + layerName);
                    }
                }
                if (status == 7966) {
                    this.layersEnabled.put(layerName, "x");
                    continue;
                }
                this.layersEnabled.remove(layerName);
                continue;
            }
            this.addLayer(status, (Object[])layer[ii], layerName);
        }
        if (debug && (len = this.padding.length()) > 3) {
            this.padding = this.padding.substring(0, len - 3);
        }
    }

    private void addLayer(int status, byte[][] layer, String parentName) {
        if (layer == null) {
            return;
        }
        for (byte[] aLayer : layer) {
            String possName;
            String ref = new String(aLayer);
            String name = (String)this.refToPropertyID.get(ref);
            PdfObject nextObject = (PdfObject)this.propertyMap.get(ref);
            if (nextObject == null) continue;
            ++this.layerCount;
            String layerName = nextObject.getTextStreamValue(506543413);
            if (parentName != null) {
                layerName = layerName + deliminator + parentName;
            }
            if ((status == 7966 || status == 0x1F1616) && (possName = (String)this.refTolayerName.get(ref)) != null) {
                layerName = possName;
            }
            if (debug) {
                System.out.println(this.padding + "[layer0] add layer=" + layerName + " ref=" + ref + " parent=" + parentName + " refToLayerName=" + this.refTolayerName.get(ref) + " status=" + status);
            }
            if (this.refTolayerName.get(ref) == null) {
                this.refTolayerName.put(ref, layerName);
                this.layerNames.put(layerName, status);
            }
            if (this.streamToName.get(name) == null) {
                if (name.indexOf(44) == -1) {
                    String oldValue = (String)this.streamToName.get(name);
                    if (oldValue == null) {
                        this.streamToName.put(name, layerName);
                    } else {
                        this.streamToName.put(name, oldValue + ',' + layerName);
                    }
                } else {
                    StringTokenizer names = new StringTokenizer(name, ",");
                    while (names.hasMoreTokens()) {
                        name = names.nextToken();
                        String oldValue = (String)this.streamToName.get(name);
                        if (oldValue == null) {
                            this.streamToName.put(name, layerName);
                            continue;
                        }
                        this.streamToName.put(name, oldValue + ',' + layerName);
                    }
                }
            }
            if (status == 7966) {
                this.layersEnabled.put(layerName, "x");
            } else {
                this.layersEnabled.remove(layerName);
            }
            this.layersTested.put(layerName, "x");
        }
    }

    private void setAS(byte[][] AS, PdfObjectReader currentPdfFile) {
        if (AS == null) {
            return;
        }
        for (byte[] A : AS) {
            byte[][] OCGs;
            if (A == null) continue;
            String ref = new String(A);
            OCObject nextObject = new OCObject(ref);
            if (A[0] == 60) {
                nextObject.setStatus(2);
            } else {
                nextObject.setStatus(1);
            }
            nextObject.setUnresolvedData(A, 4387);
            currentPdfFile.checkResolved(nextObject);
            int event = ((PdfObject)nextObject).getParameterConstant(1177894489);
            if (nextObject == null || event != 641283399 || (OCGs = ((PdfObject)nextObject).getKeyArray(521344835)) == null) continue;
            for (byte[] OCG : OCGs) {
                float max;
                PdfObject zoomObj;
                ref = new String(OCG);
                nextObject = new OCObject(ref);
                if (OCG[0] == 60) {
                    nextObject.setStatus(2);
                } else {
                    nextObject.setStatus(1);
                }
                nextObject.setUnresolvedData(OCG, 521344835);
                currentPdfFile.checkResolved(nextObject);
                String layerName = ((PdfObject)nextObject).getTextStreamValue(506543413);
                String name = (String)this.refToPropertyID.get(ref);
                this.streamToName.put(name, layerName);
                PdfObject usageObj = ((PdfObject)nextObject).getDictionary(1127298906);
                if (usageObj == null || (zoomObj = usageObj.getDictionary(708788029)) == null) continue;
                float min = zoomObj.getFloatNumber(4012350);
                if (min != 0.0f) {
                    this.minScale.put(layerName, Float.valueOf(min));
                }
                if ((max = zoomObj.getFloatNumber(4010312)) == 0.0f) continue;
                this.maxScale.put(layerName, Float.valueOf(max));
            }
        }
    }

    private void setLocks(PdfObjectReader currentPdfFile, byte[][] layer) {
        if (layer == null) {
            return;
        }
        for (byte[] aLayer : layer) {
            String nextValue = new String(aLayer);
            OCObject nextObject = new OCObject(nextValue);
            currentPdfFile.readObject(nextObject);
            String layerName = ((PdfObject)nextObject).getTextStreamValue(506543413);
            this.layerLocks.put(layerName, "x");
        }
    }

    public Map getMetaData() {
        return this.metaData;
    }

    public Object[] getDisplayTree() {
        if (this.order != null) {
            return this.order;
        }
        return this.getNames();
    }

    private String[] getNames() {
        int count = this.layerNames.size();
        String[] nameList = new String[count];
        Iterator names = this.layerNames.keySet().iterator();
        int jj = 0;
        while (names.hasNext()) {
            nameList[jj] = names.next().toString();
            ++jj;
        }
        return nameList;
    }

    public void setVisibleLayers(String[] layerNames) {
        this.layersEnabled.clear();
        if (layerNames != null) {
            for (String layerName : layerNames) {
                this.layersEnabled.put(layerName, "x");
            }
        }
        this.changesMade = true;
    }

    public boolean decodeLayer(String name, boolean isID) {
        String layerName;
        boolean isLayerVisible;
        block7: {
            block6: {
                String mappedName;
                if (this.layerCount == 0) {
                    return true;
                }
                isLayerVisible = false;
                layerName = name;
                if (isID && (mappedName = (String)this.streamToName.get(name)) != null) {
                    layerName = mappedName;
                }
                if (layerName == null) {
                    return false;
                }
                if (layerName.indexOf(44) != -1) break block6;
                isLayerVisible = this.layersEnabled.containsKey(layerName);
                if (!isLayerVisible) break block7;
                isLayerVisible = this.hiddenByParent(isLayerVisible, layerName);
                break block7;
            }
            StringTokenizer names = new StringTokenizer(layerName, ",");
            while (names.hasMoreTokens()) {
                String nextName = names.nextToken();
                isLayerVisible = this.layersEnabled.containsKey(nextName);
                if (isLayerVisible) {
                    isLayerVisible = this.hiddenByParent(isLayerVisible, nextName);
                }
                if (!isLayerVisible) continue;
                break;
            }
        }
        if (debug) {
            System.out.println("[isVisible] " + name + " decode=" + isLayerVisible + " enabled=" + this.layersEnabled + " layerName=" + layerName + " isEnabled=" + this.layersEnabled);
        }
        return isLayerVisible;
    }

    private boolean hiddenByParent(boolean layerVisible, String layerName) {
        int id = layerName.indexOf(deliminator);
        if (layerVisible && id != -1) {
            String parent = layerName.substring(id + 1, layerName.length());
            while (parent != null && layerVisible && this.isLayerName(parent)) {
                layerVisible = this.decodeLayer(parent, false);
                layerName = parent;
                id = layerName.indexOf(deliminator);
                if (id == -1) {
                    parent = null;
                    continue;
                }
                parent = layerName.substring(id + 1, layerName.length());
            }
        }
        return layerVisible;
    }

    public boolean setZoom(float scaling) {
        String layerName;
        Iterator minZoomLayers = this.minScale.keySet().iterator();
        while (minZoomLayers.hasNext()) {
            layerName = (String)minZoomLayers.next();
            Float minScalingValue = (Float)this.minScale.get(layerName);
            if (minScalingValue == null) continue;
            if (scaling < minScalingValue.floatValue()) {
                this.layersEnabled.remove(layerName);
                this.changesMade = true;
                continue;
            }
            if (this.layersEnabled.containsKey(layerName)) continue;
            this.layersEnabled.put(layerName, "x");
            this.changesMade = true;
        }
        Iterator maxZoomLayers = this.maxScale.keySet().iterator();
        while (maxZoomLayers.hasNext()) {
            layerName = (String)minZoomLayers.next();
            Float maxScalingValue = (Float)this.maxScale.get(layerName);
            if (maxScalingValue == null) continue;
            if (scaling > maxScalingValue.floatValue()) {
                this.layersEnabled.remove(layerName);
                this.changesMade = true;
                continue;
            }
            if (this.layersEnabled.containsKey(layerName)) continue;
            this.layersEnabled.put(layerName, "x");
            this.changesMade = true;
        }
        return this.changesMade;
    }

    public boolean isVisible(String layerName) {
        return this.layersEnabled.containsKey(layerName);
    }

    public void setVisiblity(String layerName, boolean isVisible) {
        if (debug) {
            System.out.println("[layer] setVisiblity=" + layerName + " isVisible=" + isVisible);
        }
        if (isVisible) {
            this.layersEnabled.put(layerName, "x");
            String layersToDisable = (String)this.RBconstraints.get(layerName);
            if (layersToDisable != null) {
                StringTokenizer layers = new StringTokenizer(layersToDisable, ",");
                while (layers.hasMoreTokens()) {
                    this.layersEnabled.remove(layers.nextToken());
                }
            }
        } else {
            this.layersEnabled.remove(layerName);
        }
        this.changesMade = true;
    }

    public boolean isVisible(PdfObject XObject2) {
        boolean isVisible = true;
        PdfObject layerObj = XObject2.getDictionary(7955);
        if (layerObj != null) {
            String layerName = null;
            byte[][] OCGS = layerObj.getKeyArray(521344835);
            if (OCGS != null) {
                for (byte[] OCG : OCGS) {
                    String ref = new String(OCG);
                    layerName = this.getNameFromRef(ref);
                }
            }
            if (layerName == null) {
                layerName = layerObj.getTextStreamValue(506543413);
            }
            if (layerName != null && this.isLayerName(layerName)) {
                isVisible = this.isVisible(layerName);
            }
        }
        return isVisible;
    }

    public boolean isLocked(String layerName) {
        return this.layerLocks.containsKey(layerName);
    }

    public boolean getChangesMade() {
        return this.changesMade;
    }

    public boolean isLayerName(String name) {
        return this.layerNames.containsKey(name);
    }

    public int getLayersCount() {
        return this.layerCount;
    }

    public String getNameFromRef(String ref) {
        return (String)this.refTolayerName.get(ref);
    }

    public Object[] getOCGs() {
        return this.getOCGs(-1);
    }

    public Object[] getOCGs(int page) {
        if (this.layers != null) {
            return this.layers;
        }
        int count = this.layerNames.size();
        Object[] layers = new Layer[count];
        Iterator layersIt = this.layerNames.keySet().iterator();
        int ii = 0;
        while (layersIt.hasNext()) {
            String name = (String)layersIt.next();
            layers[ii] = new Layer(name, this);
            ++ii;
        }
        return layers;
    }

    public void addJScommand(String name, String js) {
        if (this.jsCommands == null) {
            this.jsCommands = new HashMap();
        }
        this.jsCommands.put(name, js);
    }

    public Iterator getJSCommands() {
        if (this.jsCommands != null) {
            Iterator names = this.jsCommands.keySet().iterator();
            HashMap visibleJSCommands = new HashMap();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (!this.isVisible(name)) continue;
                visibleJSCommands.put(this.jsCommands.get(name), "x");
            }
            return visibleJSCommands.keySet().iterator();
        }
        return null;
    }

    public int getOCpageNumber() {
        return this.OCpageNumber;
    }
}

