/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.util.Arrays;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;

public class PdfKeyPairsIterator {
    private byte[][] keys;
    private byte[][] values;
    private PdfObject[] objs;
    int maxCount;
    int current = 0;

    public PdfKeyPairsIterator(byte[][] keys, byte[][] values, PdfObject[] objs) {
        this.keys = keys;
        this.values = values;
        this.objs = objs;
        if (keys != null) {
            this.maxCount = keys.length;
        }
        this.current = 0;
    }

    public int getTokenCount() {
        return this.maxCount;
    }

    public void nextPair() {
        if (this.current < this.maxCount) {
            ++this.current;
        } else {
            throw new RuntimeException("No keys left in PdfKeyPairsIterator");
        }
    }

    public String getNextKeyAsString() {
        return new String(this.keys[this.current]);
    }

    public int getNextKeyAsNumber() {
        int length = this.keys[this.current].length;
        boolean isNumber = this.isNextKeyANumber();
        if (!isNumber) {
            if (this.keys[this.current].length != 1) {
                String key = new String(this.keys[this.current]);
                PdfObject value = this.objs[this.current];
                int mapping = StandardFonts.lookupCharacterIndex(key, 2);
                if (mapping == 0) {
                    throw new RuntimeException("Unexpected value in getNextKeyAsNumber >" + new String(this.keys[this.current]) + '<');
                }
                return mapping;
            }
            return this.keys[this.current][0] & 0xFF;
        }
        return NumberUtils.parseInt(0, length, this.keys[this.current]);
    }

    public boolean isNextKeyANumber() {
        int length = this.keys[this.current].length;
        boolean isNumber = true;
        for (int ii = 0; ii < length; ++ii) {
            byte nextChar = this.keys[this.current][ii];
            if (nextChar >= 48 && nextChar <= 57) continue;
            isNumber = false;
            ii = length;
        }
        return isNumber;
    }

    public boolean hasMorePairs() {
        return this.current < this.maxCount;
    }

    public String getNextValueAsString() {
        if (this.values[this.current] == null) {
            return null;
        }
        return new String(this.values[this.current]);
    }

    public PdfObject getNextValueAsDictionary() {
        return this.objs[this.current];
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("PdfKeyPairsIterator [");
        if (this.keys != null) {
            builder.append("keys=");
            for (i = 0; i < this.keys.length; ++i) {
                builder.append(new String(this.keys[i]));
                builder.append(", ");
            }
        }
        if (this.values != null) {
            builder.append("values=");
            for (i = 0; i < this.keys.length; ++i) {
                builder.append(new String(this.values[i]).substring(0, 30));
                builder.append("... (shortened)");
                builder.append(", ");
            }
        }
        if (this.objs != null) {
            builder.append("objs=");
            builder.append(Arrays.toString(this.objs));
            builder.append(", ");
        }
        builder.append("maxCount=");
        builder.append(this.maxCount);
        builder.append(", current=");
        builder.append(this.current);
        builder.append("]");
        return builder.toString();
    }
}

