/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MarkedContentGenerator {
    private PdfObjectReader currentPdfFile;
    private DocumentBuilder db = null;
    private Document doc;
    private Element root;
    private Map pageStreams = new HashMap();
    private PdfObject structTreeRootObj;
    private PdfResources res;
    private PdfLayerList layers;
    private PdfPageData pdfPageData;
    private boolean isDecoding = false;

    public Document getMarkedContentTree(PdfResources res, PdfPageData pdfPageData, PdfObjectReader currentPdfFile) {
        this.structTreeRootObj = res.getPdfObject(3);
        this.res = res;
        this.layers = res.getPdfLayerList();
        this.pdfPageData = pdfPageData;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void decodePageForMarkedContent(int pageNumber, PdfObject pdfObject, Object pageStream) throws Exception {
        if (this.isDecoding) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF]WARNING - this file is being decoded already");
            }
        } else {
            if (pdfObject == null) {
                String currentPageOffset = this.currentPdfFile.getReferenceforPage(pageNumber);
                pdfObject = new PageObject(currentPageOffset);
                this.currentPdfFile.readObject(pdfObject);
            } else {
                pageNumber = this.currentPdfFile.convertObjectToPageNumber(new String(pdfObject.getUnresolvedData()));
                this.currentPdfFile.checkResolved(pdfObject);
            }
            try {
                this.isDecoding = true;
                if (pdfObject != null) {
                    ObjectStore objectStoreRef = new ObjectStore(null);
                    PdfStreamDecoder current = new PdfStreamDecoder(this.currentPdfFile, false, this.layers);
                    current.setParameters(true, false, 0, 7);
                    current.setXMLExtraction(false);
                    current.setObjectValue(-9, "markedContent");
                    current.setObjectValue(-8, objectStoreRef);
                    current.setObjectValue(-3, null);
                    current.setObjectValue(-18, this.pdfPageData);
                    current.setIntValue(-10, pageNumber);
                    this.res.setupResources(current, false, pdfObject.getDictionary(2004251818), pageNumber, this.currentPdfFile);
                    current.setObjectValue(-5, pageStream);
                    current.decodePageContent(pdfObject);
                    objectStoreRef.flush();
                }
            }
            catch (Exception e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            finally {
                this.isDecoding = false;
            }
        }
    }
}

