/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.images.ImageOps;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;

public class ImageCommands {
    public static final int ID = 0;
    public static final int XOBJECT = 2;
    static boolean sharpenDownsampledImages;
    static boolean JAImessageShow;
    public static boolean trackImages;
    public static boolean rejectSuperimposedImages;

    static BufferedImage addMaskObject(GenericColorSpace decodeColorData, int d, boolean isDCT, boolean isJPX, BufferedImage image, int colorspaceID, byte[] index, PdfObject newMask, int optionsApplied, PdfObjectReader currentPdfFile) {
        int[] maskArray = newMask.getIntArray(489767739);
        if (maskArray != null && image.getWidth() == 1 && image.getHeight() == 1 && maskArray[0] == maskArray[1]) {
            return null;
        }
        if (maskArray != null && maskArray.length == 2 && maskArray[0] == maskArray[1] && maskArray[0] > 0 && index != null && index[maskArray[0]] == 0 && decodeColorData.getIndexedMap().length == 768) {
            maskArray = null;
        }
        if (maskArray != null) {
            int colorComponents = decodeColorData.getColorComponentCount();
            if (index != null) {
                int itemCount = maskArray.length;
                int[] newIndex = new int[colorComponents * itemCount];
                for (int jj = 0; jj < itemCount; ++jj) {
                    int indexValue = maskArray[jj];
                    for (int i = 0; i < colorComponents; ++i) {
                        newIndex[i + jj * colorComponents] = index[indexValue * colorComponents + i] & 0xFF;
                    }
                }
                maskArray = newIndex;
            }
            if (image.getType() == 10 && maskArray.length == 6 && maskArray[0] == maskArray[1] && maskArray[2] == maskArray[3] && maskArray[4] == maskArray[5]) {
                DataBufferByte data = (DataBufferByte)image.getRaster().getDataBuffer();
                byte[] rawImageData = data.getData();
                int length = rawImageData.length;
                for (int ii = 0; ii < length; ++ii) {
                    rawImageData[ii] = (byte)(rawImageData[ii] ^ 0xFF);
                }
                int[] bands = new int[]{0};
                int w = image.getWidth();
                int h = image.getHeight();
                WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(rawImageData, length), w, h, w, 1, bands, null);
                image.setData(raster);
            } else {
                image = ImageCommands.convertPixelsToTransparent(image, maskArray);
            }
        } else {
            int both;
            byte[] objectData = currentPdfFile.readStream(newMask, true, true, false, false, false, newMask.getCacheName(currentPdfFile.getObjectReader()));
            int maskW = newMask.getInt(959726687);
            int maskH = newMask.getInt(959926393);
            float[] maskDecodeArray = newMask.getFloatArray(859785322);
            if (maskDecodeArray != null && (colorspaceID == 1785221209 || colorspaceID == -2073385820)) {
                ImageCommands.applyDecodeArray(objectData, maskDecodeArray.length / 2, maskDecodeArray, colorspaceID, newMask);
            }
            if ((optionsApplied & (both = 3)) == both) {
                int temp;
                byte[] processedData = ImageOps.rotateImage(objectData, maskW, maskH, 1, 1, null);
                if (processedData != null && (processedData = ImageOps.rotateImage(processedData, maskW = (temp = maskH), maskH = maskW, d, 1, null)) != null) {
                    temp = maskH;
                    maskH = maskW;
                    maskW = temp;
                }
                objectData = processedData;
            } else if ((optionsApplied & 1) == 1) {
                objectData = ImageOps.invertImage(objectData, maskW, maskH, 1, 1, null);
            }
            if ((optionsApplied & 2) == 2) {
                objectData = ImageOps.rotateImage(objectData, maskW, maskH, 1, 1, null);
            }
            if (objectData != null) {
                boolean isRGB;
                boolean needsConversion = decodeColorData != null && (decodeColorData.getID() == 1568372915 || decodeColorData.getID() == 1008872003) && !isJPX;
                boolean bl = isRGB = decodeColorData != null && decodeColorData.getID() == 1785221209;
                if (needsConversion && (decodeColorData.getID() == 1568372915 || decodeColorData.getID() == 1008872003) || !needsConversion && !isRGB && isDCT) {
                    PdfArrayIterator maskFilters = newMask.getMixedArray(1011108731);
                    boolean maskNeedsInversion = false;
                    if (maskFilters != null && maskFilters.hasMoreTokens()) {
                        while (maskFilters.hasMoreTokens()) {
                            int firstMaskValue = maskFilters.getNextValueAsConstant(true);
                            maskNeedsInversion = firstMaskValue == 2108391315 || firstMaskValue == 1247500931;
                        }
                    }
                    if (decodeColorData.getID() == 1008872003) {
                        boolean bl2 = maskNeedsInversion = !maskNeedsInversion;
                    }
                    if (!maskNeedsInversion) {
                        needsConversion = false;
                    } else if (needsConversion && decodeColorData.getID() == 1568372915) {
                        needsConversion = false;
                    }
                    if (maskDecodeArray != null && decodeColorData.getID() == 1568372915 && maskDecodeArray[0] == 1.0f && maskDecodeArray[1] == 0.0f) {
                        needsConversion = !needsConversion;
                    }
                }
                image = ImageCommands.overlayImage(image, objectData, newMask, needsConversion);
            }
        }
        return image;
    }

    static BufferedImage makeBlackandWhiteTransparent(BufferedImage image) {
        WritableRaster ras = image.getRaster();
        int w = ras.getWidth();
        int h = ras.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 2);
        boolean validPixelsFound = false;
        int[] values = new int[3];
        int[] transparentPixel = new int[]{255, 0, 0, 0};
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                boolean isBlack;
                ras.getPixels(x, y, 1, 1, values);
                boolean transparent = values[0] > 245 && values[1] > 245 && values[2] > 245;
                boolean bl = isBlack = values[0] < 10 && values[1] < 10 && values[2] < 10;
                if (transparent || isBlack) {
                    newImage.getRaster().setPixels(x, y, 1, 1, transparentPixel);
                    continue;
                }
                validPixelsFound = true;
                int[] newPixel = new int[4];
                newPixel[3] = 255;
                newPixel[0] = values[0];
                newPixel[1] = values[1];
                newPixel[2] = values[2];
                newImage.getRaster().setPixels(x, y, 1, 1, newPixel);
            }
        }
        if (validPixelsFound) {
            return newImage;
        }
        return null;
    }

    private static BufferedImage overlayImage(BufferedImage image, byte[] maskData, PdfObject newMask, boolean needsInversion) {
        image = ColorSpaceConvertor.convertToRGB(image);
        WritableRaster ras = image.getRaster();
        int maskW = newMask.getInt(959726687);
        int maskH = newMask.getInt(959926393);
        int width = image.getWidth();
        int height = image.getHeight();
        boolean isScaled = width != maskW || height != maskH;
        float scaling = 0.0f;
        if (isScaled) {
            float scalingW = (float)width / (float)maskW;
            float scalingH = (float)height / (float)maskH;
            scaling = scalingW > scalingH ? scalingW : scalingH;
        }
        BufferedImage newImage = new BufferedImage(maskW, maskH, 2);
        WritableRaster output = newImage.getRaster();
        int lineBytes = maskW;
        if ((lineBytes & 7) != 0) {
            lineBytes += 8;
        }
        lineBytes >>= 3;
        int bytes = 0;
        int[] bit = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
        for (int rawy = 0; rawy < maskH; ++rawy) {
            int y;
            if (isScaled) {
                y = (int)(scaling * (float)rawy);
                if (y > height) {
                    y = height;
                }
            } else {
                y = rawy;
            }
            for (int rawx = 0; rawx < maskW; ++rawx) {
                boolean isTransparent;
                int x;
                if (isScaled) {
                    x = (int)(scaling * (float)rawx);
                    if (x > width) {
                        x = height;
                    }
                } else {
                    x = rawx;
                }
                int xOffset = rawx >> 3;
                byte b = maskData[bytes + xOffset];
                if (needsInversion) {
                    isTransparent = (b & bit[rawx & 7]) == 0;
                } else {
                    boolean bl = isTransparent = (b & bit[rawx & 7]) != 0;
                }
                if (isTransparent || x >= width || y >= height) continue;
                int[] values = new int[3];
                values = ras.getPixel(x, y, values);
                output.setPixel(rawx, rawy, new int[]{values[0], values[1], values[2], 255});
            }
            bytes += lineBytes;
        }
        return newImage;
    }

    private static BufferedImage convertPixelsToTransparent(BufferedImage image, int[] maskArray) {
        WritableRaster ras = image.getRaster();
        int compCount = ras.getNumBands();
        image = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int[] values = new int[compCount];
                ras.getPixel(x, y, values);
                boolean isMatch = true;
                for (int aa = 0; aa < compCount; ++aa) {
                    if (maskArray[2 * aa] <= values[aa] && values[aa] <= maskArray[2 * aa + 1]) continue;
                    isMatch = false;
                    aa = compCount;
                }
                if (isMatch) continue;
                if (compCount == 1) {
                    image.getRaster().setPixel(x, y, new int[]{values[0], values[0], values[0], 255});
                    continue;
                }
                image.getRaster().setPixel(x, y, new int[]{values[0], values[1], values[2], 255});
            }
        }
        return image;
    }

    static BufferedImage simulateOP(BufferedImage image, boolean whiteIs255) {
        WritableRaster ras = image.getRaster();
        image = ColorSpaceConvertor.convertToARGB(image);
        int w = image.getWidth();
        int h = image.getHeight();
        boolean hasNoTransparent = false;
        int[] transparentPixel = new int[]{255, 0, 0, 0};
        int[] values = new int[4];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                boolean transparent;
                ras.getPixel(x, y, values);
                if (whiteIs255) {
                    transparent = values[0] > 243 && values[1] > 243 && values[2] > 243;
                } else {
                    boolean bl = transparent = values[1] < 3 && values[2] < 3 && values[3] < 3;
                }
                if (transparent) {
                    image.getRaster().setPixel(x, y, transparentPixel);
                    continue;
                }
                hasNoTransparent = true;
            }
        }
        if (hasNoTransparent) {
            return image;
        }
        return null;
    }

    static void getMaskColor(byte[] maskCol, GraphicsState gs) {
        int foreground = gs.nonstrokeColorSpace.getColor().getRGB();
        maskCol[0] = (byte)(foreground >> 16 & 0xFF);
        maskCol[1] = (byte)(foreground >> 8 & 0xFF);
        maskCol[2] = (byte)(foreground & 0xFF);
    }

    static boolean isRepeatingLine(byte[] lineData, int height) {
        if (lineData.length % height != 0) {
            return false;
        }
        int step = lineData.length / height;
        for (int x = 0; x < lineData.length / height - 1; ++x) {
            for (int targetIndex = step; targetIndex < lineData.length - 1; targetIndex += step) {
                if (lineData[x] == lineData[targetIndex]) continue;
                return false;
            }
        }
        return true;
    }

    public static BufferedImage applySmask(BufferedImage image, BufferedImage smask, PdfObject newSMask, boolean isForm, boolean isRGB, PdfObject ColorSpace2, PdfObject XObject2, GraphicsState gs) {
        int firstValue;
        PdfArrayIterator maskFilters = XObject2.getMixedArray(1011108731);
        boolean imageIsDCT = false;
        if (maskFilters != null && maskFilters.hasMoreTokens()) {
            while (maskFilters.hasMoreTokens()) {
                firstValue = maskFilters.getNextValueAsConstant(true);
                imageIsDCT = firstValue == 1180911742;
            }
        }
        boolean invert = !imageIsDCT && gs.CTM[1][1] > 0.0f && gs.CTM[0][0] < 0.0f;
        int imageType = image.getType();
        int[] gray = new int[]{0};
        int[] val = new int[]{0, 0, 0, 0};
        int[] transparentPixel = new int[]{0, 0, 0, 0};
        maskFilters = newSMask.getMixedArray(1011108731);
        boolean maskIsDCT = false;
        if (maskFilters != null && maskFilters.hasMoreTokens()) {
            while (maskFilters.hasMoreTokens()) {
                firstValue = maskFilters.getNextValueAsConstant(true);
                maskIsDCT = firstValue == 1180911742;
            }
        }
        boolean isDeviceGray = ColorSpace2 != null && ColorSpace2.getParameterConstant(2087749783) == 1568372915;
        boolean needsConversion = maskIsDCT && isDeviceGray;
        int type = -1;
        if (ColorSpace2 != null) {
            type = ColorSpace2.getParameterConstant(2087749783);
        }
        boolean bl = needsConversion = !needsConversion && isForm && ColorSpace2 != null && (type == 1498837125 || type == 1247168582);
        if (needsConversion) {
            smask = ColorSpaceConvertor.convertColorspace(smask, 10);
            val = gray;
        }
        if (smask == null) {
            return image;
        }
        WritableRaster mask = smask.getRaster();
        WritableRaster imgRas = null;
        boolean isConverted = false;
        int imageW = image.getWidth();
        int imageH = image.getHeight();
        int smaskW = smask.getWidth();
        int smaskH = smask.getHeight();
        float ratioW = 0.0f;
        float ratioH = 0.0f;
        if (imageW != smaskW || imageH != smaskH) {
            ratioW = (float)imageW / (float)smaskW;
            ratioH = (float)imageH / (float)smaskH;
            if (isRGB && (double)ratioW == 0.5 && (double)ratioH == 0.5) {
                BufferedImage resizedImage = new BufferedImage(smaskW, smaskH, image.getType());
                Graphics2D g = resizedImage.createGraphics();
                g.dispose();
                g.setComposite(AlphaComposite.Src);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.drawImage(image, 0, 0, smaskW, smaskH, null);
                image = resizedImage;
                imageW = smaskW;
                imageH = smaskH;
                ratioW = 1.0f;
                ratioH = 1.0f;
            }
        }
        int colorComponents = smask.getColorModel().getNumComponents();
        int[] values = new int[colorComponents];
        int[] pix = new int[4];
        int maskH = mask.getHeight();
        for (int y = 0; y < imageH; ++y) {
            for (int x = 0; x < imageW; ++x) {
                int line = invert && maskH >= imageH ? maskH - y - 1 : y;
                if (ratioW == 0.0f) {
                    mask.getPixels(x, line, 1, 1, values);
                } else {
                    mask.getPixels((int)((float)x / ratioW), (int)((float)line / ratioH), 1, 1, values);
                }
                boolean noMatch = false;
                if (colorComponents == 1) {
                    if (values[0] > 127 && maskIsDCT) {
                        noMatch = true;
                    }
                } else {
                    for (int comp = 0; comp < colorComponents; ++comp) {
                        if (values[comp] == val[comp]) continue;
                        comp = colorComponents;
                        noMatch = true;
                    }
                }
                if (noMatch) continue;
                if (!isConverted) {
                    image = ColorSpaceConvertor.convertToARGB(image);
                    imgRas = image.getRaster();
                    isConverted = true;
                }
                if (colorComponents == 1) {
                    imgRas.getPixels(x, y, 1, 1, pix);
                    if (values[0] == pix[0]) {
                        if (pix[0] == 255 && (imageType == 1 || imageType == 5 || imageType == 10) && isDeviceGray) {
                            imgRas.setPixels(x, y, 1, 1, new int[]{pix[0], pix[1], pix[2], values[0]});
                            continue;
                        }
                        imgRas.setPixels(x, y, 1, 1, transparentPixel);
                        continue;
                    }
                    imgRas.setPixels(x, y, 1, 1, new int[]{pix[0], pix[1], pix[2], values[0]});
                    continue;
                }
                imgRas.setPixels(x, y, 1, 1, transparentPixel);
            }
        }
        return image;
    }

    static BufferedImage simulateOverprint(GenericColorSpace decodeColorData, byte[] data, boolean isDCT, boolean isJPX, BufferedImage image, int colorspaceID, PdfObject newMask, PdfObject newSMask, DynamicVectorRenderer current, GraphicsState gs) {
        if ((colorspaceID == 1498837125 || colorspaceID == 1247168582) && gs.getOPM() == 1.0f) {
            boolean isBlank = false;
            byte[] index = decodeColorData.getIndexedMap();
            if (index == null && current.hasObjectsBehind(gs.CTM)) {
                isBlank = true;
                for (int ii = 0; ii < data.length; ++ii) {
                    if (data[ii] == 0) continue;
                    ii = data.length;
                    isBlank = false;
                }
            }
            if (isBlank) {
                image.flush();
                image = null;
            } else if ((isDCT || isJPX) && gs.getNonStrokeOP()) {
                image = ImageCommands.simulateOP(image, isJPX);
            } else if (isDCT && newSMask == null && newMask == null && (gs.nonstrokeColorSpace.getColor().getRGB() == -16777216 || gs.nonstrokeColorSpace.getColor().getRGB() == -1) && decodeColorData.isImageYCCK() && decodeColorData.getIntent() != null && decodeColorData.getIntent().equals("RelativeColorimetric")) {
                image = ImageCommands.simulateOP(image, true);
            } else if (gs.getNonStrokeOP()) {
                image = colorspaceID == 1498837125 ? ImageCommands.simulateOP(image, false) : ImageCommands.simulateOP(image, image.getType() == 1);
            }
        }
        return image;
    }

    static BufferedImage addBackgroundToMask(BufferedImage image, boolean isMask) {
        if (isMask) {
            int cw = image.getWidth();
            int ch = image.getHeight();
            BufferedImage background = new BufferedImage(cw, ch, 1);
            Graphics2D g2 = background.createGraphics();
            g2.setColor(Color.white);
            g2.fillRect(0, 0, cw, ch);
            g2.drawImage((Image)image, 0, 0, null);
            image = background;
        }
        return image;
    }

    static BufferedImage applyTR(BufferedImage image, PdfObject TR, PdfObjectReader currentPdfFile) {
        PDFFunction[] functions = new PDFFunction[4];
        int total = 0;
        byte[][] kidList = TR.getKeyArray(9250);
        if (kidList != null) {
            total = kidList.length;
        }
        for (int count = 0; count < total; ++count) {
            if (kidList[count] == null) continue;
            String ref = new String(kidList[count]);
            FunctionObject Function2 = new FunctionObject(ref);
            byte[] possIdent = kidList[count];
            if (possIdent != null && possIdent.length > 4 && possIdent[0] == 47 && possIdent[1] == 73 && possIdent[2] == 100 && possIdent[3] == 101) {
                Function2 = null;
            } else {
                currentPdfFile.readObject(Function2);
            }
            if (Function2 == null) continue;
            functions[count] = FunctionFactory.getFunction(Function2, currentPdfFile);
        }
        WritableRaster ras = image.getRaster();
        int[] values = new int[4];
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                ras.getPixels(x, y, 1, 1, values);
                for (int a = 0; a < 3; ++a) {
                    float[] raw = new float[]{(float)values[a] / 255.0f};
                    if (functions[a] == null) continue;
                    float[] processed = functions[a].compute(raw);
                    values[a] = (int)(255.0f * processed[0]);
                }
                image.getRaster().setPixels(x, y, 1, 1, values);
            }
        }
        return image;
    }

    static void applyDecodeArray(byte[] data, int d, float[] decodeArray, int type, PdfObject XObject2) {
        block17: {
            int maxValue;
            int count;
            block16: {
                count = decodeArray.length;
                maxValue = 0;
                for (float aDecodeArray : decodeArray) {
                    if (!((float)maxValue < aDecodeArray)) continue;
                    maxValue = (int)aDecodeArray;
                }
                boolean isIdentify = true;
                int compCount = decodeArray.length;
                for (int comp = 0; comp < compCount; comp += 2) {
                    if (decodeArray[comp] == 0.0f && (decodeArray[comp + 1] == 1.0f || decodeArray[comp + 1] == 255.0f)) continue;
                    isIdentify = false;
                    comp = compCount;
                }
                if (isIdentify) {
                    return;
                }
                if (d != 1) break block16;
                if (!(decodeArray[0] > decodeArray[1])) break block17;
                int byteCount = data.length;
                for (int ii = 0; ii < byteCount; ++ii) {
                    data[ii] = ~data[ii];
                }
                break block17;
            }
            if (d == 8 && maxValue > 1 && (type == 1785221209 || type == 1008872003 || type == 1498837125)) {
                int j = 0;
                for (int ii = 0; ii < data.length; ++ii) {
                    int currentByte = data[ii] & 0xFF;
                    if ((float)currentByte < decodeArray[j]) {
                        currentByte = (int)decodeArray[j];
                    } else if ((float)currentByte > decodeArray[j + 1]) {
                        currentByte = (int)decodeArray[j + 1];
                    }
                    if ((j += 2) == decodeArray.length) {
                        j = 0;
                    }
                    data[ii] = (byte)currentByte;
                }
            } else {
                maxValue = d << 1;
                int divisor = maxValue - 1;
                for (int ii = 0; ii < data.length; ++ii) {
                    byte currentByte = data[ii];
                    int dd = 0;
                    int newByte = 0;
                    int min = 0;
                    int max = 1;
                    for (int bits = 7; bits > -1; --bits) {
                        int current = currentByte >> bits & 1;
                        if ((current = (int)(decodeArray[min] + (float)current * ((decodeArray[max] - decodeArray[min]) / (float)divisor))) > maxValue) {
                            current = maxValue;
                        }
                        if (current < 0) {
                            current = 0;
                        }
                        current = (current & 1) << bits;
                        newByte += current;
                        if ((dd += 2) == count) {
                            dd = 0;
                            min = 0;
                            max = 1;
                            continue;
                        }
                        min += 2;
                        max += 2;
                    }
                    data[ii] = (byte)newByte;
                }
            }
        }
    }

    static boolean isExtractionAllowed(PdfObjectReader currentPdfFile) {
        PdfFileReader objectReader = currentPdfFile.getObjectReader();
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        return decryption == null || decryption.getBooleanValue(103);
    }

    static {
        String nodownsamplesharpen;
        String imgSetting;
        sharpenDownsampledImages = false;
        JAImessageShow = false;
        trackImages = false;
        rejectSuperimposedImages = true;
        String operlapValue = System.getProperty("org.jpedal.rejectsuperimposedimages");
        if (operlapValue != null) {
            boolean bl = rejectSuperimposedImages = operlapValue != null && operlapValue.toLowerCase().contains("true");
        }
        if ((imgSetting = System.getProperty("org.jpedal.trackImages")) != null) {
            boolean bl = trackImages = imgSetting != null && imgSetting.toLowerCase().contains("true");
        }
        if ((nodownsamplesharpen = System.getProperty("org.jpedal.sharpendownsampledimages")) != null) {
            sharpenDownsampledImages = nodownsamplesharpen.toLowerCase().contains("true");
        }
    }
}

