/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class PdfObjectCache {
    public static final int ColorspacesUsed = 1;
    public static final int Colorspaces = 2;
    private static final int initSize = 50;
    private final Map colorspacesUsed = new HashMap(50);
    public Map colorspacesObjects = new HashMap(50);
    HashMap imageAlreadySaved = new HashMap();
    private Map colorspaces = new HashMap(50);
    private Map globalXObjects = new HashMap(50);
    private Map localXObjects = new HashMap(50);
    public final Map XObjectColorspaces = new HashMap(50);
    public Map patterns = new HashMap(50);
    public Map globalShadings = new HashMap(50);
    public Map localShadings = new HashMap(50);
    Map imposedImages = new HashMap(50);
    PdfObject groupObj = null;
    PdfObject pageGroupingObj = null;
    public Map unresolvedFonts = new HashMap(50);
    public Map directFonts = new HashMap(50);
    public Map resolvedFonts = new HashMap(50);
    Map GraphicsStates = new HashMap(50);

    public PdfObjectCache copy() {
        PdfObjectCache copy = new PdfObjectCache();
        copy.localShadings = this.localShadings;
        copy.unresolvedFonts = this.unresolvedFonts;
        copy.GraphicsStates = this.GraphicsStates;
        copy.directFonts = this.directFonts;
        copy.resolvedFonts = this.resolvedFonts;
        copy.colorspaces = this.colorspaces;
        copy.localXObjects = this.localXObjects;
        copy.globalXObjects = this.globalXObjects;
        copy.groupObj = this.groupObj;
        return copy;
    }

    public void put(int type, int key, Object value) {
        switch (type) {
            case 1: {
                this.colorspacesUsed.put(key, value);
            }
        }
    }

    public Iterator iterator(int type) {
        Iterator returnValue = null;
        switch (type) {
            case 1: {
                returnValue = this.colorspacesUsed.keySet().iterator();
            }
        }
        return returnValue;
    }

    public Object get(int key, Object value) {
        Object returnValue = null;
        switch (key) {
            case 1: {
                returnValue = this.colorspacesUsed.get(value);
                break;
            }
            case 2: {
                returnValue = this.colorspaces.get(value);
            }
        }
        return returnValue;
    }

    public void resetFonts() {
        this.resolvedFonts.clear();
        this.unresolvedFonts.clear();
        this.directFonts.clear();
    }

    public PdfObject getXObjects(String localName) {
        PdfObject XObject2 = (PdfObject)this.localXObjects.get(localName);
        if (XObject2 == null) {
            XObject2 = (PdfObject)this.globalXObjects.get(localName);
        }
        return XObject2;
    }

    public void readResources(PdfObject Resources, boolean resetList, PdfObjectReader currentPdfFile) throws PdfException {
        currentPdfFile.checkResolved(Resources);
        String[] names = new String[]{"ColorSpace", "ExtGState", "Font", "Pattern", "Shading", "XObject"};
        int[] keys = new int[]{2087749783, -1938465939, 373243460, 1146450818, 878474856, 979194486};
        for (int ii = 0; ii < names.length; ++ii) {
            if (keys[ii] == 373243460 || keys[ii] == 979194486) {
                this.readArrayPairs(Resources, resetList, keys[ii], currentPdfFile);
                continue;
            }
            this.readArrayPairs(Resources, false, keys[ii], currentPdfFile);
        }
    }

    private void readArrayPairs(PdfObject Resources, boolean resetFontList, int type, PdfObjectReader currentPdfFile) throws PdfException {
        PdfObject resObj;
        boolean debugPairs = false;
        if (Resources != null && (resObj = Resources.getDictionary(type)) != null) {
            PdfKeyPairsIterator keyPairs = resObj.getKeyPairsIterator();
            while (keyPairs.hasMorePairs()) {
                String id = keyPairs.getNextKeyAsString();
                String value = keyPairs.getNextValueAsString();
                PdfObject obj = keyPairs.getNextValueAsDictionary();
                if (Resources.isDataExternal()) {
                    if (obj == null && value == null) {
                        Resources.setFullyResolved(false);
                        return;
                    }
                    if (obj == null) {
                        PdfObject childObj = ObjectFactory.createObject(type, value, type, -1);
                        childObj.setStatus(2);
                        childObj.setUnresolvedData(StringUtils.toBytes(value), type);
                        if (type == 373243460) {
                            this.directFonts.put(id, childObj);
                        }
                    }
                }
                switch (type) {
                    case 2087749783: {
                        this.colorspaces.put(id, obj);
                        break;
                    }
                    case -1938465939: {
                        this.GraphicsStates.put(id, obj);
                        break;
                    }
                    case 373243460: {
                        this.unresolvedFonts.put(id, obj);
                        break;
                    }
                    case 1146450818: {
                        this.patterns.put(id, obj);
                        break;
                    }
                    case 878474856: {
                        if (resetFontList) {
                            this.globalShadings.put(id, obj);
                            break;
                        }
                        this.localShadings.put(id, obj);
                        break;
                    }
                    case 979194486: {
                        if (resetFontList) {
                            this.globalXObjects.put(id, obj);
                            break;
                        }
                        this.localXObjects.put(id, obj);
                    }
                }
                keyPairs.nextPair();
            }
        }
    }

    public void reset(PdfObjectCache newCache) {
        this.localShadings = new HashMap(50);
        this.resolvedFonts = new HashMap(50);
        this.unresolvedFonts = new HashMap(50);
        this.directFonts = new HashMap(50);
        this.colorspaces = new HashMap(50);
        this.GraphicsStates = new HashMap(50);
        this.localXObjects = new HashMap(50);
        for (Object key : newCache.GraphicsStates.keySet()) {
            this.GraphicsStates.put(key, newCache.GraphicsStates.get(key));
        }
        for (Object key : newCache.colorspaces.keySet()) {
            this.colorspaces.put(key, newCache.colorspaces.get(key));
        }
        for (Object key : newCache.localXObjects.keySet()) {
            this.localXObjects.put(key, newCache.localXObjects.get(key));
        }
        for (Object key : newCache.globalXObjects.keySet()) {
            this.globalXObjects.put(key, newCache.globalXObjects.get(key));
        }
        if (this.unresolvedFonts.isEmpty()) {
            for (Object key : newCache.unresolvedFonts.keySet()) {
                this.unresolvedFonts.put(key, newCache.unresolvedFonts.get(key));
            }
        }
    }

    public void restore(PdfObjectCache mainCache) {
        this.directFonts = mainCache.directFonts;
        this.unresolvedFonts = mainCache.unresolvedFonts;
        this.resolvedFonts = mainCache.resolvedFonts;
        this.GraphicsStates = mainCache.GraphicsStates;
        this.colorspaces = mainCache.colorspaces;
        this.localShadings = mainCache.localShadings;
        this.localXObjects = mainCache.localXObjects;
        this.globalXObjects = mainCache.globalXObjects;
        this.groupObj = mainCache.groupObj;
    }

    public int getXObjectCount() {
        return this.localXObjects.keySet().size() + this.globalXObjects.keySet().size();
    }

    public Object getImposedKey(String key) {
        return this.imposedImages.get(key);
    }

    public void setImposedKey(String key, int id) {
        if (this.imposedImages != null) {
            this.imposedImages.put(key, id);
        }
    }

    public boolean testIfImageAlreadySaved(PdfObject XObject2) {
        String objectRefAsString;
        boolean flag = false;
        if (XObject2.getGeneralType(-1) != 6420 && !(flag = this.imageAlreadySaved.containsKey(objectRefAsString = XObject2.getObjectRefAsString()))) {
            this.imageAlreadySaved.put(objectRefAsString, "x");
        }
        return flag;
    }
}

