/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.raw.MCObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.Decoder;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.LayerDecoder;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Rectangle;

public class TextDecoder
extends BaseDecoder
implements Decoder {
    public static boolean showInvisibleText = false;
    private Map lines = new HashMap(1000);
    private PdfFont currentFontData;
    private int fontSize = 0;
    private int currentRotation = 0;
    private PdfData pdfData;
    boolean markedContentExtracted = false;
    private Vector_Rectangle textAreas = new Vector_Rectangle();
    private Vector_Int textDirections = new Vector_Int();
    private TextState currentTextState;
    private boolean isPrinting = false;
    private static final double radiansToDegrees = 57.29577951308232;
    private float unRotatedY = -1.0f;
    private boolean textExtracted = true;
    private boolean renderText = false;
    private boolean textColorExtracted = false;
    private boolean highlightCoords = true;
    private boolean multipleTJs = false;
    private int moveCommand = 0;
    private boolean ttHintingRequired = false;
    private double rotationAsRadians = 0.0;
    private int textLength = 0;
    private static final String[] hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
    private static final float THOUSAND = 1000.0f;
    private float charSpacing = 0.0f;
    private GlyphFactory factory = new T1GlyphFactory();
    private boolean returnText = false;
    private static final int[] multiply8 = new int[]{0, 3, 6, 9, 12, 15};
    private static final int[] multiply16 = new int[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40};
    private static final int NONE = 0;
    private static final int RIGHT = 1;
    float x1;
    float y1;
    float x2;
    float y2;
    boolean isXMLExtraction = true;
    LayerDecoder layerDecoder;
    private String actualText;

    public TextDecoder(PdfData pdfData, boolean isXMLExtraction, LayerDecoder layerDecoder) {
        this.pdfData = pdfData;
        this.isXMLExtraction = isXMLExtraction;
        this.layerDecoder = layerDecoder;
    }

    public TextDecoder(LayerDecoder layerDecoder) {
        this.layerDecoder = layerDecoder;
        this.markedContentExtracted = true;
    }

    TextDecoder() {
    }

    private void calcCoordinates(float x, float[][] rawTrm, boolean horizontal, float max_height, int fontSize, float y) {
        float[][] trm = new float[3][3];
        for (int xx = 0; xx < 3; ++xx) {
            System.arraycopy(rawTrm[xx], 0, trm[xx], 0, 3);
        }
        this.x1 = x;
        this.x2 = trm[2][0] - this.charSpacing * trm[0][0];
        if (horizontal) {
            if (trm[1][0] < 0.0f) {
                this.x1 = x + trm[1][0] - this.charSpacing * trm[0][0];
                this.x2 = trm[2][0];
            } else if (trm[1][0] > 0.0f) {
                this.x1 = x;
                this.x2 = trm[2][0];
            }
        } else if (trm[1][0] > 0.0f) {
            this.x1 = trm[2][0];
            this.x2 = x + trm[1][0] - this.charSpacing * trm[0][0];
        } else if (trm[1][0] < 0.0f) {
            this.x2 = trm[2][0];
            this.x1 = x + trm[1][0] - this.charSpacing * trm[0][0];
        }
        if (!this.highlightCoords) {
            if (horizontal) {
                float s_height = 1.0f;
                if (this.currentFontData.getFontType() == 1228944679) {
                    s_height = max_height / (float)fontSize;
                }
                if (trm[0][1] != 0.0f) {
                    this.y1 = trm[2][1] - trm[0][1] + (trm[0][1] + trm[1][1]) * s_height;
                    this.y2 = y;
                } else {
                    this.y1 = y + trm[1][1] * s_height;
                    this.y2 = trm[2][1];
                }
            } else if (trm[0][1] <= 0.0f) {
                this.y2 = trm[2][1];
                this.y1 = y;
            } else if (trm[0][1] > 0.0f) {
                this.y1 = trm[2][1];
                this.y2 = y;
            }
        }
    }

    @Override
    public void setFont(PdfFont currentFontData) {
        this.currentFontData = currentFontData;
    }

    @Override
    public void setTextState(TextState currentTextState) {
        this.currentTextState = currentTextState;
    }

    @Override
    public int processToken(TextState currentTextState, int commandID, int startCommand, int dataPointer) {
        this.currentTextState = currentTextState;
        switch (commandID) {
            case 0x424443: {
                PdfObject BDCobj = TextDecoder.BDC(startCommand, dataPointer, this.parser.getStream(), this.parser.generateOpAsString(0, false), this.layerDecoder, this.gs, this.currentPdfFile, this.current, this.markedContentExtracted);
                this.actualText = BDCobj.getTextStreamValue(1752861363);
                break;
            }
            case 4345155: {
                this.layerDecoder.BMC();
                break;
            }
            case 16980: {
                currentTextState.resetTm();
                break;
            }
            case 4541763: {
                this.actualText = null;
                this.layerDecoder.EMC(this.current, this.gs);
                break;
            }
            case 17748: {
                this.current.resetOnColorspaceChange();
                break;
            }
            case 17488: {
                break;
            }
            case 19792: {
                break;
            }
            case 21606: {
                currentTextState.TF(this.parser.parseFloat(0), this.parser.generateOpAsString(1, true));
                break;
            }
            case 21603: {
                currentTextState.setCharacterSpacing(this.parser.parseFloat(0));
                break;
            }
            case 21572: {
                this.TD(false, this.parser.parseFloat(1), this.parser.parseFloat(0), currentTextState);
                break;
            }
            case 21604: {
                this.TD(true, this.parser.parseFloat(1), this.parser.parseFloat(0), currentTextState);
                break;
            }
            case 21610: {
                this.TJ(this.parser.getStream(), startCommand, dataPointer);
                break;
            }
            case 21578: {
                this.TJ(this.parser.getStream(), startCommand, dataPointer);
                break;
            }
            case 39: {
                this.TSTAR();
                this.TJ(this.parser.getStream(), startCommand, dataPointer);
                break;
            }
            case 34: {
                this.double_quote(this.parser.getStream(), startCommand, dataPointer, this.parser.parseFloat(1), this.parser.parseFloat(2));
                break;
            }
            case 21613: {
                currentTextState.Tm[0][0] = this.parser.parseFloat(5);
                currentTextState.Tm[0][1] = this.parser.parseFloat(4);
                currentTextState.Tm[0][2] = 0.0f;
                currentTextState.Tm[1][0] = this.parser.parseFloat(3);
                currentTextState.Tm[1][1] = this.parser.parseFloat(2);
                currentTextState.Tm[1][2] = 0.0f;
                currentTextState.Tm[2][0] = this.parser.parseFloat(1);
                currentTextState.Tm[2][1] = this.parser.parseFloat(0);
                currentTextState.Tm[2][2] = 1.0f;
                currentTextState.TmNoRotation[0][0] = currentTextState.Tm[0][0];
                currentTextState.TmNoRotation[0][1] = currentTextState.Tm[0][1];
                currentTextState.TmNoRotation[0][2] = 0.0f;
                currentTextState.TmNoRotation[1][0] = currentTextState.Tm[1][0];
                currentTextState.TmNoRotation[1][1] = currentTextState.Tm[1][1];
                currentTextState.TmNoRotation[1][2] = 0.0f;
                currentTextState.TmNoRotation[2][0] = currentTextState.Tm[2][0];
                currentTextState.TmNoRotation[2][1] = currentTextState.Tm[2][1];
                currentTextState.TmNoRotation[2][2] = 1.0f;
                this.TM();
                break;
            }
            case 21546: {
                this.TSTAR();
                break;
            }
            case 21618: {
                this.TR(this.parser.parseInt(0), this.gs);
                break;
            }
            case 21619: {
                currentTextState.setTextRise(this.parser.parseFloat(0));
                break;
            }
            case 21623: {
                currentTextState.setWordSpacing(this.parser.parseFloat(0));
                break;
            }
            case 21626: {
                currentTextState.setHorizontalScaling(this.parser.parseFloat(0) / 100.0f);
                break;
            }
            case 21580: {
                currentTextState.setLeading(this.parser.parseFloat(0));
            }
        }
        return dataPointer;
    }

    private static PdfObject BDC(int startCommand, int dataPointer, byte[] raw, String op, LayerDecoder layerDecoder, GraphicsState gs, PdfObjectReader currentPdfFile, DynamicVectorRenderer current, boolean markedContentExtracted) {
        MCObject BDCobj = new MCObject(op);
        BDCobj.setID(1184787);
        int rawStart = startCommand;
        if (startCommand < 1) {
            startCommand = 1;
        }
        boolean hasDictionary = true;
        while (startCommand < raw.length && raw[startCommand] != 60 && raw[startCommand - 1] != 60) {
            if (raw[++startCommand] != 66 || raw[startCommand + 1] != 68 || raw[startCommand + 2] != 67) continue;
            hasDictionary = false;
            break;
        }
        if (hasDictionary && (markedContentExtracted || layerDecoder.getPdfLayerList() != null && layerDecoder.isLayerVisible())) {
            ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
            objectDecoder.setEndPt(dataPointer);
            objectDecoder.readDictionaryAsObject(BDCobj, startCommand + 1, raw);
        }
        layerDecoder.BDC(BDCobj, gs, current, dataPointer, raw, hasDictionary, rawStart);
        return BDCobj;
    }

    private void double_quote(byte[] characterStream, int startCommand, int dataPointer, float tc, float tw) {
        this.currentTextState.setCharacterSpacing(tc);
        this.currentTextState.setWordSpacing(tw);
        this.TSTAR();
        while (characterStream[startCommand] != 40 && characterStream[startCommand] != 60 && characterStream[startCommand] != 91) {
            ++startCommand;
        }
        this.TJ(characterStream, startCommand, dataPointer);
    }

    private void TD(boolean isLowerCase, float x, float y, TextState currentTextState) {
        this.relativeMove(x, y, currentTextState);
        if (!isLowerCase) {
            float TL = -y;
            currentTextState.setLeading(TL);
        }
        this.reset();
    }

    private void TM() {
        boolean includeRotation = false;
        if (includeRotation) {
            float[][] trm = this.currentTextState.Tm;
            if (trm[1][0] == 0.0f && trm[0][1] == 0.0f) {
                this.currentRotation = 0;
                this.unRotatedY = -1.0f;
            } else if (trm[0][1] == 0.0f || trm[1][0] == 0.0f) {
                this.currentRotation = 0;
                this.unRotatedY = -1.0f;
            } else {
                this.rotationAsRadians = -Math.asin(trm[1][0] / trm[0][0]);
                int newRotation = (int)(this.rotationAsRadians * 57.29577951308232);
                if (newRotation == 0) {
                    this.currentRotation = 0;
                    this.unRotatedY = -1.0f;
                } else {
                    this.currentRotation = newRotation;
                    this.convertToUnrotated(trm);
                }
            }
        }
        this.currentTextState.setTMAtLineStart();
        this.currentTextState.setTMAtLineStartNoRotation();
        this.reset();
        this.moveCommand = 1;
    }

    private void TJ(byte[] characterStream, int startCommand, int dataPointer) {
        if (this.renderText && this.gs.getTextRenderType() != 4) {
            this.gs.setStrokeColor(this.gs.strokeColorSpace.getColor());
            this.gs.setNonstrokeColor(this.gs.nonstrokeColorSpace.getColor());
        }
        StringBuffer current_value = this.processTextArray(characterStream, startCommand, dataPointer, this.multiplyer);
        int fontSize = this.fontSize;
        if (fontSize == 0) {
            fontSize = (int)this.currentTextState.getTfs();
        }
        if (fontSize < 0) {
            fontSize = -fontSize;
        }
        if (current_value != null && this.isPageContent) {
            String currentColor = null;
            if (this.textColorExtracted) {
                currentColor = (this.gs.getTextRenderType() & 2) == 2 ? this.gs.nonstrokeColorSpace.getXMLColorToken() : this.gs.strokeColorSpace.getXMLColorToken();
            }
            this.storeExtractedText(currentColor, current_value, fontSize, this.currentFontData.getFontName());
        }
        this.moveCommand = -1;
    }

    private void TR(int value, GraphicsState gs) {
        if (value == 0) {
            value = 2;
        } else if (value == 1) {
            value = 1;
        } else if (value == 2) {
            value = 3;
        } else if (value == 3) {
            value = 4;
            if (showInvisibleText) {
                value = 2;
            }
        } else if (value == 7) {
            value = 7;
        }
        gs.setTextRenderType(value);
        if (this.renderPage && !this.renderDirectly) {
            this.current.drawTR(value);
        }
    }

    private void TSTAR() {
        this.relativeMove(0.0f, -this.currentTextState.getLeading(), this.currentTextState);
        this.moveCommand = 0;
        this.reset();
    }

    private void convertToUnrotated(float[][] trm) {
        boolean showCommands = false;
        if (trm[0][1] == 0.0f || trm[1][0] == 0.0f) {
            return;
        }
        this.rotationAsRadians = -Math.asin(trm[1][0] / trm[0][0]);
        float[][] rotation = new float[3][3];
        rotation[0][0] = (float)Math.cos(-this.rotationAsRadians);
        rotation[0][1] = (float)Math.sin(-this.rotationAsRadians);
        rotation[0][2] = 0.0f;
        rotation[1][0] = (float)(-Math.sin(-this.rotationAsRadians));
        rotation[1][1] = (float)Math.cos(-this.rotationAsRadians);
        rotation[1][2] = 0.0f;
        rotation[2][0] = 0.0f;
        rotation[2][1] = 0.0f;
        rotation[2][2] = 1.0f;
        for (int yy = 0; yy < 3; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                if (!((double)rotation[xx][yy] > 0.99 & rotation[xx][yy] < 1.0f)) continue;
                rotation[xx][yy] = 1.0f;
            }
        }
        float[][] pt = new float[3][3];
        pt[0][0] = trm[2][0];
        pt[1][1] = trm[2][1];
        pt[2][2] = 1.0f;
        pt = Matrix.multiply(rotation, pt);
        float[][] unrotatedTrm = Matrix.multiply(rotation, trm);
        float diffY = pt[1][0];
        float newY = pt[1][1] - diffY;
        float convertedY = this.currentTextState.Tm[2][1];
        Integer key = (int)((double)newY + 0.5);
        Float mappedY = (Float)this.lines.get(key);
        if (mappedY == null) {
            mappedY = (Float)this.lines.get((int)(newY + 1.0f));
        }
        if (mappedY == null) {
            this.lines.put(key, Float.valueOf(this.currentTextState.Tm[2][1]));
        } else {
            convertedY = mappedY.floatValue();
        }
        unrotatedTrm[2][1] = convertedY;
        this.currentTextState.TmNoRotation = unrotatedTrm;
        if (this.unRotatedY == -1.0f) {
            this.unRotatedY = this.currentTextState.TmNoRotation[2][1];
        }
        this.currentTextState.TmNoRotation[0][1] = 0.0f;
        this.currentTextState.TmNoRotation[1][0] = 0.0f;
    }

    private void relativeMove(float new_x, float new_y, TextState currentTextState) {
        float[][] temp = new float[3][3];
        currentTextState.Tm = currentTextState.getTMAtLineStart();
        temp[0][0] = 1.0f;
        temp[0][1] = 0.0f;
        temp[0][2] = 0.0f;
        temp[1][0] = 0.0f;
        temp[1][1] = 1.0f;
        temp[1][2] = 0.0f;
        temp[2][0] = new_x;
        temp[2][1] = new_y;
        temp[2][2] = 1.0f;
        currentTextState.Tm = Matrix.multiply(temp, currentTextState.Tm);
        currentTextState.setTMAtLineStart();
        if (this.currentRotation != 0) {
            float[][] temp2 = new float[3][3];
            currentTextState.TmNoRotation = currentTextState.getTMAtLineStartNoRotation();
            temp2[0][0] = 1.0f;
            temp2[0][1] = 0.0f;
            temp2[0][2] = 0.0f;
            temp2[1][0] = 0.0f;
            temp2[1][1] = 1.0f;
            temp2[1][2] = 0.0f;
            temp2[2][0] = new_x;
            temp2[2][1] = new_y;
            temp2[2][2] = 1.0f;
            currentTextState.TmNoRotation = Matrix.multiply(temp2, currentTextState.TmNoRotation);
            float plusX = new_x;
            float plusY = new_y;
            if (plusX < 0.0f) {
                plusX = -new_x;
            }
            if (plusY < 0.0f) {
                plusY = -new_y;
            }
            if (plusX > currentTextState.Tm[0][0] && plusY > currentTextState.Tm[1][1]) {
                this.convertToUnrotated(currentTextState.Tm);
            }
            currentTextState.setTMAtLineStartNoRotation();
        }
        this.moveCommand = 2;
    }

    private StringBuffer processTextArray(byte[] stream, int startCommand, int dataPointer, float multiplyer) {
        float y;
        float x;
        float fontScale;
        int orientation;
        boolean isHorizontal;
        boolean hasContent = false;
        boolean isMultiple = false;
        boolean firstTime = true;
        boolean isTabRemapped = this.currentFontData.getDiffMapping(9) != null;
        boolean isCRRemapped = this.currentFontData.getDiffMapping(10) != null;
        boolean isReturnRemapped = this.currentFontData.getDiffMapping(13) != null;
        int textShiftedMode = 0;
        int streamLength = stream.length;
        while (stream[startCommand] == 91 || stream[startCommand] == 10 || stream[startCommand] == 13 || stream[startCommand] == 32) {
            if (stream[startCommand] == 91) {
                isMultiple = true;
            }
            ++startCommand;
        }
        this.textLength = 0;
        int Tmode = this.gs.getTextRenderType();
        boolean inText = false;
        float[][] TrmWithRotationRemoved = new float[3][3];
        float[][] temp = new float[3][3];
        float[][] TrmBeforeSpace = new float[3][3];
        float[][] TrmBeforeSpaceWithRotationRemoved = new float[3][3];
        int rawChar = 32;
        int lastChar = 32;
        int openChar = 32;
        int lastTextChar = 120;
        float width = 0.0f;
        float lastWidth = 0.0f;
        float currentWidth = 0.0f;
        float leading = 0.0f;
        String displayValue = "";
        float TFS = this.currentTextState.getTfs();
        int valueForHTML = -1;
        float rawTFS = TFS;
        if (TFS < 0.0f) {
            TFS = -TFS;
        }
        int type = this.currentFontData.getFontType();
        float spaceWidth = this.currentFontData.getCurrentFontSpaceWidth();
        String unicodeValue = "";
        StringBuffer textData = null;
        if (this.textExtracted) {
            textData = new StringBuffer(50);
        }
        boolean isCID = this.currentFontData.isCIDFont();
        int isDouble = this.currentFontData.isDoubleBytes();
        boolean isFontVertical = this.currentFontData.isFontVertical();
        boolean isTextShifted = false;
        int charSize = 2;
        if (isCID && !this.currentFontData.isSingleByte()) {
            charSize = 4;
        }
        float[][] Trm = Matrix.multiply(this.currentTextState.Tm, this.gs.CTM);
        if (this.currentRotation != 0) {
            TrmWithRotationRemoved = Matrix.multiply(this.currentTextState.TmNoRotation, this.gs.CTM);
        }
        this.charSpacing = this.currentTextState.getCharacterSpacing() / TFS;
        float wordSpacing = this.currentTextState.getWordSpacing() / TFS;
        if (this.multipleTJs) {
            Trm[2][0] = this.currentTextState.Tm[2][0];
            Trm[2][1] = this.currentTextState.Tm[2][1];
            if (this.currentRotation != 0) {
                TrmWithRotationRemoved[2][0] = this.currentTextState.TmNoRotation[2][0];
                TrmWithRotationRemoved[2][1] = this.currentTextState.TmNoRotation[2][1];
            }
        }
        temp[0][0] = rawTFS * this.currentTextState.getHorizontalScaling();
        temp[1][1] = rawTFS;
        temp[2][1] = this.currentTextState.getTextRise();
        temp[2][2] = 1.0f;
        Trm = Matrix.multiply(temp, Trm);
        if (this.currentRotation != 0) {
            TrmWithRotationRemoved = Matrix.multiply(temp, TrmWithRotationRemoved);
        }
        if (isMultiple && stream[startCommand] != 60 && stream[startCommand] != 40 && stream[startCommand] != 93) {
            float offset = 0.0f;
            while (stream[startCommand] != 40 && stream[startCommand] != 60 && stream[startCommand] != 93) {
                StringBuilder kerning = new StringBuilder(10);
                while (stream[startCommand] != 60 && stream[startCommand] != 40 && stream[startCommand] != 93 && stream[startCommand] != 32) {
                    kerning.append((char)stream[startCommand]);
                    ++startCommand;
                }
                offset += Float.parseFloat(kerning.toString());
                while (stream[startCommand] == 32) {
                    ++startCommand;
                }
            }
            if (Trm[0][0] == 0.0f && Trm[1][1] == 0.0f && Trm[0][1] > 0.0f && Trm[1][0] < 0.0f) {
                offset = Trm[0][1] * offset / 1000.0f;
                Trm[2][1] = Trm[2][1] - offset;
                if (this.currentRotation != 0) {
                    TrmWithRotationRemoved[2][1] = TrmWithRotationRemoved[2][1] - offset;
                }
            } else {
                offset = Trm[0][0] * offset / 1000.0f;
                Trm[2][0] = Trm[2][0] - offset;
                if (this.currentRotation != 0) {
                    TrmWithRotationRemoved[2][0] = TrmWithRotationRemoved[2][0] - offset;
                }
            }
        }
        this.multipleTJs = true;
        if (Trm[1][1] != 0.0f) {
            isHorizontal = true;
            orientation = 0;
            this.fontSize = Trm[1][1] < 0.0f ? (int)(Trm[1][1] - 0.5f) : (int)(Trm[1][1] + 0.5f);
            if (this.fontSize == 0) {
                this.fontSize = Trm[0][1] < 0.0f ? (int)(Trm[0][1] - 0.5f) : (int)(Trm[0][1] + 0.5f);
            }
            fontScale = Trm[0][0];
            if (Trm[0][0] == 0.0f && Trm[0][1] > 0.0f && Trm[1][0] < 0.0f && Trm[1][1] > 0.0f) {
                orientation = 3;
            }
        } else {
            isHorizontal = false;
            this.fontSize = Trm[1][0] < 0.0f ? (int)(Trm[1][0] - 0.5f) : (int)(Trm[1][0] + 0.5f);
            if (this.fontSize == 0) {
                this.fontSize = Trm[0][0] < 0.0f ? (int)(Trm[0][0] - 0.5f) : (int)(Trm[0][0] + 0.5f);
            }
            if (this.fontSize < 0) {
                this.fontSize = -this.fontSize;
                orientation = 3;
            } else {
                orientation = 2;
            }
            fontScale = Trm[0][1];
        }
        this.currentTextState.writingMode = orientation;
        if (this.fontSize == 0) {
            this.fontSize = 1;
        }
        Font javaFont = null;
        if (this.isPrinting && this.textPrint == 3 && StandardFonts.isStandardFont(this.currentFontData.getFontName(), true)) {
            javaFont = this.currentFontData.getJavaFontX(this.fontSize);
        } else if (this.currentFontData.isFontEmbedded && !this.currentFontData.isFontSubstituted()) {
            javaFont = null;
        } else if ((PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts || this.textPrint != 0) && this.isPrinting) {
            javaFont = this.currentFontData.getJavaFontX(this.fontSize);
        }
        if (this.currentRotation == 0) {
            x = Trm[2][0];
            y = Trm[2][1];
        } else {
            x = TrmWithRotationRemoved[2][0];
            y = TrmWithRotationRemoved[2][1];
        }
        if (Trm[1][0] < 0.0f && Trm[0][1] > 0.0f && Trm[1][1] == 0.0f && Trm[0][0] == 0.0f) {
            isTextShifted = true;
        }
        float max_height = this.fontSize;
        if (type == 1228944679 && this.fontSize > 10) {
            max_height = 10.0f;
        }
        if (isCID) {
            max_height = Trm[1][1];
        }
        int numOfPrefixes = 0;
        boolean resetCoords = true;
        for (int i = startCommand; i < dataPointer; ++i) {
            int rawInt;
            float actualWidth = -1.0f;
            while (true) {
                lastChar = lastChar == 92 && rawChar == 92 ? 120 : rawChar;
                rawInt = stream[i];
                if (rawInt < 0) {
                    rawInt = 256 + rawInt;
                }
                if ((rawChar = (int)((char)rawInt)) == 92 && (stream[i + 1] == 13 || stream[i + 1] == 10)) {
                    if ((rawInt = stream[++i]) < 0) {
                        rawInt = 256 + rawInt;
                    }
                    rawChar = (char)rawInt;
                }
                if (rawChar != 10 && rawChar != 13) break;
                ++i;
            }
            if (inText) {
                if (lastChar != 92 && (rawChar == 40 || rawChar == 41)) {
                    if (rawChar == 40) {
                        ++numOfPrefixes;
                    } else if (rawChar == 41) {
                        if (numOfPrefixes <= 0) {
                            inText = false;
                        } else {
                            --numOfPrefixes;
                        }
                    }
                } else if (openChar == 60 && rawChar == 62) {
                    inText = false;
                }
            }
            if (inText) {
                block229: {
                    float diff;
                    int idx;
                    lastTextChar = rawChar;
                    if (openChar == 60) {
                        int val = 0;
                        int chars = 0;
                        for (int i2 = 1; i2 < charSize; ++i2) {
                            byte nextInt = stream[i + i2];
                            if (nextInt == 62) {
                                i2 = 4;
                                charSize = 2;
                                continue;
                            }
                            if (nextInt == 10 || nextInt == 13) {
                                ++i;
                                --i2;
                                continue;
                            }
                            ++chars;
                        }
                        int ptr = 0;
                        for (int aa = 0; aa < chars + 1; ++aa) {
                            int topHex = stream[i + chars - aa];
                            if (topHex >= 65 && topHex <= 70) {
                                topHex -= 55;
                            } else if (topHex >= 97 && topHex <= 102) {
                                topHex -= 87;
                            } else {
                                if (topHex < 48 || topHex > 57) continue;
                                topHex -= 48;
                            }
                            val += topHex << multiply16[ptr];
                            ++ptr;
                        }
                        rawInt = val;
                        i = i + charSize - 1;
                        rawChar = (char)rawInt;
                        displayValue = this.currentFontData.getGlyphValue(rawInt);
                        if (isCID && this.currentFontData.getCMAP() != null && this.currentFontData.getUnicodeMapping(rawInt) == null) {
                            rawInt = rawChar = (int)displayValue.charAt(0);
                        }
                        if (this.textExtracted) {
                            unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                        }
                    } else if (rawChar == 92 && !isCID) {
                        String possAltValue;
                        lastChar = rawChar;
                        if (streamLength > ++i + 2 && Character.isDigit((char)stream[i])) {
                            int numberCount = 1;
                            if (Character.isDigit((char)stream[i + 1])) {
                                ++numberCount;
                                if (Character.isDigit((char)stream[i + 2])) {
                                    ++numberCount;
                                }
                            }
                            rawInt = TextDecoder.readEscapeValue(i, numberCount, 8, stream);
                            i = i + numberCount - 1;
                            if (rawInt > 255) {
                                rawInt -= 256;
                            }
                            rawChar = (char)rawInt;
                            displayValue = this.currentFontData.getGlyphValue(rawInt);
                            if (this.textExtracted) {
                                unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                            }
                            if (rawChar == 92) {
                                rawChar = 120;
                            }
                        } else {
                            rawInt = stream[i];
                            rawChar = (char)rawInt;
                            if (rawChar == 117) {
                                rawInt = TextDecoder.readEscapeValue(i + 1, 4, 16, stream);
                                i += 4;
                                displayValue = this.currentFontData.getGlyphValue(rawInt);
                                if (this.textExtracted) {
                                    unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                                }
                            } else {
                                if (rawChar == 110) {
                                    rawInt = 10;
                                    rawChar = 10;
                                } else if (rawChar == 98) {
                                    rawInt = 8;
                                    rawChar = 8;
                                } else if (rawChar == 116) {
                                    rawInt = 9;
                                    rawChar = 9;
                                } else if (rawChar == 114) {
                                    rawInt = 13;
                                    rawChar = 13;
                                } else if (rawChar == 102) {
                                    rawInt = 12;
                                    rawChar = 12;
                                }
                                displayValue = this.currentFontData.getGlyphValue(rawInt);
                                if (this.textExtracted) {
                                    unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                                }
                                if (displayValue.length() > 0) {
                                    rawChar = displayValue.charAt(0);
                                }
                            }
                        }
                        if (this.currentFontData.getFontType() == 1228944677 && (this.current.getType() == 4 || this.current.getType() == 6 || this.current.getType() == 5) && (possAltValue = this.currentFontData.getMappedChar(rawInt, true)) != null && possAltValue.length() == 1 && possAltValue.toLowerCase().equals(unicodeValue.toLowerCase())) {
                            unicodeValue = displayValue = possAltValue;
                        }
                    } else if (isCID) {
                        int firstVal;
                        boolean debug = false;
                        if (StandardFonts.CMAP == null) {
                            StandardFonts.readCMAP();
                        }
                        String newValue = null;
                        if (stream[i] == 92) {
                            firstVal = stream[++i] & 0xFF;
                            if (streamLength > i + 2 && Character.isDigit((char)stream[i])) {
                                int numberCount = 1;
                                if (Character.isDigit((char)stream[i + 1])) {
                                    ++numberCount;
                                    if (Character.isDigit((char)stream[i + 2])) {
                                        ++numberCount;
                                    }
                                }
                                firstVal = TextDecoder.readEscapeValue(i, numberCount, 8, stream);
                                i = i + numberCount - 1;
                                if (firstVal > 255) {
                                    firstVal -= 256;
                                }
                            } else if (firstVal == 117) {
                                firstVal = TextDecoder.readEscapeValue(i + 1, 4, 16, stream);
                                i += 4;
                            } else if (firstVal == 110) {
                                firstVal = 10;
                            } else if (firstVal == 98) {
                                firstVal = 8;
                            } else if (firstVal == 116) {
                                firstVal = 9;
                            } else if (firstVal == 114) {
                                firstVal = 13;
                            } else if (firstVal == 102) {
                                firstVal = 12;
                            }
                            rawChar = (char)firstVal;
                            rawInt = firstVal;
                        } else {
                            firstVal = rawChar;
                        }
                        String firstValue = StandardFonts.CMAP[rawChar];
                        boolean isEmbedded = this.currentFontData.isFontEmbedded;
                        if (this.currentFontData.hasDoubleBytes || firstValue == null || isDouble != 0 || rawInt > 128) {
                            int iBefore = i++;
                            int secondVal = stream[i] & 0xFF;
                            boolean secondByteIsEscaped = false;
                            if (stream[i] == 92) {
                                secondByteIsEscaped = true;
                                secondVal = stream[++i] & 0xFF;
                                if (streamLength > i + 2 && Character.isDigit((char)stream[i])) {
                                    int numberCount = 1;
                                    if (Character.isDigit((char)stream[i + 1])) {
                                        ++numberCount;
                                        if (Character.isDigit((char)stream[i + 2])) {
                                            ++numberCount;
                                        }
                                    }
                                    secondVal = TextDecoder.readEscapeValue(i, numberCount, 8, stream);
                                    i = i + numberCount - 1;
                                    if (secondVal > 255) {
                                        secondVal -= 256;
                                    }
                                } else if (secondVal == 117) {
                                    secondVal = TextDecoder.readEscapeValue(i + 1, 4, 16, stream);
                                    i += 4;
                                } else if (secondVal == 110) {
                                    secondVal = 10;
                                } else if (secondVal == 98) {
                                    secondVal = 8;
                                } else if (secondVal == 116) {
                                    secondVal = 9;
                                } else if (secondVal == 114) {
                                    secondVal = 13;
                                } else if (secondVal == 102) {
                                    secondVal = 12;
                                }
                            }
                            int secondByte = secondVal;
                            char combinedVal = (char)((rawChar << 8) + secondVal);
                            newValue = StandardFonts.CMAP[combinedVal];
                            isDouble = this.currentFontData.isDoubleBytes(firstVal, secondByte, secondByteIsEscaped);
                            if (isEmbedded && (isDouble == 1 || combinedVal < '\u0100' || newValue != null)) {
                                rawInt = combinedVal;
                                rawChar = (char)rawInt;
                            } else if (!isEmbedded && isDouble == 1 && (newValue != null || combinedVal < '\u0100' || !secondByteIsEscaped && secondByte != 41)) {
                                rawInt = combinedVal;
                                rawChar = (char)rawInt;
                            } else if (isDouble == 0 && !isEmbedded && firstVal > 128 && newValue != null && firstValue == null) {
                                rawInt = combinedVal;
                                rawChar = (char)rawInt;
                            } else if (isDouble == 0 && !isEmbedded && firstVal > 128 && newValue == null && firstValue != null) {
                                i = iBefore;
                                newValue = firstValue;
                            } else {
                                i = iBefore;
                            }
                            if (!isEmbedded && (actualWidth = this.currentFontData.getDefaultWidth(rawInt)) == -1.0f) {
                                actualWidth = this.currentFontData.getDefaultWidth(-1);
                            }
                        } else {
                            actualWidth = -1.0f;
                            if (!(isEmbedded || this.currentFontData.getFontType() != -1684566726 && this.currentFontData.getFontType() != -1684566724 || (actualWidth = this.currentFontData.getDefaultWidth(rawInt)) != -1.0f)) {
                                actualWidth = this.currentFontData.getDefaultWidth(-1) / 2.0f;
                            }
                        }
                        displayValue = newValue != null ? newValue : String.valueOf((char)rawChar);
                        if (this.textExtracted) {
                            unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawChar);
                        }
                        if (rawChar == 92) {
                            valueForHTML = 92;
                            rawChar = 120;
                        }
                    } else {
                        String possAltValue;
                        int newRawInt;
                        String charGlyph;
                        displayValue = this.currentFontData.getGlyphValue(rawInt);
                        if (!(displayValue.length() != 0 || this.current.getType() != 4 && this.current.getType() != 6 && this.current.getType() != 5 || this.currentFontData.isCIDFont() || (charGlyph = this.currentFontData.getMappedChar(rawInt, false)) == null || (newRawInt = this.currentFontData.getDiffChar(charGlyph)) == -1)) {
                            rawInt = newRawInt;
                            displayValue = String.valueOf((char)rawInt);
                        }
                        if (rawInt == 32 && !displayValue.equals(" ")) {
                            lastTextChar = 90;
                        }
                        if (this.textExtracted) {
                            unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                        }
                        if (this.currentFontData.getFontType() == 1228944677 && (this.current.getType() == 4 || this.current.getType() == 6 || this.current.getType() == 5) && (possAltValue = this.currentFontData.getMappedChar(rawInt, true)) != null && possAltValue.length() == 1 && possAltValue.toLowerCase().equals(unicodeValue.toLowerCase())) {
                            unicodeValue = displayValue = possAltValue;
                        }
                    }
                    if (!this.currentFontData.hasToUnicode() && this.currentFontData.getFontType() == -1684566726 && this.currentFontData.getGlyphData().isIdentity() && (this.current.getType() == 6 || this.current.getType() == 4 || this.current.getType() == 5)) {
                        int charToUse = rawChar;
                        if (valueForHTML != -1) {
                            charToUse = valueForHTML;
                            valueForHTML = -1;
                        }
                        int rawC = StandardFonts.mapCIDToValidUnicode(this.currentFontData.getBaseFontName(), charToUse);
                        unicodeValue = String.valueOf((char)rawC);
                    }
                    if (rawInt == 9 && !isTabRemapped && this.currentFontData.isFontSubstituted()) {
                        rawInt = 32;
                        displayValue = " ";
                        unicodeValue = " ";
                    }
                    temp[0][0] = 1.0f;
                    temp[0][1] = 0.0f;
                    temp[0][2] = 0.0f;
                    temp[1][0] = 0.0f;
                    temp[1][1] = 1.0f;
                    temp[1][2] = 0.0f;
                    if (isFontVertical) {
                        temp[2][1] = -(currentWidth + leading);
                        temp[2][0] = 0.0f;
                    } else {
                        temp[2][0] = currentWidth + leading;
                        temp[2][1] = 0.0f;
                    }
                    temp[2][2] = 1.0f;
                    Trm = Matrix.multiply(temp, Trm);
                    if (this.currentRotation != 0) {
                        TrmWithRotationRemoved = Matrix.multiply(temp, TrmWithRotationRemoved);
                    }
                    if (rawChar == 32 && lastChar != 32) {
                        TrmBeforeSpace = Trm;
                        if (this.currentRotation != 0) {
                            TrmBeforeSpaceWithRotationRemoved = TrmWithRotationRemoved;
                        }
                    }
                    leading = 0.0f;
                    PdfJavaGlyphs glyphs = this.currentFontData.getGlyphData();
                    if (this.currentFontData.isCIDFont() && glyphs.is1C() && !glyphs.isIdentity() && (idx = glyphs.getCMAPValue(rawInt)) > 0) {
                        rawInt = idx;
                    }
                    idx = rawInt;
                    if (!glyphs.isCorrupted()) {
                        int diff2;
                        if (this.currentFontData.isCIDFont() && !glyphs.isIdentity()) {
                            int mappedIdx = glyphs.getConvertedGlyph(rawInt);
                            if (mappedIdx != -1) {
                                idx = mappedIdx;
                            }
                        } else if (this.currentFontData.getFontType() != 1228944679 && (diff2 = this.currentFontData.getDiffChar(rawInt)) > 0) {
                            rawInt = diff2;
                        }
                    }
                    currentWidth = actualWidth > 0.0f ? actualWidth : this.currentFontData.getWidth(idx);
                    if (this.current.getType() == 4 || this.current.getType() == 6 || this.current.getType() == 5) {
                        this.currentFontData.setCurrentWidth(currentWidth);
                    }
                    if (wordSpacing < 0.0f && rawInt == 32 && (this.current.getType() == 4 || this.current.getType() == 5 || this.current.getType() == 6) && (double)(diff = Math.abs(wordSpacing + currentWidth)) < 0.01) {
                        unicodeValue = "";
                    }
                    if (this.renderText && Tmode != 4) {
                        if (this.isPrinting && javaFont != null && (this.textPrint == 3 || this.textPrint == 2 || PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts && (!this.currentFontData.isFontEmbedded || this.currentFontData.isFontSubstituted()))) {
                            if (Tmode == 7) {
                                boolean isSTD = DecoderOptions.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName(), false);
                                Area transformedGlyph2 = glyphs.getStandardGlyph(Trm, rawInt, displayValue, currentWidth, isSTD);
                                if (transformedGlyph2 != null) {
                                    this.gs.addClip(transformedGlyph2);
                                }
                                this.current.drawClip(this.gs, null, true);
                            }
                            if (displayValue != null && !displayValue.startsWith("&#")) {
                                if (this.current.getType() == 6 || this.current.getType() == 4 || this.current.getType() == 5) {
                                    this.current.drawEmbeddedText(Trm, this.fontSize, null, null, 1, this.gs, null, displayValue, this.currentFontData, -100.0f);
                                } else {
                                    this.current.drawText(Trm, displayValue, this.gs, Trm[2][0], -Trm[2][1], javaFont);
                                }
                            }
                        } else if (!((this.textPrint != 1 || javaFont == null) && this.currentFontData.isFontEmbedded && this.currentFontData.isFontSubstituted() && (rawInt == 9 && !isTabRemapped || rawInt == 10 && !isCRRemapped || rawInt == 13 && !isReturnRemapped) || (this.textPrint != 1 || javaFont == null) && this.currentFontData.isFontSubstituted() && currentWidth == 0.0f && displayValue.charAt(0) == '\r')) {
                            if ((this.textPrint != 1 || javaFont == null) && this.currentFontData.isFontEmbedded) {
                                String charGlyph = "notdef";
                                try {
                                    if (!this.currentFontData.isCIDFont()) {
                                        charGlyph = this.currentFontData.getMappedChar(rawInt, false);
                                    }
                                    PdfGlyph glyph = glyphs.getEmbeddedGlyph(this.factory, charGlyph, Trm, rawInt, displayValue, currentWidth, this.currentFontData.getEmbeddedChar(rawInt));
                                    if (type == 1228944679) {
                                        if (glyph != null && glyph.getmaxWidth() == 0.0f) {
                                            glyph = null;
                                        } else if (glyph != null && glyph.ignoreColors()) {
                                            glyph.setT3Colors(this.gs.getNonstrokeColor(), this.gs.getNonstrokeColor(), true);
                                        }
                                    }
                                    if (glyph != null) {
                                        if (glyph != null && type == 1228944677) {
                                            glyph.setWidth(currentWidth * 1000.0f);
                                        }
                                        Object finalTrm = new float[][]{{Trm[0][0], Trm[0][1], 0.0f}, {Trm[1][0], Trm[1][1], 0.0f}, {Trm[2][0], Trm[2][1], 1.0f}};
                                        float[][] finalScale = new float[][]{{(float)this.currentFontData.FontMatrix[0], (float)this.currentFontData.FontMatrix[1], 0.0f}, {(float)this.currentFontData.FontMatrix[2], (float)this.currentFontData.FontMatrix[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                                        finalTrm = Matrix.multiply(finalTrm, finalScale);
                                        finalTrm[2][0] = Trm[2][0];
                                        finalTrm[2][1] = Trm[2][1];
                                        if (finalTrm[1][0] < 0.0f && finalTrm[0][1] < 0.0f) {
                                            finalTrm[1][0] = -finalTrm[1][0];
                                            finalTrm[0][1] = -finalTrm[0][1];
                                        }
                                        if (type == 1228944679) {
                                            float h = 0.0f;
                                            if (finalTrm[1][1] != 0.0f) {
                                                h = (float)this.fontSize * finalTrm[1][1];
                                            } else if (finalTrm[0][0] != 0.0f) {
                                                h = (float)this.fontSize * finalTrm[0][0];
                                            } else if (finalTrm[1][0] != 0.0f) {
                                                h = (float)this.fontSize * finalTrm[1][0];
                                            }
                                            if (h < 0.0f) {
                                                h = -h;
                                            }
                                            if (h > max_height) {
                                                max_height = h;
                                            }
                                        }
                                        AffineTransform at = new AffineTransform(finalTrm[0][0], finalTrm[0][1], finalTrm[1][0], finalTrm[1][1], finalTrm[2][0], finalTrm[2][1]);
                                        int fontType = 5;
                                        if (type == 6) {
                                            fontType = 5;
                                            float z = 1000.0f / glyph.getmaxWidth();
                                            at.scale(currentWidth * z, 1.0);
                                        } else if (type == 1217103210 || type == -1684566724 || this.currentFontData.isFontSubstituted() && type != 1228944677) {
                                            fontType = 4;
                                        } else if (type == 1228944679) {
                                            fontType = 6;
                                        }
                                        if (this.generateGlyphOnRender) {
                                            fontType = -fontType;
                                        }
                                        if (Tmode == 7 && glyph.getShape() != null) {
                                            Area glyphShape = (Area)glyph.getShape().clone();
                                            glyphShape.transform(at);
                                            if (glyphShape.getBounds().getWidth() > 0.0 && glyphShape.getBounds().getHeight() > 0.0) {
                                                this.gs.addClip(glyphShape);
                                                this.current.drawClip(this.gs, null, false);
                                            }
                                        }
                                        float lw = this.gs.getLineWidth();
                                        float lineWidth = 0.0f;
                                        if (multiplyer > 0.0f) {
                                            lineWidth = 1.0f / multiplyer;
                                        }
                                        this.gs.setLineWidth(lineWidth);
                                        if (isTextShifted) {
                                            this.current.drawEmbeddedText(Trm, -this.fontSize, glyph, null, fontType, this.gs, at, unicodeValue, this.currentFontData, -100.0f);
                                        } else {
                                            this.current.drawEmbeddedText(Trm, this.fontSize, glyph, null, fontType, this.gs, at, unicodeValue, this.currentFontData, -100.0f);
                                        }
                                        this.gs.setLineWidth(lw);
                                        break block229;
                                    }
                                    displayValue = " ";
                                    unicodeValue = " ";
                                }
                                catch (Exception e) {
                                    if (LogWriter.isOutput()) {
                                        LogWriter.writeLog("Exception: " + e.getMessage());
                                    }
                                    this.errorTracker.addPageFailureMessage("Exception " + e + " on embedded font renderer");
                                }
                            } else if (displayValue.length() > 0 && !displayValue.startsWith("&#")) {
                                firstTime = this.renderTextWithJavaFonts(actualWidth, firstTime, Tmode, this.fontSize, rawInt, currentWidth, displayValue, unicodeValue, isTextShifted, glyphs, Trm);
                            }
                        }
                    }
                }
                currentWidth += this.charSpacing;
                if (rawChar == 32) {
                    currentWidth += wordSpacing;
                }
                float currentGap = width + this.charSpacing - lastWidth;
                String spaces = "";
                if (currentGap > 0.0f && lastWidth > 0.0f) {
                    spaces = PdfFont.getSpaces(currentGap, spaceWidth, PdfStreamDecoder.currentThreshold);
                }
                ++this.textLength;
                lastWidth = width += currentWidth;
                if (this.textExtracted) {
                    hasContent = TextDecoder.writeOutText(hasContent, isHorizontal, TrmWithRotationRemoved, Trm, fontScale, currentWidth, unicodeValue, textData, spaces, this.isXMLExtraction, this.currentRotation);
                }
            } else if (rawChar == 40 || rawChar == 60) {
                inText = true;
                openChar = rawChar;
            } else if (rawChar == 41 || rawChar == 62 && openChar == 60 || !inText && (rawChar == 45 || rawChar >= 48 && rawChar <= 57)) {
                float value = 0.0f;
                ++i;
                while (stream[i] == 32 || stream[i] == 13 || stream[i] == 10) {
                    ++i;
                }
                char nextChar = (char)stream[i];
                if (nextChar == '(' || nextChar == '<') {
                    --i;
                } else if (nextChar != '\'' && nextChar != '\"' && nextChar != '(' && nextChar != ']' && nextChar != '<') {
                    int ptr = 0;
                    int leadingStart = i;
                    boolean failed = false;
                    boolean isMultipleValues = false;
                    boolean isLastValue = false;
                    while (!failed) {
                        rawChar = nextChar;
                        if (rawChar != 10 && rawChar != 13) {
                            ++ptr;
                        }
                        if ((nextChar = (char)stream[i + 1]) == ' ') {
                            isMultipleValues = true;
                        }
                        if (nextChar == ']') {
                            isLastValue = true;
                        }
                        if (nextChar == '(' || nextChar == '<' || nextChar == ']' || nextChar == '\n') break;
                        if (nextChar != '-' && nextChar != '.' && nextChar != ' ' && (nextChar < '0' || nextChar > '9')) {
                            failed = true;
                        }
                        ++i;
                    }
                    if (failed) {
                        i = leadingStart;
                    } else {
                        value = TextDecoder.getLeading(stream, value, ptr, leadingStart, isMultipleValues);
                    }
                    if (isLastValue && value == -width) {
                        leading -= value;
                    }
                }
                width += value;
                leading += value;
            }
            if (!this.textExtracted) continue;
            resetCoords = this.setExtractedText(textShiftedMode, Trm, fontScale, currentWidth, displayValue, resetCoords);
        }
        temp[0][0] = 1.0f;
        temp[0][1] = 0.0f;
        temp[0][2] = 0.0f;
        temp[1][0] = 0.0f;
        temp[1][1] = 1.0f;
        temp[1][2] = 0.0f;
        temp[2][0] = leading < 0.0f ? currentWidth : currentWidth + leading;
        temp[2][1] = 0.0f;
        temp[2][2] = 1.0f;
        Trm = Matrix.multiply(temp, Trm);
        this.currentTextState.Tm[2][0] = Trm[2][0];
        this.currentTextState.Tm[2][1] = Trm[2][1] - this.currentTextState.getTextRise();
        if (this.currentRotation != 0) {
            TrmWithRotationRemoved = Matrix.multiply(temp, TrmWithRotationRemoved);
            this.currentTextState.TmNoRotation[2][0] = TrmWithRotationRemoved[2][0];
            this.currentTextState.TmNoRotation[2][1] = TrmWithRotationRemoved[2][1];
        }
        if (this.textExtracted) {
            if (lastTextChar == 32) {
                Trm = TrmBeforeSpace;
                if (this.currentRotation != 0) {
                    TrmWithRotationRemoved = TrmBeforeSpaceWithRotationRemoved;
                }
            }
            if (this.currentRotation == 0) {
                this.calcCoordinates(x, Trm, isHorizontal, max_height, this.fontSize, y);
            } else {
                this.calcCoordinates(x, TrmWithRotationRemoved, isHorizontal, max_height, this.fontSize, y);
            }
            if (textData != null && this.actualText != null) {
                int startValue = textData.indexOf(PdfData.marker, 2);
                if (startValue > 0) {
                    startValue = textData.indexOf(PdfData.marker, startValue + 1);
                }
                if (startValue > 0) {
                    textData.setLength(startValue + 1);
                    textData.append(this.actualText);
                }
                this.actualText = null;
            }
            if (textData.length() == 0 || !hasContent) {
                textData = null;
            }
            return textData;
        }
        return null;
    }

    private boolean renderTextWithJavaFonts(float actualWidth, boolean firstTime, int Tmode, int fontSize, int rawInt, float currentWidth, String displayValue, String unicodeValue, boolean isTextShifted, PdfJavaGlyphs glyphs, float[][] displayTrm) {
        Area transformedGlyph2;
        boolean isSTD;
        AffineTransform glyphAt = null;
        boolean bl = isSTD = actualWidth > 0.0f || DecoderOptions.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName(), false) || this.currentFontData.isBrokenFont();
        if (glyphs.lastTrm[0][0] != displayTrm[0][0] || glyphs.lastTrm[1][0] != displayTrm[1][0] || glyphs.lastTrm[0][1] != displayTrm[0][1] || glyphs.lastTrm[1][1] != displayTrm[1][1]) {
            glyphs.lastTrm = displayTrm;
            glyphs.flush();
        }
        Area glyph = glyphs.getCachedShape(rawInt);
        glyphAt = glyphs.getCachedTransform(rawInt);
        if (glyph == null) {
            double dY = -1.0;
            double dX = 1.0;
            double x3 = 0.0;
            double y3 = 0.0;
            if (displayTrm[1][0] < 0.0f && displayTrm[0][1] >= 0.0f || displayTrm[0][1] < 0.0f && displayTrm[1][0] >= 0.0f) {
                dX = 1.0;
                dY = -1.0;
            }
            if (isSTD) {
                glyph = glyphs.getGlyph(rawInt, displayValue, currentWidth);
                if (glyph != null && rawInt == 146 && glyphs.isArialInstalledLocally) {
                    y3 = -(glyph.getBounds().height - glyph.getBounds().y);
                }
            } else {
                String xx = displayValue;
                if (glyphs.remapFont && !glyphs.getUnscaledFont().canDisplay(xx.charAt(0))) {
                    xx = String.valueOf((char)(rawInt + 61440));
                }
                GlyphVector gv1 = null;
                if (!glyphs.isCIDFont || glyphs.isFontInstalled) {
                    gv1 = glyphs.getUnscaledFont().createGlyphVector(PdfJavaGlyphs.frc, xx);
                }
                if (gv1 != null) {
                    double glyphWidth;
                    double scaleFactor;
                    glyph = new Area(gv1.getOutline());
                    double glyphX = gv1.getOutline().getBounds2D().getX();
                    x3 = 0.0;
                    if (glyphX < 0.0) {
                        glyphX = -glyphX;
                        x3 = glyphX * 2.0;
                        x3 = displayTrm[0][0] > displayTrm[0][1] ? (x3 *= (double)displayTrm[0][0]) : (x3 *= (double)displayTrm[0][1]);
                    }
                    if ((scaleFactor = (double)currentWidth / (glyphWidth = gv1.getVisualBounds().getWidth() + glyphX * 2.0)) < 1.0) {
                        dX *= scaleFactor;
                    }
                    if (x3 > 0.0) {
                        x3 *= dX;
                    }
                }
            }
            glyphAt = new AffineTransform(dX * (double)displayTrm[0][0], dX * (double)displayTrm[0][1], dY * (double)displayTrm[1][0], dY * (double)displayTrm[1][1], x3, y3);
            glyphs.setCachedShape(rawInt, glyph, glyphAt);
        }
        if (glyph != null && Tmode == 7 && glyph.getBounds().width > 0) {
            Area glyphShape = (Area)glyph.clone();
            glyphShape.transform(glyphAt);
            if (this.renderDirectly) {
                AffineTransform at2 = AffineTransform.getTranslateInstance(displayTrm[2][0], displayTrm[2][1]);
                glyphShape.transform(at2);
            }
            this.gs.addClip(glyphShape);
            this.current.drawClip(this.gs, null, false);
            if (this.renderDirectly) {
                glyph = null;
            }
        }
        if ((transformedGlyph2 = glyph) != null) {
            if (this.renderDirectly) {
                this.current.drawEmbeddedText(displayTrm, fontSize, null, transformedGlyph2, 1, this.gs, glyphAt, unicodeValue, this.currentFontData, -100.0f);
            } else if (isTextShifted) {
                this.current.drawEmbeddedText(displayTrm, -fontSize, null, transformedGlyph2, 1, this.gs, null, unicodeValue, this.currentFontData, -100.0f);
            } else {
                this.current.drawEmbeddedText(displayTrm, fontSize, null, transformedGlyph2, 1, this.gs, null, unicodeValue, this.currentFontData, -100.0f);
            }
        }
        return firstTime;
    }

    private static boolean writeOutText(boolean hasContent, boolean isHorizontal, float[][] TrmWithRotationRemoved, float[][] Trm, float fontScale, float currentWidth, String unicodeValue, StringBuffer textData, String spaces, boolean isXMLExtraction, int currentRotation) {
        if (unicodeValue.length() > 0) {
            if (PdfDecoder.embedWidthData) {
                float xx = Trm[2][0];
                float yy = Trm[2][1];
                if (currentRotation != 0) {
                    xx = TrmWithRotationRemoved[2][0];
                    yy = TrmWithRotationRemoved[2][1];
                }
                textData.append(spaces);
                if (isHorizontal) {
                    textData.append(PdfData.marker);
                    textData.append(xx);
                    textData.append(PdfData.marker);
                } else {
                    textData.append(PdfData.marker);
                    textData.append(yy);
                    textData.append(PdfData.marker);
                }
                textData.append(currentWidth * fontScale);
                textData.append(PdfData.marker);
            } else {
                textData.append(spaces);
            }
            int length = unicodeValue.length();
            for (int ii = 0; ii < length; ++ii) {
                char next = unicodeValue.charAt(ii);
                hasContent = true;
                if (next == '\t') {
                    next = ' ';
                }
                if (next == '<' && isXMLExtraction) {
                    textData.append("&lt;");
                    continue;
                }
                if (next == '>' && isXMLExtraction) {
                    textData.append("&gt;");
                    continue;
                }
                if (next == '\ufb02') {
                    textData.append("fl");
                    continue;
                }
                if (next > '\u001f') {
                    textData.append(next);
                    continue;
                }
                textData.append(hex[next]);
            }
        } else {
            textData.append(spaces);
        }
        return hasContent;
    }

    @Override
    public Object getObjectValue(int key) {
        switch (key) {
            case -21: {
                return this.textAreas;
            }
            case 22: {
                return this.textDirections;
            }
        }
        return null;
    }

    private static String getString(int start, int end, byte[] dataStream) {
        while (dataStream[end] == 32 || dataStream[end] == 13 || dataStream[end] == 10) {
            --end;
        }
        int count = end - start + 1;
        int spaces = 0;
        for (int ii = 0; ii < count; ++ii) {
            if (ii <= 0 || dataStream[start + ii] != 32 && dataStream[start + ii] != 13 && dataStream[start + ii] != 10 || dataStream[start + ii - 1] != 32 && dataStream[start + ii - 1] != 13 && dataStream[start + ii - 1] != 10) continue;
            ++spaces;
        }
        char[] charString = new char[count - spaces];
        int pos = 0;
        for (int ii = 0; ii < count; ++ii) {
            if (ii > 0 && (dataStream[start + ii] == 32 || dataStream[start + ii] == 13 || dataStream[start + ii] == 10) && (dataStream[start + ii - 1] == 32 || dataStream[start + ii - 1] == 13 || dataStream[start + ii - 1] == 10)) continue;
            charString[pos] = dataStream[start + ii] == 10 || dataStream[start + ii] == 13 ? 32 : (char)dataStream[start + ii];
            ++pos;
        }
        String s = String.copyValueOf(charString);
        return s;
    }

    private static float getLeading(byte[] stream, float value, int ptr, int leadingStart, boolean isMultipleValues) {
        if (isMultipleValues) {
            int strt = leadingStart;
            while (stream[strt] == 10 || stream[strt] == 9 || stream[strt] == 32 || stream[strt] == 13) {
                ++strt;
            }
            String val = TextDecoder.getString(strt, strt + ptr - 1, stream);
            StringTokenizer values = new StringTokenizer(val);
            value = 0.0f;
            while (values.hasMoreTokens()) {
                value += Float.parseFloat(values.nextToken());
            }
            value = -value / 1000.0f;
        } else if (ptr > 0) {
            int strt = leadingStart;
            while (stream[strt] == 10 || stream[strt] == 9 || stream[strt] == 32 || stream[strt] == 13) {
                ++strt;
            }
            value = -NumberUtils.parseFloat(strt, strt + ptr, stream) / 1000.0f;
        }
        return value;
    }

    private boolean setExtractedText(int textShiftedMode, float[][] Trm, float fontScale, float currentWidth, String displayValue, boolean resetCoords) {
        if (displayValue.length() > 0 && !displayValue.equals(" ")) {
            float fy;
            float xx = (int)Trm[2][0];
            if (textShiftedMode == 1) {
                xx -= Trm[1][0];
            }
            float yy = (int)Trm[2][1];
            float ww = currentWidth * fontScale;
            float hh = Trm[1][1];
            if (hh == 0.0f) {
                hh = Trm[0][1];
            }
            if (this.currentFontData.getFontType() == 1228944679 && hh != 0.0f && (int)hh == 0 && this.currentFontData.FontMatrix[3] == -1.0) {
                hh *= this.currentFontData.FontBBox[3] - this.currentFontData.FontBBox[1];
                hh = -hh;
            }
            hh = (int)hh;
            if (ww < 0.0f) {
                ww = -ww;
                xx -= ww;
            }
            if (hh < 0.0f) {
                hh = -hh;
                yy -= hh;
            }
            Rectangle fontbb = this.currentFontData.getBoundingBox();
            if (fontbb.y < 0) {
                fontbb.height -= fontbb.y;
                fontbb.y = 0;
            }
            if ((fy = (float)fontbb.y) == 0.0f) {
                fy = 100.0f;
            }
            if (fy < 0.0f) {
                fy = -fy;
            }
            float h = 1000.0f + fy;
            h = 1000.0f / h;
            switch (this.currentTextState.writingMode) {
                case 0: {
                    float fontHeight = hh / h;
                    yy -= fontHeight - hh;
                    hh = fontHeight;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    float fontHeight = ww / h;
                    xx -= fontHeight - ww;
                    ww = fontHeight;
                    break;
                }
                case 3: {
                    float fontHeight = ww / h;
                    xx -= fontHeight;
                    ww = fontHeight;
                }
            }
            xx -= 1.0f;
            ww += 2.0f;
            if (this.highlightCoords) {
                if (resetCoords) {
                    this.y2 = yy;
                    this.y1 = yy + hh;
                    resetCoords = false;
                }
                if (yy < this.y2) {
                    this.y2 = yy;
                }
                if (yy + hh > this.y1) {
                    this.y1 = yy + hh;
                }
            }
            if (this.renderText) {
                this.textAreas.addElement(new Rectangle((int)xx, (int)yy, (int)ww, (int)hh));
                this.textDirections.addElement(this.currentTextState.writingMode);
            }
        }
        return resetCoords;
    }

    private static int readEscapeValue(int start, int count, int base, byte[] characterStream) {
        int val = 0;
        if (base == 8) {
            int ptr = 0;
            for (int aa = 1; aa < count + 1; ++aa) {
                int topHex = characterStream[start + count - aa];
                if (topHex < 48 || topHex > 55) continue;
                val += (topHex -= 48) << multiply8[ptr];
                ++ptr;
            }
        } else if (base == 16) {
            int ptr = 0;
            for (int aa = 1; aa < count + 1; ++aa) {
                int topHex = characterStream[start + count - aa];
                if (topHex >= 65 && topHex <= 70) {
                    topHex -= 55;
                } else if (topHex >= 97 && topHex <= 102) {
                    topHex -= 87;
                } else {
                    if (topHex < 48 || topHex > 57) continue;
                    topHex -= 48;
                }
                val += topHex << multiply16[ptr];
                ++ptr;
            }
        } else {
            StringBuilder chars = new StringBuilder(10);
            for (int pointer = 0; pointer < count; ++pointer) {
                chars.append((char)characterStream[start + pointer]);
            }
            val = Integer.parseInt(chars.toString(), base);
        }
        return val;
    }

    void storeExtractedText(String currentColor, StringBuffer current_value, int fontSize, String fontName) {
        if (this.textExtracted) {
            this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, this.currentTextState.writingMode, Fonts.createFontToken(fontName, fontSize), this.currentFontData.getCurrentFontSpaceWidth(), fontSize, this.x1, this.y1, this.x2, this.y2, this.moveCommand, current_value, this.textLength, currentColor, this.isXMLExtraction);
        }
    }

    @Override
    public boolean isTTHintingRequired() {
        return this.ttHintingRequired;
    }

    @Override
    public void reset() {
        this.multipleTJs = false;
    }

    @Override
    public void setReturnText(boolean returnText) {
        this.returnText = returnText;
    }

    @Override
    public void setParameters(boolean isPageContent, boolean renderPage, int renderMode, int extractionMode, boolean isPrinting) {
        super.setParameters(isPageContent, renderPage, renderMode, extractionMode);
        this.isPrinting = isPrinting;
        this.textExtracted = (extractionMode & 1) == 1;
        this.renderText = renderPage && (renderMode & 1) == 1;
        this.textColorExtracted = (extractionMode & 0x40) == 64;
    }

    @Override
    public void setBooleanValue(int key, boolean value) {
        switch (key) {
            case 21: {
                this.generateGlyphOnRender = value;
                break;
            }
            default: {
                super.setBooleanValue(key, value);
            }
        }
    }

    @Override
    public void setIntValue(int key, int value) {
        switch (key) {
            case 20: {
                this.textPrint = value;
                break;
            }
            default: {
                super.setIntValue(key, value);
            }
        }
    }
}

