/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Float
implements Serializable {
    private static final long serialVersionUID = -7319859210054540698L;
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private float[] items = new float[this.max_size];
    private int checkPoint = -1;

    public Vector_Float() {
    }

    public Vector_Float(int number) {
        this.max_size = number;
        this.items = new float[this.max_size];
    }

    protected static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public final float[] get() {
        return this.items;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.current_item - 1 - id);
            this.items[this.current_item - 1] = 0.0f;
        } else {
            this.items[0] = 0.0f;
        }
        --this.current_item;
    }

    public final boolean contains(int value) {
        boolean flag = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (this.items[i] != (float)value) continue;
            i = this.current_item + 1;
            flag = true;
        }
        return flag;
    }

    public final void addElement(float value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void set(float[] new_items) {
        this.items = new_items;
    }

    public final float elementAt(int id) {
        if (id >= this.max_size) {
            return 0.0f;
        }
        return this.items[id];
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = 0.0f;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = 0.0f;
            }
        }
        this.current_item = 0;
    }

    public final void reuse() {
        this.current_item = 0;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void setElementAt(float new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    private final void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            float[] temp = this.items;
            this.items = new float[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Float.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        float[] newItems = new float[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void setSize(int currentItem) {
        this.current_item = currentItem;
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1 && this.current_item >= 0) {
            this.checkPoint = this.current_item;
        }
    }
}

