/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Short
implements Serializable {
    private static final long serialVersionUID = -177128610623475512L;
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private short[] items = new short[this.max_size];

    public Vector_Short() {
    }

    protected static int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Short(int number) {
        this.max_size = number;
        this.items = new short[this.max_size];
    }

    public final short elementAt(int id) {
        if (id >= this.max_size) {
            return 0;
        }
        return this.items[id];
    }

    public final short[] get() {
        return this.items;
    }

    public final void setElementAt(short new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    public final void set(short[] new_items) {
        this.items = new_items;
    }

    public final void keep_larger(short master, short child) {
        if (this.items[master] < this.items[child]) {
            this.items[master] = this.items[child];
        }
    }

    public final void keep_smaller(short master, short child) {
        if (this.items[master] > this.items[child]) {
            this.items[master] = this.items[child];
        }
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = 0;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = 0;
            }
        }
        this.current_item = 0;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.current_item - 1 - id);
            this.items[this.current_item - 1] = 0;
        } else {
            this.items[0] = 0;
        }
        --this.current_item;
    }

    public final boolean contains(short value) {
        boolean flag = false;
        for (int i = 0; i < this.current_item; ++i) {
            if (this.items[i] != value) continue;
            i = this.current_item + 1;
            flag = true;
        }
        return flag;
    }

    public final short pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(short value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void addElement(short value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void add_together(short master, short child) {
        this.items[master] = (short)(this.items[master] + this.items[child]);
    }

    private final void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            short[] temp = this.items;
            this.items = new short[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = Vector_Short.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        short[] newItems = new short[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void setSize(int currentItem) {
        this.current_item = currentItem;
    }
}

