/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.Config;
import com.github.kwart.jsign.pkcs11.P11AEADCipher;
import com.github.kwart.jsign.pkcs11.P11Cipher;
import com.github.kwart.jsign.pkcs11.P11Digest;
import com.github.kwart.jsign.pkcs11.P11ECDHKeyAgreement;
import com.github.kwart.jsign.pkcs11.P11Key;
import com.github.kwart.jsign.pkcs11.P11KeyAgreement;
import com.github.kwart.jsign.pkcs11.P11KeyGenerator;
import com.github.kwart.jsign.pkcs11.P11KeyPairGenerator;
import com.github.kwart.jsign.pkcs11.P11Mac;
import com.github.kwart.jsign.pkcs11.P11PSSSignature;
import com.github.kwart.jsign.pkcs11.P11RSACipher;
import com.github.kwart.jsign.pkcs11.P11SecretKeyFactory;
import com.github.kwart.jsign.pkcs11.P11Signature;
import com.github.kwart.jsign.pkcs11.P11TlsKeyMaterialGenerator;
import com.github.kwart.jsign.pkcs11.P11TlsMasterSecretGenerator;
import com.github.kwart.jsign.pkcs11.P11TlsPrfGenerator;
import com.github.kwart.jsign.pkcs11.P11TlsRsaPremasterSecretGenerator;
import com.github.kwart.jsign.pkcs11.Session;
import com.github.kwart.jsign.pkcs11.Token;
import java.io.File;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.AuthProvider;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.SecurityPermission;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.Debug;
import sun.security.util.ECParameters;
import sun.security.util.GCMParameters;
import sun.security.util.ResourcesMgr;

public final class JSignPKCS11
extends AuthProvider {
    public static final long CKU_CONTEXT_SPECIFIC = 2L;
    private static final long serialVersionUID = -1354835039035306505L;
    static final Debug debug = Debug.getInstance("sunpkcs11");
    private static int dummyConfigId;
    final PKCS11 p11;
    private final String configName;
    final Config config;
    final long slotID;
    private CallbackHandler pHandler;
    private final Object LOCK_HANDLER = new Object();
    final boolean removable;
    private volatile Token token;
    private TokenPoller poller;
    private static final Map<Integer, List<Descriptor>> descriptors;
    private static final String MD = "MessageDigest";
    private static final String SIG = "Signature";
    private static final String KPG = "KeyPairGenerator";
    private static final String KG = "KeyGenerator";
    private static final String AGP = "AlgorithmParameters";
    private static final String KF = "KeyFactory";
    private static final String SKF = "SecretKeyFactory";
    private static final String CIP = "Cipher";
    private static final String MAC = "Mac";
    private static final String KA = "KeyAgreement";
    private static final String KS = "KeyStore";
    private static final String SR = "SecureRandom";

    Token getToken() {
        return this.token;
    }

    public JSignPKCS11() {
        super("JSignPKCS11-Dummy", 1.8, "JSignPKCS11-Dummy");
        throw new ProviderException("JSignPKCS11 requires configuration file argument");
    }

    public JSignPKCS11(String configName) {
        this(JSignPKCS11.checkNull(configName), null);
    }

    public JSignPKCS11(InputStream configStream) {
        this(JSignPKCS11.getDummyConfigName(), JSignPKCS11.checkNull(configStream));
    }

    private static <T> T checkNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    private static synchronized String getDummyConfigName() {
        int id = ++dummyConfigId;
        return "---DummyConfig-" + id + "---";
    }

    @Deprecated
    public JSignPKCS11(String configName, InputStream configStream) {
        super("JSignPKCS11-" + Config.getConfig(configName, configStream).getName(), 1.8, Config.getConfig(configName, configStream).getDescription());
        this.configName = configName;
        this.config = Config.removeConfig(configName);
        if (debug != null) {
            System.out.println("JSignPKCS11 loading " + configName);
        }
        String library = this.config.getLibrary();
        String functionList = this.config.getFunctionList();
        long slotID = this.config.getSlotID();
        int slotListIndex = this.config.getSlotListIndex();
        boolean useSecmod = this.config.getNssUseSecmod();
        if (useSecmod) {
            throw new ProviderException("The JSignPKCS11 doesn't support NSS-mode");
        }
        File libraryFile = new File(library);
        if (!libraryFile.getName().equals(library) && !new File(library).isFile()) {
            String msg = "Library " + library + " does not exist";
            if (this.config.getHandleStartupErrors() == 1) {
                throw new ProviderException(msg);
            }
            throw new UnsupportedOperationException(msg);
        }
        try {
            PKCS11 tmpPKCS11;
            if (debug != null) {
                debug.println("Initializing PKCS#11 library " + library);
            }
            CK_C_INITIALIZE_ARGS initArgs = new CK_C_INITIALIZE_ARGS();
            String nssArgs = this.config.getNssArgs();
            if (nssArgs != null) {
                initArgs.pReserved = nssArgs;
            }
            initArgs.flags = 2L;
            try {
                tmpPKCS11 = PKCS11.getInstance(library, functionList, initArgs, this.config.getOmitInitialize());
            }
            catch (PKCS11Exception e) {
                if (debug != null) {
                    debug.println("Multi-threaded initialization failed: " + e);
                }
                if (!this.config.getAllowSingleThreadedModules()) {
                    throw e;
                }
                if (nssArgs == null) {
                    initArgs = null;
                } else {
                    initArgs.flags = 0L;
                }
                tmpPKCS11 = PKCS11.getInstance(library, functionList, initArgs, this.config.getOmitInitialize());
            }
            this.p11 = tmpPKCS11;
            CK_INFO p11Info = this.p11.C_GetInfo();
            if (p11Info.cryptokiVersion.major < 2) {
                throw new ProviderException("Only PKCS#11 v2.0 and later supported, library version is v" + p11Info.cryptokiVersion);
            }
            boolean showInfo = this.config.getShowInfo();
            if (showInfo) {
                System.out.println("Information for provider " + this.getName());
                System.out.println("Library info:");
                System.out.println(p11Info);
            }
            if (slotID < 0L || showInfo) {
                long[] slots = this.p11.C_GetSlotList(false);
                if (showInfo) {
                    System.out.println("All slots: " + JSignPKCS11.toString(slots));
                    slots = this.p11.C_GetSlotList(true);
                    System.out.println("Slots with tokens: " + JSignPKCS11.toString(slots));
                }
                if (slotID < 0L) {
                    if (slotListIndex < 0 || slotListIndex >= slots.length) {
                        throw new ProviderException("slotListIndex is " + slotListIndex + " but token only has " + slots.length + " slots");
                    }
                    slotID = slots[slotListIndex];
                }
            }
            this.slotID = slotID;
            CK_SLOT_INFO slotInfo = this.p11.C_GetSlotInfo(slotID);
            this.removable = (slotInfo.flags & 2L) != 0L;
            this.initToken(slotInfo);
        }
        catch (Exception e) {
            if (this.config.getHandleStartupErrors() == 2) {
                throw new UnsupportedOperationException("Initialization failed", e);
            }
            throw new ProviderException("Initialization failed", e);
        }
    }

    private static String toString(long[] longs) {
        if (longs.length == 0) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(longs[0]);
        for (int i = 1; i < longs.length; ++i) {
            sb.append(", ");
            sb.append(longs[i]);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    private static String[] s(String ... aliases) {
        return aliases;
    }

    private static int[] m(long m1) {
        return new int[]{(int)m1};
    }

    private static int[] m(long m1, long m2) {
        return new int[]{(int)m1, (int)m2};
    }

    private static int[] m(long m1, long m2, long m3) {
        return new int[]{(int)m1, (int)m2, (int)m3};
    }

    private static int[] m(long m1, long m2, long m3, long m4) {
        return new int[]{(int)m1, (int)m2, (int)m3, (int)m4};
    }

    private static void d(String type, String algorithm, String className, int[] m) {
        JSignPKCS11.register(new Descriptor(type, algorithm, className, null, m));
    }

    private static void d(String type, String algorithm, String className, String[] aliases, int[] m) {
        JSignPKCS11.register(new Descriptor(type, algorithm, className, aliases, m));
    }

    private static void register(Descriptor d) {
        for (int i = 0; i < d.mechanisms.length; ++i) {
            int m = d.mechanisms[i];
            Integer key = m;
            List<Descriptor> list = descriptors.get(key);
            if (list == null) {
                list = new ArrayList<Descriptor>();
                descriptors.put(key, list);
            }
            list.add(d);
        }
    }

    private void createPoller() {
        if (this.poller != null) {
            return;
        }
        TokenPoller poller = new TokenPoller(this);
        Thread t = new Thread((Runnable)poller, "Poller " + this.getName());
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
        this.poller = poller;
    }

    private void destroyPoller() {
        if (this.poller != null) {
            this.poller.disable();
            this.poller = null;
        }
    }

    private boolean hasValidToken() {
        Token token = this.token;
        return token != null && token.isValid();
    }

    synchronized void uninitToken(Token token) {
        if (this.token != token) {
            return;
        }
        this.destroyPoller();
        this.token = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JSignPKCS11.this.clear();
                return null;
            }
        });
        this.createPoller();
    }

    private void initToken(CK_SLOT_INFO slotInfo) throws PKCS11Exception {
        if (slotInfo == null) {
            slotInfo = this.p11.C_GetSlotInfo(this.slotID);
        }
        if (this.removable && (slotInfo.flags & 1L) == 0L) {
            this.createPoller();
            return;
        }
        this.destroyPoller();
        boolean showInfo = this.config.getShowInfo();
        if (showInfo) {
            System.out.println("Slot info for slot " + this.slotID + ":");
            System.out.println(slotInfo);
        }
        final Token token = new Token(this);
        if (showInfo) {
            System.out.println("Token info for token in slot " + this.slotID + ":");
            System.out.println(token.tokenInfo);
        }
        long[] supportedMechanisms = this.p11.C_GetMechanismList(this.slotID);
        final HashMap<Descriptor, Integer> supportedAlgs = new HashMap<Descriptor, Integer>();
        for (int i = 0; i < supportedMechanisms.length; ++i) {
            int mech;
            Integer integerMech;
            List<Descriptor> ds;
            long longMech = supportedMechanisms[i];
            boolean isEnabled = this.config.isEnabled(longMech);
            if (showInfo) {
                CK_MECHANISM_INFO mechInfo = this.p11.C_GetMechanismInfo(this.slotID, longMech);
                System.out.println("Mechanism " + Functions.getMechanismName(longMech) + ":");
                if (!isEnabled) {
                    System.out.println("DISABLED in configuration");
                }
                System.out.println(mechInfo);
            }
            if (!isEnabled || longMech >>> 32 != 0L || (ds = descriptors.get(integerMech = Integer.valueOf(mech = (int)longMech))) == null) continue;
            block1: for (Descriptor d : ds) {
                Integer oldMech = (Integer)supportedAlgs.get(d);
                if (oldMech == null) {
                    supportedAlgs.put(d, integerMech);
                    continue;
                }
                int intOldMech = oldMech;
                for (int j = 0; j < d.mechanisms.length; ++j) {
                    int nextMech = d.mechanisms[j];
                    if (mech == nextMech) {
                        supportedAlgs.put(d, integerMech);
                        continue block1;
                    }
                    if (intOldMech == nextMech) continue block1;
                }
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Map.Entry entry : supportedAlgs.entrySet()) {
                    Descriptor d = (Descriptor)entry.getKey();
                    int mechanism = (Integer)entry.getValue();
                    P11Service s = d.service(token, mechanism);
                    JSignPKCS11.this.putService(s);
                }
                if ((token.tokenInfo.flags & 1L) != 0L && JSignPKCS11.this.config.isEnabled(2147483424L) && !token.sessionManager.lowMaxSessions()) {
                    JSignPKCS11.this.putService(new P11Service(token, JSignPKCS11.SR, "JSIGNPKCS11", "com.github.kwart.jsign.pkcs11.P11SecureRandom", null, 2147483424L));
                }
                if (JSignPKCS11.this.config.isEnabled(2147483425L)) {
                    JSignPKCS11.this.putService(new P11Service(token, JSignPKCS11.KS, "JSIGNPKCS11", "com.github.kwart.jsign.pkcs11.P11KeyStore", JSignPKCS11.s(new String[]{"JSIGNPKCS11-" + JSignPKCS11.this.config.getName()}), 2147483425L));
                }
                return null;
            }
        });
        this.token = token;
    }

    @Override
    public void login(Subject subject, CallbackHandler handler) throws LoginException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (debug != null) {
                debug.println("checking login permission");
            }
            sm.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        if (!this.hasValidToken()) {
            throw new LoginException("No token present");
        }
        if ((this.token.tokenInfo.flags & 4L) == 0L) {
            if (debug != null) {
                debug.println("login operation not required for token - ignoring login request");
            }
            return;
        }
        try {
            if (this.token.isLoggedInNow(null)) {
                if (debug != null) {
                    debug.println("user already logged in");
                }
                return;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        char[] pin = null;
        if ((this.token.tokenInfo.flags & 0x100L) == 0L) {
            CallbackHandler myHandler = this.getCallbackHandler(handler);
            if (myHandler == null) {
                throw new LoginException("no password provided, and no callback handler available for retrieving password");
            }
            MessageFormat form = new MessageFormat(ResourcesMgr.getString("PKCS11.Token.providerName.Password."));
            Object[] source = new Object[]{this.getName()};
            PasswordCallback pcall = new PasswordCallback(form.format(source), false);
            Callback[] callbacks = new Callback[]{pcall};
            try {
                myHandler.handle(callbacks);
            }
            catch (Exception e) {
                LoginException le = new LoginException("Unable to perform password callback");
                le.initCause(e);
                throw le;
            }
            pin = pcall.getPassword();
            pcall.clearPassword();
            if (pin == null && debug != null) {
                debug.println("caller passed NULL pin");
            }
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.p11.C_Login(session.id(), 1L, pin);
            if (debug != null) {
                debug.println("login succeeded");
            }
        }
        catch (PKCS11Exception pe) {
            if (pe.getErrorCode() == 256L) {
                if (debug != null) {
                    debug.println("user already logged in");
                }
                return;
            }
            if (pe.getErrorCode() == 160L) {
                FailedLoginException fle = new FailedLoginException();
                fle.initCause(pe);
                throw fle;
            }
            LoginException le = new LoginException();
            le.initCause(pe);
            throw le;
        }
        finally {
            this.token.releaseSession(session);
            if (pin != null) {
                Arrays.fill(pin, ' ');
            }
        }
    }

    void contextSpecificLogin(long sessionId, char[] qpin) throws LoginException {
        if (qpin == null && debug != null) {
            debug.println("no QPIN provided");
        }
        char[] pin = Arrays.copyOf(qpin, qpin.length);
        try {
            this.p11.C_Login(sessionId, 2L, pin);
            if (debug != null) {
                debug.println("login succeeded");
            }
        }
        catch (PKCS11Exception pe) {
            if (pe.getErrorCode() == 256L) {
                if (debug != null) {
                    debug.println("user already logged in");
                }
                return;
            }
            if (pe.getErrorCode() == 96L) {
                if (debug != null) {
                    debug.println("C_Login returned error code: CKR_KEY_HANDLE_INVALID. Ignoring.");
                }
                return;
            }
            if (pe.getErrorCode() == 160L) {
                FailedLoginException fle = new FailedLoginException();
                fle.initCause(pe);
                throw fle;
            }
            LoginException le = new LoginException();
            le.initCause(pe);
            throw le;
        }
        finally {
            if (pin != null) {
                Arrays.fill(pin, ' ');
            }
        }
    }

    @Override
    public void logout() throws LoginException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        if (!this.hasValidToken()) {
            return;
        }
        if ((this.token.tokenInfo.flags & 4L) == 0L) {
            if (debug != null) {
                debug.println("logout operation not required for token - ignoring logout request");
            }
            return;
        }
        try {
            if (!this.token.isLoggedInNow(null)) {
                if (debug != null) {
                    debug.println("user not logged in");
                }
                return;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.p11.C_Logout(session.id());
            if (debug != null) {
                debug.println("logout succeeded");
            }
        }
        catch (PKCS11Exception pe) {
            if (pe.getErrorCode() == 257L) {
                if (debug != null) {
                    debug.println("user not logged in");
                }
                return;
            }
            LoginException le = new LoginException();
            le.initCause(pe);
            throw le;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallbackHandler(CallbackHandler handler) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        Object object = this.LOCK_HANDLER;
        synchronized (object) {
            this.pHandler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallbackHandler getCallbackHandler(CallbackHandler handler) {
        if (handler != null) {
            return handler;
        }
        if (debug != null) {
            debug.println("getting provider callback handler");
        }
        Object object = this.LOCK_HANDLER;
        synchronized (object) {
            if (this.pHandler != null) {
                return this.pHandler;
            }
            try {
                CallbackHandler myHandler;
                if (debug != null) {
                    debug.println("getting default callback handler");
                }
                this.pHandler = myHandler = AccessController.doPrivileged(new PrivilegedExceptionAction<CallbackHandler>(){

                    @Override
                    public CallbackHandler run() throws Exception {
                        String defaultHandler = Security.getProperty("auth.login.defaultCallbackHandler");
                        if (defaultHandler == null || defaultHandler.length() == 0) {
                            if (debug != null) {
                                debug.println("no default handler set");
                            }
                            return null;
                        }
                        Class<?> c = Class.forName(defaultHandler, true, Thread.currentThread().getContextClassLoader());
                        return (CallbackHandler)c.newInstance();
                    }
                });
                return myHandler;
            }
            catch (PrivilegedActionException pae) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINEST, "Loading the default callback handler failed", pae);
                if (debug != null) {
                    debug.println("Unable to load default callback handler");
                }
            }
        }
        return null;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new JSignPKCS11Rep(this);
    }

    static {
        descriptors = new HashMap<Integer, List<Descriptor>>();
        String P11Digest2 = "com.github.kwart.jsign.pkcs11.P11Digest";
        String P11MAC = "com.github.kwart.jsign.pkcs11.P11MAC";
        String P11KeyPairGenerator2 = "com.github.kwart.jsign.pkcs11.P11KeyPairGenerator";
        String P11KeyGenerator2 = "com.github.kwart.jsign.pkcs11.P11KeyGenerator";
        String P11RSAKeyFactory2 = "com.github.kwart.jsign.pkcs11.P11RSAKeyFactory";
        String P11DSAKeyFactory2 = "com.github.kwart.jsign.pkcs11.P11DSAKeyFactory";
        String P11DHKeyFactory2 = "com.github.kwart.jsign.pkcs11.P11DHKeyFactory";
        String P11KeyAgreement2 = "com.github.kwart.jsign.pkcs11.P11KeyAgreement";
        String P11SecretKeyFactory2 = "com.github.kwart.jsign.pkcs11.P11SecretKeyFactory";
        String P11Cipher2 = "com.github.kwart.jsign.pkcs11.P11Cipher";
        String P11RSACipher2 = "com.github.kwart.jsign.pkcs11.P11RSACipher";
        String P11AEADCipher2 = "com.github.kwart.jsign.pkcs11.P11AEADCipher";
        String P11Signature2 = "com.github.kwart.jsign.pkcs11.P11Signature";
        String P11PSSSignature2 = "com.github.kwart.jsign.pkcs11.P11PSSSignature";
        JSignPKCS11.d(MD, "MD2", P11Digest2, JSignPKCS11.m(512L));
        JSignPKCS11.d(MD, "MD5", P11Digest2, JSignPKCS11.m(528L));
        JSignPKCS11.d(MD, "SHA1", P11Digest2, JSignPKCS11.s("SHA", "SHA-1", "1.3.14.3.2.26", "OID.1.3.14.3.2.26"), JSignPKCS11.m(544L));
        JSignPKCS11.d(MD, "SHA-224", P11Digest2, JSignPKCS11.s("2.16.840.1.101.3.4.2.4", "OID.2.16.840.1.101.3.4.2.4"), JSignPKCS11.m(597L));
        JSignPKCS11.d(MD, "SHA-256", P11Digest2, JSignPKCS11.s("2.16.840.1.101.3.4.2.1", "OID.2.16.840.1.101.3.4.2.1"), JSignPKCS11.m(592L));
        JSignPKCS11.d(MD, "SHA-384", P11Digest2, JSignPKCS11.s("2.16.840.1.101.3.4.2.2", "OID.2.16.840.1.101.3.4.2.2"), JSignPKCS11.m(608L));
        JSignPKCS11.d(MD, "SHA-512", P11Digest2, JSignPKCS11.s("2.16.840.1.101.3.4.2.3", "OID.2.16.840.1.101.3.4.2.3"), JSignPKCS11.m(624L));
        JSignPKCS11.d(MD, "SHA-512/224", P11Digest2, JSignPKCS11.s("2.16.840.1.101.3.4.2.5", "OID.2.16.840.1.101.3.4.2.5"), JSignPKCS11.m(72L));
        JSignPKCS11.d(MD, "SHA-512/256", P11Digest2, JSignPKCS11.s("2.16.840.1.101.3.4.2.6", "OID.2.16.840.1.101.3.4.2.6"), JSignPKCS11.m(76L));
        JSignPKCS11.d(MAC, "HmacMD5", P11MAC, JSignPKCS11.m(529L));
        JSignPKCS11.d(MAC, "HmacSHA1", P11MAC, JSignPKCS11.s("1.2.840.113549.2.7", "OID.1.2.840.113549.2.7"), JSignPKCS11.m(545L));
        JSignPKCS11.d(MAC, "HmacSHA224", P11MAC, JSignPKCS11.s("1.2.840.113549.2.8", "OID.1.2.840.113549.2.8"), JSignPKCS11.m(598L));
        JSignPKCS11.d(MAC, "HmacSHA256", P11MAC, JSignPKCS11.s("1.2.840.113549.2.9", "OID.1.2.840.113549.2.9"), JSignPKCS11.m(593L));
        JSignPKCS11.d(MAC, "HmacSHA384", P11MAC, JSignPKCS11.s("1.2.840.113549.2.10", "OID.1.2.840.113549.2.10"), JSignPKCS11.m(609L));
        JSignPKCS11.d(MAC, "HmacSHA512", P11MAC, JSignPKCS11.s("1.2.840.113549.2.11", "OID.1.2.840.113549.2.11"), JSignPKCS11.m(625L));
        JSignPKCS11.d(MAC, "HmacSHA512/224", P11MAC, JSignPKCS11.s("1.2.840.113549.2.12", "OID.1.2.840.113549.2.12"), JSignPKCS11.m(73L));
        JSignPKCS11.d(MAC, "HmacSHA512/256", P11MAC, JSignPKCS11.s("1.2.840.113549.2.13", "OID.1.2.840.113549.2.13"), JSignPKCS11.m(77L));
        JSignPKCS11.d(MAC, "SslMacMD5", P11MAC, JSignPKCS11.m(896L));
        JSignPKCS11.d(MAC, "SslMacSHA1", P11MAC, JSignPKCS11.m(897L));
        JSignPKCS11.d(KPG, "RSA", P11KeyPairGenerator2, JSignPKCS11.s("1.2.840.113549.1.1", "OID.1.2.840.113549.1.1"), JSignPKCS11.m(0L));
        JSignPKCS11.d(KPG, "DSA", P11KeyPairGenerator2, JSignPKCS11.s("1.3.14.3.2.12", "1.2.840.10040.4.1", "OID.1.2.840.10040.4.1"), JSignPKCS11.m(16L));
        JSignPKCS11.d(KPG, "DH", P11KeyPairGenerator2, JSignPKCS11.s("DiffieHellman"), JSignPKCS11.m(32L));
        JSignPKCS11.d(KPG, "EC", P11KeyPairGenerator2, JSignPKCS11.m(4160L));
        JSignPKCS11.d(KG, "ARCFOUR", P11KeyGenerator2, JSignPKCS11.s("RC4"), JSignPKCS11.m(272L));
        JSignPKCS11.d(KG, "DES", P11KeyGenerator2, JSignPKCS11.m(288L));
        JSignPKCS11.d(KG, "DESede", P11KeyGenerator2, JSignPKCS11.m(305L, 304L));
        JSignPKCS11.d(KG, "AES", P11KeyGenerator2, JSignPKCS11.m(4224L));
        JSignPKCS11.d(KG, "Blowfish", P11KeyGenerator2, JSignPKCS11.m(4240L));
        JSignPKCS11.d(KF, "RSA", P11RSAKeyFactory2, JSignPKCS11.s("1.2.840.113549.1.1", "OID.1.2.840.113549.1.1"), JSignPKCS11.m(0L, 1L, 3L));
        JSignPKCS11.d(KF, "DSA", P11DSAKeyFactory2, JSignPKCS11.s("1.3.14.3.2.12", "1.2.840.10040.4.1", "OID.1.2.840.10040.4.1"), JSignPKCS11.m(16L, 17L, 18L));
        JSignPKCS11.d(KF, "DH", P11DHKeyFactory2, JSignPKCS11.s("DiffieHellman"), JSignPKCS11.m(32L, 33L));
        JSignPKCS11.d(KF, "EC", P11DHKeyFactory2, JSignPKCS11.m(4160L, 4176L, 4161L, 4162L));
        JSignPKCS11.d(AGP, "EC", "sun.security.util.ECParameters", JSignPKCS11.s("1.2.840.10045.2.1"), JSignPKCS11.m(4160L, 4176L, 4161L, 4162L));
        JSignPKCS11.d(AGP, "GCM", "sun.security.util.GCMParameters", JSignPKCS11.m(4231L));
        JSignPKCS11.d(KA, "DH", P11KeyAgreement2, JSignPKCS11.s("DiffieHellman"), JSignPKCS11.m(33L));
        JSignPKCS11.d(KA, "ECDH", "com.github.kwart.jsign.pkcs11.P11ECDHKeyAgreement", JSignPKCS11.m(4176L));
        JSignPKCS11.d(SKF, "ARCFOUR", P11SecretKeyFactory2, JSignPKCS11.s("RC4"), JSignPKCS11.m(273L));
        JSignPKCS11.d(SKF, "DES", P11SecretKeyFactory2, JSignPKCS11.m(290L));
        JSignPKCS11.d(SKF, "DESede", P11SecretKeyFactory2, JSignPKCS11.m(307L));
        JSignPKCS11.d(SKF, "AES", P11SecretKeyFactory2, JSignPKCS11.s("2.16.840.1.101.3.4.1", "OID.2.16.840.1.101.3.4.1"), JSignPKCS11.m(4226L));
        JSignPKCS11.d(SKF, "Blowfish", P11SecretKeyFactory2, JSignPKCS11.m(4241L));
        JSignPKCS11.d(CIP, "ARCFOUR", P11Cipher2, JSignPKCS11.s("RC4"), JSignPKCS11.m(273L));
        JSignPKCS11.d(CIP, "DES/CBC/NoPadding", P11Cipher2, JSignPKCS11.m(290L));
        JSignPKCS11.d(CIP, "DES/CBC/PKCS5Padding", P11Cipher2, JSignPKCS11.m(293L, 290L));
        JSignPKCS11.d(CIP, "DES/ECB/NoPadding", P11Cipher2, JSignPKCS11.m(289L));
        JSignPKCS11.d(CIP, "DES/ECB/PKCS5Padding", P11Cipher2, JSignPKCS11.s("DES"), JSignPKCS11.m(289L));
        JSignPKCS11.d(CIP, "DESede/CBC/NoPadding", P11Cipher2, JSignPKCS11.m(307L));
        JSignPKCS11.d(CIP, "DESede/CBC/PKCS5Padding", P11Cipher2, JSignPKCS11.m(310L, 307L));
        JSignPKCS11.d(CIP, "DESede/ECB/NoPadding", P11Cipher2, JSignPKCS11.m(306L));
        JSignPKCS11.d(CIP, "DESede/ECB/PKCS5Padding", P11Cipher2, JSignPKCS11.s("DESede"), JSignPKCS11.m(306L));
        JSignPKCS11.d(CIP, "AES/CBC/NoPadding", P11Cipher2, JSignPKCS11.m(4226L));
        JSignPKCS11.d(CIP, "AES_128/CBC/NoPadding", P11Cipher2, JSignPKCS11.s("2.16.840.1.101.3.4.1.2", "OID.2.16.840.1.101.3.4.1.2"), JSignPKCS11.m(4226L));
        JSignPKCS11.d(CIP, "AES_192/CBC/NoPadding", P11Cipher2, JSignPKCS11.s("2.16.840.1.101.3.4.1.22", "OID.2.16.840.1.101.3.4.1.22"), JSignPKCS11.m(4226L));
        JSignPKCS11.d(CIP, "AES_256/CBC/NoPadding", P11Cipher2, JSignPKCS11.s("2.16.840.1.101.3.4.1.42", "OID.2.16.840.1.101.3.4.1.42"), JSignPKCS11.m(4226L));
        JSignPKCS11.d(CIP, "AES/CBC/PKCS5Padding", P11Cipher2, JSignPKCS11.m(4229L, 4226L));
        JSignPKCS11.d(CIP, "AES/ECB/NoPadding", P11Cipher2, JSignPKCS11.m(4225L));
        JSignPKCS11.d(CIP, "AES_128/ECB/NoPadding", P11Cipher2, JSignPKCS11.s("2.16.840.1.101.3.4.1.1", "OID.2.16.840.1.101.3.4.1.1"), JSignPKCS11.m(4225L));
        JSignPKCS11.d(CIP, "AES_192/ECB/NoPadding", P11Cipher2, JSignPKCS11.s("2.16.840.1.101.3.4.1.21", "OID.2.16.840.1.101.3.4.1.21"), JSignPKCS11.m(4225L));
        JSignPKCS11.d(CIP, "AES_256/ECB/NoPadding", P11Cipher2, JSignPKCS11.s("2.16.840.1.101.3.4.1.41", "OID.2.16.840.1.101.3.4.1.41"), JSignPKCS11.m(4225L));
        JSignPKCS11.d(CIP, "AES/ECB/PKCS5Padding", P11Cipher2, JSignPKCS11.s("AES"), JSignPKCS11.m(4225L));
        JSignPKCS11.d(CIP, "AES/CTR/NoPadding", P11Cipher2, JSignPKCS11.m(4230L));
        JSignPKCS11.d(CIP, "AES/GCM/NoPadding", P11AEADCipher2, JSignPKCS11.m(4231L));
        JSignPKCS11.d(CIP, "AES_128/GCM/NoPadding", P11AEADCipher2, JSignPKCS11.s("2.16.840.1.101.3.4.1.6", "OID.2.16.840.1.101.3.4.1.6"), JSignPKCS11.m(4231L));
        JSignPKCS11.d(CIP, "AES_192/GCM/NoPadding", P11AEADCipher2, JSignPKCS11.s("2.16.840.1.101.3.4.1.26", "OID.2.16.840.1.101.3.4.1.26"), JSignPKCS11.m(4231L));
        JSignPKCS11.d(CIP, "AES_256/GCM/NoPadding", P11AEADCipher2, JSignPKCS11.s("2.16.840.1.101.3.4.1.46", "OID.2.16.840.1.101.3.4.1.46"), JSignPKCS11.m(4231L));
        JSignPKCS11.d(CIP, "Blowfish/CBC/NoPadding", P11Cipher2, JSignPKCS11.m(4241L));
        JSignPKCS11.d(CIP, "Blowfish/CBC/PKCS5Padding", P11Cipher2, JSignPKCS11.m(4241L));
        JSignPKCS11.d(CIP, "RSA/ECB/PKCS1Padding", P11RSACipher2, JSignPKCS11.s("RSA"), JSignPKCS11.m(1L));
        JSignPKCS11.d(CIP, "RSA/ECB/NoPadding", P11RSACipher2, JSignPKCS11.m(3L));
        JSignPKCS11.d(SIG, "RawDSA", P11Signature2, JSignPKCS11.s("NONEwithDSA"), JSignPKCS11.m(17L));
        JSignPKCS11.d(SIG, "DSA", P11Signature2, JSignPKCS11.s("SHA1withDSA", "1.3.14.3.2.13", "1.3.14.3.2.27", "1.2.840.10040.4.3", "OID.1.2.840.10040.4.3"), JSignPKCS11.m(18L, 17L));
        JSignPKCS11.d(SIG, "SHA224withDSA", P11Signature2, JSignPKCS11.s("2.16.840.1.101.3.4.3.1", "OID.2.16.840.1.101.3.4.3.1"), JSignPKCS11.m(19L));
        JSignPKCS11.d(SIG, "SHA256withDSA", P11Signature2, JSignPKCS11.s("2.16.840.1.101.3.4.3.2", "OID.2.16.840.1.101.3.4.3.2"), JSignPKCS11.m(20L));
        JSignPKCS11.d(SIG, "SHA384withDSA", P11Signature2, JSignPKCS11.s("2.16.840.1.101.3.4.3.3", "OID.2.16.840.1.101.3.4.3.3"), JSignPKCS11.m(21L));
        JSignPKCS11.d(SIG, "SHA512withDSA", P11Signature2, JSignPKCS11.s("2.16.840.1.101.3.4.3.4", "OID.2.16.840.1.101.3.4.3.4"), JSignPKCS11.m(22L));
        JSignPKCS11.d(SIG, "NONEwithECDSA", P11Signature2, JSignPKCS11.m(4161L));
        JSignPKCS11.d(SIG, "SHA1withECDSA", P11Signature2, JSignPKCS11.s("ECDSA", "1.2.840.10045.4.1", "OID.1.2.840.10045.4.1"), JSignPKCS11.m(4162L, 4161L));
        JSignPKCS11.d(SIG, "SHA224withECDSA", P11Signature2, JSignPKCS11.s("1.2.840.10045.4.3.1", "OID.1.2.840.10045.4.3.1"), JSignPKCS11.m(4161L));
        JSignPKCS11.d(SIG, "SHA256withECDSA", P11Signature2, JSignPKCS11.s("1.2.840.10045.4.3.2", "OID.1.2.840.10045.4.3.2"), JSignPKCS11.m(4161L));
        JSignPKCS11.d(SIG, "SHA384withECDSA", P11Signature2, JSignPKCS11.s("1.2.840.10045.4.3.3", "OID.1.2.840.10045.4.3.3"), JSignPKCS11.m(4161L));
        JSignPKCS11.d(SIG, "SHA512withECDSA", P11Signature2, JSignPKCS11.s("1.2.840.10045.4.3.4", "OID.1.2.840.10045.4.3.4"), JSignPKCS11.m(4161L));
        JSignPKCS11.d(SIG, "MD2withRSA", P11Signature2, JSignPKCS11.s("1.2.840.113549.1.1.2", "OID.1.2.840.113549.1.1.2"), JSignPKCS11.m(4L, 1L, 3L));
        JSignPKCS11.d(SIG, "MD5withRSA", P11Signature2, JSignPKCS11.s("1.2.840.113549.1.1.4", "OID.1.2.840.113549.1.1.4"), JSignPKCS11.m(5L, 1L, 3L));
        JSignPKCS11.d(SIG, "SHA1withRSA", P11Signature2, JSignPKCS11.s("1.2.840.113549.1.1.5", "OID.1.2.840.113549.1.1.5", "1.3.14.3.2.29"), JSignPKCS11.m(6L, 1L, 3L));
        JSignPKCS11.d(SIG, "SHA224withRSA", P11Signature2, JSignPKCS11.s("1.2.840.113549.1.1.14", "OID.1.2.840.113549.1.1.14"), JSignPKCS11.m(70L, 1L, 3L));
        JSignPKCS11.d(SIG, "SHA256withRSA", P11Signature2, JSignPKCS11.s("1.2.840.113549.1.1.11", "OID.1.2.840.113549.1.1.11"), JSignPKCS11.m(64L, 1L, 3L));
        JSignPKCS11.d(SIG, "SHA384withRSA", P11Signature2, JSignPKCS11.s("1.2.840.113549.1.1.12", "OID.1.2.840.113549.1.1.12"), JSignPKCS11.m(65L, 1L, 3L));
        JSignPKCS11.d(SIG, "SHA512withRSA", P11Signature2, JSignPKCS11.s("1.2.840.113549.1.1.13", "OID.1.2.840.113549.1.1.13"), JSignPKCS11.m(66L, 1L, 3L));
        JSignPKCS11.d(SIG, "RSASSA-PSS", P11PSSSignature2, JSignPKCS11.s("1.2.840.113549.1.1.10", "OID.1.2.840.113549.1.1.10"), JSignPKCS11.m(13L));
        JSignPKCS11.d(SIG, "SHA1withRSASSA-PSS", P11PSSSignature2, JSignPKCS11.m(14L));
        JSignPKCS11.d(SIG, "SHA224withRSASSA-PSS", P11PSSSignature2, JSignPKCS11.m(71L));
        JSignPKCS11.d(SIG, "SHA256withRSASSA-PSS", P11PSSSignature2, JSignPKCS11.m(67L));
        JSignPKCS11.d(SIG, "SHA384withRSASSA-PSS", P11PSSSignature2, JSignPKCS11.m(68L));
        JSignPKCS11.d(SIG, "SHA512withRSASSA-PSS", P11PSSSignature2, JSignPKCS11.m(69L));
        JSignPKCS11.d(KG, "SunTlsRsaPremasterSecret", "com.github.kwart.jsign.pkcs11.P11TlsRsaPremasterSecretGenerator", JSignPKCS11.s("SunTls12RsaPremasterSecret"), JSignPKCS11.m(880L, 884L));
        JSignPKCS11.d(KG, "SunTlsMasterSecret", "com.github.kwart.jsign.pkcs11.P11TlsMasterSecretGenerator", JSignPKCS11.m(881L, 885L, 883L, 887L));
        JSignPKCS11.d(KG, "SunTls12MasterSecret", "com.github.kwart.jsign.pkcs11.P11TlsMasterSecretGenerator", JSignPKCS11.m(992L, 994L));
        JSignPKCS11.d(KG, "SunTlsKeyMaterial", "com.github.kwart.jsign.pkcs11.P11TlsKeyMaterialGenerator", JSignPKCS11.m(882L, 886L));
        JSignPKCS11.d(KG, "SunTls12KeyMaterial", "com.github.kwart.jsign.pkcs11.P11TlsKeyMaterialGenerator", JSignPKCS11.m(993L));
        JSignPKCS11.d(KG, "SunTlsPrf", "com.github.kwart.jsign.pkcs11.P11TlsPrfGenerator", JSignPKCS11.m(888L, 2147484531L));
        JSignPKCS11.d(KG, "SunTls12Prf", "com.github.kwart.jsign.pkcs11.P11TlsPrfGenerator", JSignPKCS11.m(996L));
    }

    private static class JSignPKCS11Rep
    implements Serializable {
        static final long serialVersionUID = -2896606995897745419L;
        private final String providerName;
        private final String configName;

        JSignPKCS11Rep(JSignPKCS11 provider) throws NotSerializableException {
            this.providerName = provider.getName();
            this.configName = provider.configName;
            if (Security.getProvider(this.providerName) != provider) {
                throw new NotSerializableException("Only JSignPKCS11 providers installed in java.security.Security can be serialized");
            }
        }

        private Object readResolve() throws ObjectStreamException {
            JSignPKCS11 p = (JSignPKCS11)Security.getProvider(this.providerName);
            if (p == null || !p.configName.equals(this.configName)) {
                throw new NotSerializableException("Could not find " + this.providerName + " in installed providers");
            }
            return p;
        }
    }

    private static final class P11Service
    extends Provider.Service {
        private final Token token;
        private final long mechanism;

        P11Service(Token token, String type, String algorithm, String className, String[] al, long mechanism) {
            super(token.provider, type, algorithm, className, P11Service.toList(al), null);
            this.token = token;
            this.mechanism = mechanism & 0xFFFFFFFFL;
        }

        private static List<String> toList(String[] aliases) {
            return aliases == null ? null : Arrays.asList(aliases);
        }

        @Override
        public Object newInstance(Object param) throws NoSuchAlgorithmException {
            if (!this.token.isValid()) {
                throw new NoSuchAlgorithmException("Token has been removed");
            }
            try {
                return this.newInstance0(param);
            }
            catch (PKCS11Exception e) {
                throw new NoSuchAlgorithmException(e);
            }
        }

        public Object newInstance0(Object param) throws PKCS11Exception, NoSuchAlgorithmException {
            String algorithm = this.getAlgorithm();
            String type = this.getType();
            if (type == JSignPKCS11.MD) {
                return new P11Digest(this.token, algorithm, this.mechanism);
            }
            if (type == JSignPKCS11.CIP) {
                if (algorithm.startsWith("RSA")) {
                    return new P11RSACipher(this.token, algorithm, this.mechanism);
                }
                if (algorithm.endsWith("GCM/NoPadding")) {
                    return new P11AEADCipher(this.token, algorithm, this.mechanism);
                }
                return new P11Cipher(this.token, algorithm, this.mechanism);
            }
            if (type == JSignPKCS11.SIG) {
                if (algorithm.indexOf("RSASSA-PSS") != -1) {
                    return new P11PSSSignature(this.token, algorithm, this.mechanism);
                }
                return new P11Signature(this.token, algorithm, this.mechanism);
            }
            if (type == JSignPKCS11.MAC) {
                return new P11Mac(this.token, algorithm, this.mechanism);
            }
            if (type == JSignPKCS11.KPG) {
                return new P11KeyPairGenerator(this.token, algorithm, this.mechanism);
            }
            if (type == JSignPKCS11.KA) {
                if (algorithm.equals("ECDH")) {
                    return new P11ECDHKeyAgreement(this.token, algorithm, this.mechanism);
                }
                return new P11KeyAgreement(this.token, algorithm, this.mechanism);
            }
            if (type == JSignPKCS11.KF) {
                return this.token.getKeyFactory(algorithm);
            }
            if (type == JSignPKCS11.SKF) {
                return new P11SecretKeyFactory(this.token, algorithm);
            }
            if (type == JSignPKCS11.KG) {
                if (algorithm == "SunTlsRsaPremasterSecret") {
                    return new P11TlsRsaPremasterSecretGenerator(this.token, algorithm, this.mechanism);
                }
                if (algorithm == "SunTlsMasterSecret" || algorithm == "SunTls12MasterSecret") {
                    return new P11TlsMasterSecretGenerator(this.token, algorithm, this.mechanism);
                }
                if (algorithm == "SunTlsKeyMaterial" || algorithm == "SunTls12KeyMaterial") {
                    return new P11TlsKeyMaterialGenerator(this.token, algorithm, this.mechanism);
                }
                if (algorithm == "SunTlsPrf" || algorithm == "SunTls12Prf") {
                    return new P11TlsPrfGenerator(this.token, algorithm, this.mechanism);
                }
                return new P11KeyGenerator(this.token, algorithm, this.mechanism);
            }
            if (type == JSignPKCS11.SR) {
                return this.token.getRandom();
            }
            if (type == JSignPKCS11.KS) {
                return this.token.getKeyStore();
            }
            if (type == JSignPKCS11.AGP) {
                if (algorithm == "EC") {
                    return new ECParameters();
                }
                if (algorithm == "GCM") {
                    return new GCMParameters();
                }
                throw new NoSuchAlgorithmException("Unsupported algorithm: " + algorithm);
            }
            throw new NoSuchAlgorithmException("Unknown type: " + type);
        }

        @Override
        public boolean supportsParameter(Object param) {
            if (param == null || !this.token.isValid()) {
                return false;
            }
            if (!(param instanceof Key)) {
                throw new InvalidParameterException("Parameter must be a Key");
            }
            String algorithm = this.getAlgorithm();
            String type = this.getType();
            Key key = (Key)param;
            String keyAlgorithm = key.getAlgorithm();
            if (type == JSignPKCS11.CIP && algorithm.startsWith("RSA") || type == JSignPKCS11.SIG && algorithm.indexOf("RSA") != -1) {
                if (!keyAlgorithm.equals("RSA")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof RSAPrivateKey || key instanceof RSAPublicKey;
            }
            if (type == JSignPKCS11.KA && algorithm.equals("ECDH") || type == JSignPKCS11.SIG && algorithm.endsWith("ECDSA")) {
                if (!keyAlgorithm.equals("EC")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof ECPrivateKey || key instanceof ECPublicKey;
            }
            if (type == JSignPKCS11.SIG && algorithm.endsWith("DSA")) {
                if (!keyAlgorithm.equals("DSA")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof DSAPrivateKey || key instanceof DSAPublicKey;
            }
            if (type == JSignPKCS11.CIP || type == JSignPKCS11.MAC) {
                return this.isLocalKey(key) || "RAW".equals(key.getFormat());
            }
            if (type == JSignPKCS11.KA) {
                if (!keyAlgorithm.equals("DH")) {
                    return false;
                }
                return this.isLocalKey(key) || key instanceof DHPrivateKey || key instanceof DHPublicKey;
            }
            throw new AssertionError((Object)("JSignPKCS11 error: " + type + ", " + algorithm));
        }

        private boolean isLocalKey(Key key) {
            return key instanceof P11Key && ((P11Key)key).token == this.token;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + Functions.getMechanismName(this.mechanism) + ")";
        }
    }

    private static class TokenPoller
    implements Runnable {
        private final JSignPKCS11 provider;
        private volatile boolean enabled;

        private TokenPoller(JSignPKCS11 provider) {
            this.provider = provider;
            this.enabled = true;
        }

        @Override
        public void run() {
            int interval = this.provider.config.getInsertionCheckInterval();
            while (this.enabled) {
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!this.enabled) break;
                try {
                    this.provider.initToken(null);
                }
                catch (PKCS11Exception pKCS11Exception) {}
            }
        }

        void disable() {
            this.enabled = false;
        }
    }

    private static final class Descriptor {
        final String type;
        final String algorithm;
        final String className;
        final String[] aliases;
        final int[] mechanisms;

        private Descriptor(String type, String algorithm, String className, String[] aliases, int[] mechanisms) {
            this.type = type;
            this.algorithm = algorithm;
            this.className = className;
            this.aliases = aliases;
            this.mechanisms = mechanisms;
        }

        private P11Service service(Token token, int mechanism) {
            return new P11Service(token, this.type, this.algorithm, this.className, this.aliases, mechanism);
        }

        public String toString() {
            return this.type + "." + this.algorithm;
        }
    }
}

