/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.P11Key;
import com.github.kwart.jsign.pkcs11.P11KeyFactory;
import com.github.kwart.jsign.pkcs11.P11Util;
import com.github.kwart.jsign.pkcs11.Session;
import com.github.kwart.jsign.pkcs11.Token;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.provider.DSAPrivateKey;
import sun.security.provider.DSAPublicKey;

final class P11DSAKeyFactory
extends P11KeyFactory {
    P11DSAKeyFactory(Token token, String algorithm) {
        super(token, algorithm);
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.DSAPublicKey) {
                java.security.interfaces.DSAPublicKey dsaKey = (java.security.interfaces.DSAPublicKey)key;
                DSAParams params = dsaKey.getParams();
                return this.generatePublic(dsaKey.getY(), params.getP(), params.getQ(), params.getG());
            }
            if ("X.509".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = new DSAPublicKey(encoded);
                return this.implTranslatePublicKey(key);
            }
            throw new InvalidKeyException("PublicKey must be instance of DSAPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create DSA public key", e);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.DSAPrivateKey) {
                java.security.interfaces.DSAPrivateKey dsaKey = (java.security.interfaces.DSAPrivateKey)key;
                DSAParams params = dsaKey.getParams();
                return this.generatePrivate(dsaKey.getX(), params.getP(), params.getQ(), params.getG());
            }
            if ("PKCS#8".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = new DSAPrivateKey(encoded);
                return this.implTranslatePrivateKey(key);
            }
            throw new InvalidKeyException("PrivateKey must be instance of DSAPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create DSA private key", e);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] encoded = ((X509EncodedKeySpec)keySpec).getEncoded();
                DSAPublicKey key = new DSAPublicKey(encoded);
                return this.implTranslatePublicKey(key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Could not create DSA public key", e);
            }
        }
        if (!(keySpec instanceof DSAPublicKeySpec)) {
            throw new InvalidKeySpecException("Only DSAPublicKeySpec and X509EncodedKeySpec supported for DSA public keys");
        }
        try {
            DSAPublicKeySpec ds = (DSAPublicKeySpec)keySpec;
            return this.generatePublic(ds.getY(), ds.getP(), ds.getQ(), ds.getG());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create DSA public key", e);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] encoded = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                DSAPrivateKey key = new DSAPrivateKey(encoded);
                return this.implTranslatePrivateKey(key);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Could not create DSA private key", e);
            }
        }
        if (!(keySpec instanceof DSAPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only DSAPrivateKeySpec and PKCS8EncodedKeySpec supported for DSA private keys");
        }
        try {
            DSAPrivateKeySpec ds = (DSAPrivateKeySpec)keySpec;
            return this.generatePrivate(ds.getX(), ds.getP(), ds.getQ(), ds.getG());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create DSA private key", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(BigInteger y, BigInteger p, BigInteger q, BigInteger g) throws PKCS11Exception {
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 1L), new CK_ATTRIBUTE(17L, y), new CK_ATTRIBUTE(304L, p), new CK_ATTRIBUTE(305L, q), new CK_ATTRIBUTE(306L, g)};
        attributes = this.token.getAttributes("import", 2L, 1L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PublicKey publicKey = P11Key.publicKey(session, keyID, "DSA", p.bitLength(), attributes);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger x, BigInteger p, BigInteger q, BigInteger g) throws PKCS11Exception {
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 1L), new CK_ATTRIBUTE(17L, x), new CK_ATTRIBUTE(304L, p), new CK_ATTRIBUTE(305L, q), new CK_ATTRIBUTE(306L, g)};
        attributes = this.token.getAttributes("import", 3L, 1L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PrivateKey privateKey = P11Key.privateKey(session, keyID, "DSA", p.bitLength(), attributes);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends KeySpec> T implGetPublicKeySpec(P11Key key, Class<T> keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (DSAPublicKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(305L), new CK_ATTRIBUTE(306L)};
            long keyID = key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(session[0].id(), keyID, attributes);
            }
            finally {
                key.releaseKeyID();
            }
            DSAPublicKeySpec spec = new DSAPublicKeySpec(attributes[0].getBigInteger(), attributes[1].getBigInteger(), attributes[2].getBigInteger(), attributes[3].getBigInteger());
            return (T)((KeySpec)keySpec.cast(spec));
        }
        throw new InvalidKeySpecException("Only DSAPublicKeySpec and X509EncodedKeySpec supported for DSA public keys");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends KeySpec> T implGetPrivateKeySpec(P11Key key, Class<T> keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (DSAPrivateKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(305L), new CK_ATTRIBUTE(306L)};
            long keyID = key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(session[0].id(), keyID, attributes);
            }
            finally {
                key.releaseKeyID();
            }
            DSAPrivateKeySpec spec = new DSAPrivateKeySpec(attributes[0].getBigInteger(), attributes[1].getBigInteger(), attributes[2].getBigInteger(), attributes[3].getBigInteger());
            return (T)((KeySpec)keySpec.cast(spec));
        }
        throw new InvalidKeySpecException("Only DSAPrivateKeySpec and PKCS8EncodedKeySpec supported for DSA private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return KeyFactory.getInstance("DSA", P11Util.getSunProvider());
    }
}

