/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.P11Key;
import com.github.kwart.jsign.pkcs11.P11SecretKeyFactory;
import com.github.kwart.jsign.pkcs11.P11Util;
import com.github.kwart.jsign.pkcs11.Session;
import com.github.kwart.jsign.pkcs11.Token;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.rsa.RSAKeyFactory;
import sun.security.util.Debug;
import sun.security.util.DerValue;
import sun.security.util.ECUtil;

final class P11KeyStore
extends KeyStoreSpi {
    private static final CK_ATTRIBUTE ATTR_CLASS_CERT = new CK_ATTRIBUTE(0L, 1L);
    private static final CK_ATTRIBUTE ATTR_CLASS_PKEY = new CK_ATTRIBUTE(0L, 3L);
    private static final CK_ATTRIBUTE ATTR_CLASS_SKEY = new CK_ATTRIBUTE(0L, 4L);
    private static final CK_ATTRIBUTE ATTR_X509_CERT_TYPE = new CK_ATTRIBUTE(128L, 0L);
    private static final CK_ATTRIBUTE ATTR_TOKEN_TRUE;
    private static CK_ATTRIBUTE ATTR_SKEY_TOKEN_TRUE;
    private static final CK_ATTRIBUTE ATTR_TRUSTED_TRUE;
    private static final CK_ATTRIBUTE ATTR_PRIVATE_TRUE;
    private static final long NO_HANDLE = -1L;
    private static final long FINDOBJECTS_MAX = 100L;
    private static final String ALIAS_SEP = "/";
    private static final boolean NSS_TEST = false;
    private static final Debug debug;
    private static boolean CKA_TRUSTED_SUPPORTED;
    private final Token token;
    private boolean writeDisabled = false;
    private HashMap<String, AliasInfo> aliasMap;
    private static final long[] LONG0;

    P11KeyStore(Token token) {
        this.token = token;
    }

    @Override
    public synchronized Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        this.token.ensureValid();
        if (password != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new NoSuchAlgorithmException("password must be null");
        }
        AliasInfo aliasInfo = this.aliasMap.get(alias);
        if (aliasInfo == null || aliasInfo.type == ATTR_CLASS_CERT) {
            return null;
        }
        Session session = null;
        try {
            THandle h;
            session = this.token.getOpSession();
            if (aliasInfo.type == ATTR_CLASS_PKEY) {
                h = this.getTokenObject(session, aliasInfo.type, aliasInfo.id, null);
                if (h.type == ATTR_CLASS_PKEY) {
                    PrivateKey pkey = this.loadPkey(session, h.handle);
                    if (pkey instanceof P11Key && password != null) {
                        ((P11Key)((Object)pkey)).qPin = Arrays.copyOf(password, password.length);
                    }
                    PrivateKey privateKey = pkey;
                    return privateKey;
                }
            } else {
                h = this.getTokenObject(session, ATTR_CLASS_SKEY, null, alias);
                if (h.type == ATTR_CLASS_SKEY) {
                    SecretKey secretKey = this.loadSkey(session, h.handle);
                    return secretKey;
                }
            }
            h = null;
            return h;
        }
        catch (KeyStoreException | PKCS11Exception e) {
            throw new ProviderException(e);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    @Override
    public synchronized Certificate[] engineGetCertificateChain(String alias) {
        this.token.ensureValid();
        AliasInfo aliasInfo = this.aliasMap.get(alias);
        if (aliasInfo == null || aliasInfo.type != ATTR_CLASS_PKEY) {
            return null;
        }
        return aliasInfo.chain;
    }

    @Override
    public synchronized Certificate engineGetCertificate(String alias) {
        this.token.ensureValid();
        AliasInfo aliasInfo = this.aliasMap.get(alias);
        if (aliasInfo == null) {
            return null;
        }
        return aliasInfo.cert;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        this.token.ensureValid();
        throw new ProviderException(new UnsupportedOperationException());
    }

    @Override
    public synchronized void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.token.ensureValid();
        this.checkWrite();
        if (!(key instanceof PrivateKey) && !(key instanceof SecretKey)) {
            throw new KeyStoreException("key must be PrivateKey or SecretKey");
        }
        if (key instanceof PrivateKey && chain == null) {
            throw new KeyStoreException("PrivateKey must be accompanied by non-null chain");
        }
        if (key instanceof SecretKey && chain != null) {
            throw new KeyStoreException("SecretKey must be accompanied by null chain");
        }
        if (password != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new KeyStoreException("Password must be null");
        }
        KeyStore.Entry entry = null;
        try {
            if (key instanceof PrivateKey) {
                entry = new KeyStore.PrivateKeyEntry((PrivateKey)key, chain);
            } else if (key instanceof SecretKey) {
                entry = new KeyStore.SecretKeyEntry((SecretKey)key);
            }
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new KeyStoreException(e);
        }
        this.engineSetEntry(alias, entry, new KeyStore.PasswordProtection(password));
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.token.ensureValid();
        throw new ProviderException(new UnsupportedOperationException());
    }

    @Override
    public synchronized void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.token.ensureValid();
        this.checkWrite();
        if (cert == null) {
            throw new KeyStoreException("invalid null certificate");
        }
        KeyStore.TrustedCertificateEntry entry = null;
        entry = new KeyStore.TrustedCertificateEntry(cert);
        this.engineSetEntry(alias, entry, null);
    }

    @Override
    public synchronized void engineDeleteEntry(String alias) throws KeyStoreException {
        this.token.ensureValid();
        if (this.token.isWriteProtected()) {
            throw new KeyStoreException("token write-protected");
        }
        this.checkWrite();
        this.deleteEntry(alias);
    }

    private boolean deleteEntry(String alias) throws KeyStoreException {
        AliasInfo aliasInfo = this.aliasMap.get(alias);
        if (aliasInfo != null) {
            this.aliasMap.remove(alias);
            try {
                if (aliasInfo.type == ATTR_CLASS_CERT) {
                    return this.destroyCert(aliasInfo.id);
                }
                if (aliasInfo.type == ATTR_CLASS_PKEY) {
                    return this.destroyPkey(aliasInfo.id) && this.destroyChain(aliasInfo.id);
                }
                if (aliasInfo.type == ATTR_CLASS_SKEY) {
                    return this.destroySkey(alias);
                }
                throw new KeyStoreException("unexpected entry type");
            }
            catch (CertificateException | PKCS11Exception e) {
                throw new KeyStoreException(e);
            }
        }
        return false;
    }

    @Override
    public synchronized Enumeration<String> engineAliases() {
        this.token.ensureValid();
        return Collections.enumeration(new HashSet<String>(this.aliasMap.keySet()));
    }

    @Override
    public synchronized boolean engineContainsAlias(String alias) {
        this.token.ensureValid();
        return this.aliasMap.containsKey(alias);
    }

    @Override
    public synchronized int engineSize() {
        this.token.ensureValid();
        return this.aliasMap.size();
    }

    @Override
    public synchronized boolean engineIsKeyEntry(String alias) {
        this.token.ensureValid();
        AliasInfo aliasInfo = this.aliasMap.get(alias);
        return aliasInfo != null && aliasInfo.type != ATTR_CLASS_CERT;
    }

    @Override
    public synchronized boolean engineIsCertificateEntry(String alias) {
        this.token.ensureValid();
        AliasInfo aliasInfo = this.aliasMap.get(alias);
        return aliasInfo != null && aliasInfo.type == ATTR_CLASS_CERT;
    }

    @Override
    public synchronized String engineGetCertificateAlias(Certificate cert) {
        this.token.ensureValid();
        Enumeration<String> e = this.engineAliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            Certificate tokenCert = this.engineGetCertificate(alias);
            if (tokenCert == null || !tokenCert.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    @Override
    public synchronized void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.token.ensureValid();
        if (stream != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new IOException("output stream must be null");
        }
        if (password != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new IOException("password must be null");
        }
    }

    @Override
    public synchronized void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.token.ensureValid();
        if (param != null) {
            throw new IllegalArgumentException("LoadStoreParameter must be null");
        }
    }

    @Override
    public synchronized void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.token.ensureValid();
        if (stream != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new IOException("input stream must be null");
        }
        try {
            if (password == null) {
                this.login(null);
            } else {
                this.login(new PasswordCallbackHandler(password));
            }
        }
        catch (LoginException e) {
            PKCS11Exception pe;
            Throwable cause = e.getCause();
            if (cause instanceof PKCS11Exception && (pe = (PKCS11Exception)cause).getErrorCode() == 160L) {
                throw new IOException("load failed", new UnrecoverableKeyException().initCause(e));
            }
            throw new IOException("load failed", e);
        }
        try {
            if (this.mapLabels()) {
                this.writeDisabled = true;
            }
            if (debug != null) {
                this.dumpTokenMap();
                debug.println("P11KeyStore load. Entry count: " + this.aliasMap.size());
            }
        }
        catch (KeyStoreException | PKCS11Exception e) {
            throw new IOException("load failed", e);
        }
    }

    @Override
    public synchronized void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        CallbackHandler handler;
        this.token.ensureValid();
        if (param == null) {
            throw new IllegalArgumentException("invalid null LoadStoreParameter");
        }
        KeyStore.ProtectionParameter pp = param.getProtectionParameter();
        if (pp instanceof KeyStore.PasswordProtection) {
            char[] password = ((KeyStore.PasswordProtection)pp).getPassword();
            handler = password == null ? null : new PasswordCallbackHandler(password);
        } else if (pp instanceof KeyStore.CallbackHandlerProtection) {
            handler = ((KeyStore.CallbackHandlerProtection)pp).getCallbackHandler();
        } else {
            throw new IllegalArgumentException("ProtectionParameter must be either PasswordProtection or CallbackHandlerProtection");
        }
        try {
            this.login(handler);
            if (this.mapLabels()) {
                this.writeDisabled = true;
            }
            if (debug != null) {
                this.dumpTokenMap();
            }
        }
        catch (KeyStoreException | LoginException | PKCS11Exception e) {
            throw new IOException("load failed", e);
        }
    }

    private void login(CallbackHandler handler) throws LoginException {
        if ((this.token.tokenInfo.flags & 0x100L) == 0L) {
            this.token.provider.login(null, handler);
        } else {
            if (handler != null && !this.token.config.getKeyStoreCompatibilityMode()) {
                throw new LoginException("can not specify password if token supports protected authentication path");
            }
            this.token.provider.login(null, null);
        }
    }

    @Override
    public synchronized KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        this.token.ensureValid();
        char[] password = null;
        if (protParam != null && protParam instanceof KeyStore.PasswordProtection) {
            password = ((KeyStore.PasswordProtection)protParam).getPassword();
        }
        if (password != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new KeyStoreException("ProtectionParameter must be null");
        }
        AliasInfo aliasInfo = this.aliasMap.get(alias);
        if (aliasInfo == null) {
            if (debug != null) {
                debug.println("engineGetEntry did not find alias [" + alias + "] in map");
            }
            return null;
        }
        Session session = null;
        try {
            THandle h;
            session = this.token.getOpSession();
            if (aliasInfo.type == ATTR_CLASS_CERT) {
                if (debug != null) {
                    debug.println("engineGetEntry found trusted cert entry");
                }
                KeyStore.TrustedCertificateEntry trustedCertificateEntry = new KeyStore.TrustedCertificateEntry(aliasInfo.cert);
                return trustedCertificateEntry;
            }
            if (aliasInfo.type == ATTR_CLASS_SKEY) {
                THandle h2;
                if (debug != null) {
                    debug.println("engineGetEntry found secret key entry");
                }
                if ((h2 = this.getTokenObject(session, ATTR_CLASS_SKEY, null, aliasInfo.label)).type != ATTR_CLASS_SKEY) {
                    throw new KeyStoreException("expected but could not find secret key");
                }
                SecretKey skey = this.loadSkey(session, h2.handle);
                KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(skey);
                return secretKeyEntry;
            }
            if (debug != null) {
                debug.println("engineGetEntry found private key entry");
            }
            if ((h = this.getTokenObject(session, ATTR_CLASS_PKEY, aliasInfo.id, null)).type != ATTR_CLASS_PKEY) {
                throw new KeyStoreException("expected but could not find private key");
            }
            PrivateKey pkey = this.loadPkey(session, h.handle);
            if (pkey instanceof P11Key && password != null) {
                ((P11Key)((Object)pkey)).qPin = Arrays.copyOf(password, password.length);
            }
            Certificate[] chain = aliasInfo.chain;
            if (pkey != null && chain != null) {
                KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(pkey, chain);
                return privateKeyEntry;
            }
            if (debug != null) {
                debug.println("engineGetEntry got null cert chain or private key");
            }
            h = null;
            return h;
        }
        catch (PKCS11Exception pe) {
            throw new KeyStoreException(pe);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        this.token.ensureValid();
        this.checkWrite();
        if (protParam != null && protParam instanceof KeyStore.PasswordProtection && ((KeyStore.PasswordProtection)protParam).getPassword() != null && !this.token.config.getKeyStoreCompatibilityMode()) {
            throw new KeyStoreException(new UnsupportedOperationException("ProtectionParameter must be null"));
        }
        if (this.token.isWriteProtected()) {
            throw new KeyStoreException("token write-protected");
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            throw new KeyStoreException(new UnsupportedOperationException("trusted certificates may only be set by token initialization application"));
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            key = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            if (!(key instanceof P11Key || key instanceof RSAPrivateKey || key instanceof DSAPrivateKey || key instanceof DHPrivateKey || key instanceof ECPrivateKey)) {
                throw new KeyStoreException("unsupported key type: " + key.getClass().getName());
            }
            chain = ((KeyStore.PrivateKeyEntry)entry).getCertificateChain();
            if (!(chain instanceof X509Certificate[])) {
                throw new KeyStoreException(new UnsupportedOperationException("unsupported certificate array type: " + chain.getClass().getName()));
            }
            try {
                updatedAlias = false;
                aliases = this.aliasMap.keySet();
                for (String oldAlias : aliases) {
                    aliasInfo = this.aliasMap.get(oldAlias);
                    if (AliasInfo.access$400(aliasInfo) != P11KeyStore.ATTR_CLASS_PKEY || !AliasInfo.access$900(aliasInfo).getPublicKey().equals(chain[0].getPublicKey())) continue;
                    this.updatePkey(alias, AliasInfo.access$500(aliasInfo), (X509Certificate[])chain, AliasInfo.access$900(aliasInfo).equals(chain[0]) == false);
                    updatedAlias = true;
                    break;
                }
                if (updatedAlias) ** GOTO lbl43
                this.engineDeleteEntry(alias);
                this.storePkey(alias, (KeyStore.PrivateKeyEntry)entry);
            }
            catch (CertificateException | PKCS11Exception pe) {
                throw new KeyStoreException(pe);
            }
        } else if (entry instanceof KeyStore.SecretKeyEntry) {
            ske = (KeyStore.SecretKeyEntry)entry;
            skey = ske.getSecretKey();
            try {
                aliasInfo = this.aliasMap.get(alias);
                if (aliasInfo != null) {
                    this.engineDeleteEntry(alias);
                }
                this.storeSkey(alias, ske);
            }
            catch (PKCS11Exception pe) {
                throw new KeyStoreException(pe);
            }
        } else {
            throw new KeyStoreException(new UnsupportedOperationException("unsupported entry type: " + entry.getClass().getName()));
        }
lbl43:
        // 3 sources

        try {
            this.mapLabels();
            if (P11KeyStore.debug != null) {
                this.dumpTokenMap();
            }
        }
        catch (CertificateException | PKCS11Exception pe) {
            throw new KeyStoreException(pe);
        }
        if (P11KeyStore.debug != null) {
            P11KeyStore.debug.println("engineSetEntry added new entry for [" + alias + "] to token");
        }
    }

    @Override
    public synchronized boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        this.token.ensureValid();
        return super.engineEntryInstanceOf(alias, entryClass);
    }

    private X509Certificate loadCert(Session session, long oHandle) throws PKCS11Exception, CertificateException {
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        this.token.p11.C_GetAttributeValue(session.id(), oHandle, attrs);
        byte[] bytes = attrs[0].getByteArray();
        if (bytes == null) {
            throw new CertificateException("unexpectedly retrieved null byte array");
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes));
    }

    private X509Certificate[] loadChain(Session session, X509Certificate endCert) throws PKCS11Exception, CertificateException {
        CK_ATTRIBUTE[] attrs;
        long[] ch;
        ArrayList<X509Certificate> lChain = null;
        if (endCert.getSubjectX500Principal().equals(endCert.getIssuerX500Principal())) {
            return new X509Certificate[]{endCert};
        }
        lChain = new ArrayList<X509Certificate>();
        lChain.add(endCert);
        X509Certificate next = endCert;
        while ((ch = P11KeyStore.findObjects(session, attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT, new CK_ATTRIBUTE(257L, next.getIssuerX500Principal().getEncoded())})) != null && ch.length != 0) {
            if (debug != null && ch.length > 1) {
                debug.println("engineGetEntry found " + ch.length + " certificate entries for subject [" + next.getIssuerX500Principal().toString() + "] in token - using first entry");
            }
            next = this.loadCert(session, ch[0]);
            lChain.add(next);
            if (!next.getSubjectX500Principal().equals(next.getIssuerX500Principal())) continue;
            break;
        }
        return lChain.toArray(new X509Certificate[lChain.size()]);
    }

    private SecretKey loadSkey(Session session, long oHandle) throws PKCS11Exception {
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
        this.token.p11.C_GetAttributeValue(session.id(), oHandle, attrs);
        long kType = attrs[0].getLong();
        String keyType = null;
        int keyLength = -1;
        if (kType == 19L || kType == 21L) {
            if (kType == 19L) {
                keyType = "DES";
                keyLength = 64;
            } else if (kType == 21L) {
                keyType = "DESede";
                keyLength = 192;
            }
        } else {
            if (kType == 31L) {
                keyType = "AES";
            } else if (kType == 32L) {
                keyType = "Blowfish";
            } else if (kType == 18L) {
                keyType = "ARCFOUR";
            } else {
                if (debug != null) {
                    debug.println("unknown key type [" + kType + "] - using 'Generic Secret'");
                }
                keyType = "Generic Secret";
            }
            attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(353L)};
            this.token.p11.C_GetAttributeValue(session.id(), oHandle, attrs);
            keyLength = (int)attrs[0].getLong();
        }
        return P11Key.secretKey(session, oHandle, keyType, keyLength, null);
    }

    private PrivateKey loadPkey(Session session, long oHandle) throws PKCS11Exception, KeyStoreException {
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
        this.token.p11.C_GetAttributeValue(session.id(), oHandle, attrs);
        long kType = attrs[0].getLong();
        String keyType = null;
        int keyLength = 0;
        if (kType == 0L) {
            keyType = "RSA";
            attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
            this.token.p11.C_GetAttributeValue(session.id(), oHandle, attrs);
            BigInteger modulus = attrs[0].getBigInteger();
            keyLength = modulus.bitLength();
            try {
                RSAKeyFactory.checkKeyLengths(keyLength, null, -1, Integer.MAX_VALUE);
            }
            catch (InvalidKeyException e) {
                throw new KeyStoreException(e.getMessage());
            }
            return P11Key.privateKey(session, oHandle, keyType, keyLength, null);
        }
        if (kType == 1L) {
            keyType = "DSA";
            attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L)};
            this.token.p11.C_GetAttributeValue(session.id(), oHandle, attrs);
            BigInteger prime = attrs[0].getBigInteger();
            keyLength = prime.bitLength();
            return P11Key.privateKey(session, oHandle, keyType, keyLength, null);
        }
        if (kType == 2L) {
            keyType = "DH";
            attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(304L)};
            this.token.p11.C_GetAttributeValue(session.id(), oHandle, attrs);
            BigInteger prime = attrs[0].getBigInteger();
            keyLength = prime.bitLength();
            return P11Key.privateKey(session, oHandle, keyType, keyLength, null);
        }
        if (kType == 3L) {
            attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L)};
            this.token.p11.C_GetAttributeValue(session.id(), oHandle, attrs);
            byte[] encodedParams = attrs[0].getByteArray();
            try {
                ECParameterSpec params = ECUtil.getECParameterSpec(null, encodedParams);
                keyLength = params.getCurve().getField().getFieldSize();
            }
            catch (IOException e) {
                throw new KeyStoreException("Unsupported parameters", e);
            }
            return P11Key.privateKey(session, oHandle, "EC", keyLength, null);
        }
        if (debug != null) {
            debug.println("unknown key type [" + kType + "]");
        }
        throw new KeyStoreException("unknown key type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePkey(String alias, byte[] cka_id, X509Certificate[] chain, boolean replaceCert) throws KeyStoreException, CertificateException, PKCS11Exception {
        replaceCert = true;
        Session session = null;
        try {
            CK_ATTRIBUTE[] attrs;
            session = this.token.getOpSession();
            THandle h = this.getTokenObject(session, ATTR_CLASS_PKEY, cka_id, null);
            if (h.type != ATTR_CLASS_PKEY) {
                throw new KeyStoreException("expected but could not find private key with CKA_ID " + P11KeyStore.getID(cka_id));
            }
            long pKeyHandle = h.handle;
            h = this.getTokenObject(session, ATTR_CLASS_CERT, cka_id, null);
            if (h.type != ATTR_CLASS_CERT) {
                throw new KeyStoreException("expected but could not find certificate with CKA_ID " + P11KeyStore.getID(cka_id));
            }
            if (replaceCert) {
                this.destroyChain(cka_id);
            } else {
                attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, alias), new CK_ATTRIBUTE(258L, alias)};
                this.token.p11.C_SetAttributeValue(session.id(), h.handle, attrs);
            }
            if (replaceCert) {
                this.storeChain(alias, chain);
            } else {
                this.storeCaCerts(chain, 1);
            }
            attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, alias)};
            this.token.p11.C_SetAttributeValue(session.id(), pKeyHandle, attrs);
            if (debug != null) {
                debug.println("updatePkey set new alias [" + alias + "] for private key entry");
            }
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateP11Pkey(String alias, CK_ATTRIBUTE attribute, P11Key key) throws PKCS11Exception {
        Session session = null;
        long keyID = key.getKeyID();
        try {
            session = this.token.getOpSession();
            if (key.tokenObject) {
                CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, alias)};
                this.token.p11.C_SetAttributeValue(session.id(), keyID, attrs);
                if (debug != null) {
                    debug.println("updateP11Pkey set new alias [" + alias + "] for key entry");
                }
            } else {
                CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, new CK_ATTRIBUTE(258L, alias)};
                if (attribute != null) {
                    attrs = P11KeyStore.addAttribute(attrs, attribute);
                }
                this.token.p11.C_CopyObject(session.id(), keyID, attrs);
                if (debug != null) {
                    debug.println("updateP11Pkey copied private session key for [" + alias + "] to token entry");
                }
            }
        }
        finally {
            this.token.releaseSession(session);
            key.releaseKeyID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCert(String alias, X509Certificate cert) throws PKCS11Exception, CertificateException {
        ArrayList<CK_ATTRIBUTE> attrList = new ArrayList<CK_ATTRIBUTE>();
        attrList.add(ATTR_TOKEN_TRUE);
        attrList.add(ATTR_CLASS_CERT);
        attrList.add(ATTR_X509_CERT_TYPE);
        attrList.add(new CK_ATTRIBUTE(257L, cert.getSubjectX500Principal().getEncoded()));
        attrList.add(new CK_ATTRIBUTE(129L, cert.getIssuerX500Principal().getEncoded()));
        attrList.add(new CK_ATTRIBUTE(130L, cert.getSerialNumber().toByteArray()));
        attrList.add(new CK_ATTRIBUTE(17L, cert.getEncoded()));
        if (alias != null) {
            attrList.add(new CK_ATTRIBUTE(3L, alias));
            attrList.add(new CK_ATTRIBUTE(258L, alias));
        } else {
            attrList.add(new CK_ATTRIBUTE(258L, this.getID(cert.getSubjectX500Principal().getName("CANONICAL"), cert)));
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_CreateObject(session.id(), attrList.toArray(new CK_ATTRIBUTE[attrList.size()]));
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    private void storeChain(String alias, X509Certificate[] chain) throws PKCS11Exception, CertificateException {
        this.storeCert(alias, chain[0]);
        this.storeCaCerts(chain, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCaCerts(X509Certificate[] chain, int start) throws PKCS11Exception, CertificateException {
        Session session = null;
        HashSet<X509Certificate> cacerts = new HashSet<X509Certificate>();
        try {
            long[] handles;
            session = this.token.getOpSession();
            CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT};
            for (long handle : handles = P11KeyStore.findObjects(session, attrs)) {
                cacerts.add(this.loadCert(session, handle));
            }
        }
        finally {
            this.token.releaseSession(session);
        }
        for (int i = start; i < chain.length; ++i) {
            if (!cacerts.contains(chain[i])) {
                this.storeCert(null, chain[i]);
                continue;
            }
            if (debug == null) continue;
            debug.println("ignoring duplicate CA cert for [" + chain[i].getSubjectX500Principal() + "]");
        }
    }

    private void storeSkey(String alias, KeyStore.SecretKeyEntry ske) throws PKCS11Exception, KeyStoreException {
        SecretKey skey = ske.getSecretKey();
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{ATTR_SKEY_TOKEN_TRUE, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(3L, alias)};
        try {
            P11SecretKeyFactory.convertKey(this.token, skey, null, attrs);
        }
        catch (InvalidKeyException ike) {
            throw new KeyStoreException("Cannot convert to PKCS11 keys", ike);
        }
        this.aliasMap.put(alias, new AliasInfo(alias));
        if (debug != null) {
            debug.println("storeSkey created token secret key for [" + alias + "]");
        }
    }

    private static CK_ATTRIBUTE[] addAttribute(CK_ATTRIBUTE[] attrs, CK_ATTRIBUTE attr) {
        int n = attrs.length;
        CK_ATTRIBUTE[] newAttrs = new CK_ATTRIBUTE[n + 1];
        System.arraycopy(attrs, 0, newAttrs, 0, n);
        newAttrs[n] = attr;
        return newAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storePkey(String alias, KeyStore.PrivateKeyEntry pke) throws PKCS11Exception, CertificateException, KeyStoreException {
        PrivateKey key = pke.getPrivateKey();
        CK_ATTRIBUTE[] attrs = null;
        if (key instanceof P11Key) {
            P11Key p11Key = (P11Key)((Object)key);
            if (p11Key.tokenObject && p11Key.token == this.token) {
                this.updateP11Pkey(alias, null, p11Key);
                this.storeChain(alias, (X509Certificate[])pke.getCertificateChain());
                return;
            }
        }
        boolean useNDB = this.token.config.getNssNetscapeDbWorkaround();
        PublicKey publicKey = pke.getCertificate().getPublicKey();
        if (key instanceof RSAPrivateKey) {
            X509Certificate cert = (X509Certificate)pke.getCertificate();
            attrs = this.getRsaPrivKeyAttrs(alias, (RSAPrivateKey)key, cert.getSubjectX500Principal());
        } else if (key instanceof DSAPrivateKey) {
            DSAPrivateKey dsaKey = (DSAPrivateKey)key;
            CK_ATTRIBUTE[] idAttrs = this.getIdAttributes(key, publicKey, false, useNDB);
            if (idAttrs[0] == null) {
                idAttrs[0] = new CK_ATTRIBUTE(258L, alias);
            }
            attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, 1L), idAttrs[0], new CK_ATTRIBUTE(304L, dsaKey.getParams().getP()), new CK_ATTRIBUTE(305L, dsaKey.getParams().getQ()), new CK_ATTRIBUTE(306L, dsaKey.getParams().getG()), new CK_ATTRIBUTE(17L, dsaKey.getX())};
            if (idAttrs[1] != null) {
                attrs = P11KeyStore.addAttribute(attrs, idAttrs[1]);
            }
            attrs = this.token.getAttributes("import", 3L, 1L, attrs);
            if (debug != null) {
                debug.println("storePkey created DSA template");
            }
        } else if (key instanceof DHPrivateKey) {
            DHPrivateKey dhKey = (DHPrivateKey)key;
            CK_ATTRIBUTE[] idAttrs = this.getIdAttributes(key, publicKey, false, useNDB);
            if (idAttrs[0] == null) {
                idAttrs[0] = new CK_ATTRIBUTE(258L, alias);
            }
            attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, 2L), idAttrs[0], new CK_ATTRIBUTE(304L, dhKey.getParams().getP()), new CK_ATTRIBUTE(306L, dhKey.getParams().getG()), new CK_ATTRIBUTE(17L, dhKey.getX())};
            if (idAttrs[1] != null) {
                attrs = P11KeyStore.addAttribute(attrs, idAttrs[1]);
            }
            attrs = this.token.getAttributes("import", 3L, 2L, attrs);
        } else if (key instanceof ECPrivateKey) {
            ECPrivateKey ecKey = (ECPrivateKey)key;
            CK_ATTRIBUTE[] idAttrs = this.getIdAttributes(key, publicKey, false, useNDB);
            if (idAttrs[0] == null) {
                idAttrs[0] = new CK_ATTRIBUTE(258L, alias);
            }
            byte[] encodedParams = ECUtil.encodeECParameterSpec(null, ecKey.getParams());
            attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, 3L), idAttrs[0], new CK_ATTRIBUTE(17L, ecKey.getS()), new CK_ATTRIBUTE(384L, encodedParams)};
            if (idAttrs[1] != null) {
                attrs = P11KeyStore.addAttribute(attrs, idAttrs[1]);
            }
            attrs = this.token.getAttributes("import", 3L, 3L, attrs);
            if (debug != null) {
                debug.println("storePkey created EC template");
            }
        } else {
            if (key instanceof P11Key) {
                P11Key p11Key = (P11Key)((Object)key);
                if (p11Key.token != this.token) {
                    throw new KeyStoreException("Cannot move sensitive keys across tokens");
                }
                CK_ATTRIBUTE netscapeDB = null;
                if (useNDB) {
                    CK_ATTRIBUTE[] idAttrs = this.getIdAttributes(key, publicKey, false, true);
                    netscapeDB = idAttrs[1];
                }
                this.updateP11Pkey(alias, netscapeDB, p11Key);
                this.storeChain(alias, (X509Certificate[])pke.getCertificateChain());
                return;
            }
            throw new KeyStoreException("unsupported key type: " + key);
        }
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_CreateObject(session.id(), attrs);
            if (debug != null) {
                debug.println("storePkey created token key for [" + alias + "]");
            }
        }
        finally {
            this.token.releaseSession(session);
        }
        this.storeChain(alias, (X509Certificate[])pke.getCertificateChain());
    }

    private CK_ATTRIBUTE[] getRsaPrivKeyAttrs(String alias, RSAPrivateKey key, X500Principal subject) throws PKCS11Exception {
        CK_ATTRIBUTE[] attrs = null;
        if (key instanceof RSAPrivateCrtKey) {
            if (debug != null) {
                debug.println("creating RSAPrivateCrtKey attrs");
            }
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(258L, alias), new CK_ATTRIBUTE(288L, rsaKey.getModulus()), new CK_ATTRIBUTE(291L, rsaKey.getPrivateExponent()), new CK_ATTRIBUTE(290L, rsaKey.getPublicExponent()), new CK_ATTRIBUTE(292L, rsaKey.getPrimeP()), new CK_ATTRIBUTE(293L, rsaKey.getPrimeQ()), new CK_ATTRIBUTE(294L, rsaKey.getPrimeExponentP()), new CK_ATTRIBUTE(295L, rsaKey.getPrimeExponentQ()), new CK_ATTRIBUTE(296L, rsaKey.getCrtCoefficient())};
            attrs = this.token.getAttributes("import", 3L, 0L, attrs);
        } else {
            if (debug != null) {
                debug.println("creating RSAPrivateKey attrs");
            }
            RSAPrivateKey rsaKey = key;
            attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY, ATTR_PRIVATE_TRUE, new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(258L, alias), new CK_ATTRIBUTE(288L, rsaKey.getModulus()), new CK_ATTRIBUTE(291L, rsaKey.getPrivateExponent())};
            attrs = this.token.getAttributes("import", 3L, 0L, attrs);
        }
        return attrs;
    }

    private CK_ATTRIBUTE[] getIdAttributes(PrivateKey privateKey, PublicKey publicKey, boolean id, boolean netscapeDb) {
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[2];
        if (!(id || netscapeDb)) {
            return attrs;
        }
        String alg = privateKey.getAlgorithm();
        if (alg.equals("RSA") && publicKey instanceof RSAPublicKey) {
            if (id) {
                BigInteger n = ((RSAPublicKey)publicKey).getModulus();
                attrs[0] = new CK_ATTRIBUTE(258L, P11Util.sha1(P11Util.getMagnitude(n)));
            }
        } else if (alg.equals("DSA") && publicKey instanceof DSAPublicKey) {
            BigInteger y = ((DSAPublicKey)publicKey).getY();
            if (id) {
                attrs[0] = new CK_ATTRIBUTE(258L, P11Util.sha1(P11Util.getMagnitude(y)));
            }
            if (netscapeDb) {
                attrs[1] = new CK_ATTRIBUTE(3584088832L, y);
            }
        } else if (alg.equals("DH") && publicKey instanceof DHPublicKey) {
            BigInteger y = ((DHPublicKey)publicKey).getY();
            if (id) {
                attrs[0] = new CK_ATTRIBUTE(258L, P11Util.sha1(P11Util.getMagnitude(y)));
            }
            if (netscapeDb) {
                attrs[1] = new CK_ATTRIBUTE(3584088832L, y);
            }
        } else if (alg.equals("EC") && publicKey instanceof ECPublicKey) {
            ECPublicKey ecPub = (ECPublicKey)publicKey;
            ECPoint point = ecPub.getW();
            ECParameterSpec params = ecPub.getParams();
            byte[] encodedPoint = ECUtil.encodePoint(point, params.getCurve());
            if (id) {
                attrs[0] = new CK_ATTRIBUTE(258L, P11Util.sha1(encodedPoint));
            }
            if (netscapeDb) {
                attrs[1] = new CK_ATTRIBUTE(3584088832L, encodedPoint);
            }
        } else {
            throw new RuntimeException("Unknown key algorithm " + alg);
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyCert(byte[] cka_id) throws PKCS11Exception, KeyStoreException {
        Session session = null;
        try {
            session = this.token.getOpSession();
            THandle h = this.getTokenObject(session, ATTR_CLASS_CERT, cka_id, null);
            if (h.type != ATTR_CLASS_CERT) {
                boolean bl = false;
                return bl;
            }
            this.token.p11.C_DestroyObject(session.id(), h.handle);
            if (debug != null) {
                debug.println("destroyCert destroyed cert with CKA_ID [" + P11KeyStore.getID(cka_id) + "]");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyChain(byte[] cka_id) throws PKCS11Exception, CertificateException, KeyStoreException {
        Session session = null;
        try {
            CK_ATTRIBUTE[] attrs;
            long[] ch;
            session = this.token.getOpSession();
            THandle h = this.getTokenObject(session, ATTR_CLASS_CERT, cka_id, null);
            if (h.type != ATTR_CLASS_CERT) {
                if (debug != null) {
                    debug.println("destroyChain could not find end entity cert with CKA_ID [0x" + Functions.toHexString(cka_id) + "]");
                }
                boolean bl = false;
                return bl;
            }
            X509Certificate endCert = this.loadCert(session, h.handle);
            this.token.p11.C_DestroyObject(session.id(), h.handle);
            if (debug != null) {
                debug.println("destroyChain destroyed end entity cert with CKA_ID [" + P11KeyStore.getID(cka_id) + "]");
            }
            X509Certificate next = endCert;
            while (!next.getSubjectX500Principal().equals(next.getIssuerX500Principal()) && (ch = P11KeyStore.findObjects(session, attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT, new CK_ATTRIBUTE(257L, next.getIssuerX500Principal().getEncoded())})) != null && ch.length != 0) {
                X509Certificate iCert;
                if (debug != null && ch.length > 1) {
                    debug.println("destroyChain found " + ch.length + " certificate entries for subject [" + next.getIssuerX500Principal() + "] in token - using first entry");
                }
                next = this.loadCert(session, ch[0]);
                attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT, new CK_ATTRIBUTE(129L, next.getSubjectX500Principal().getEncoded())};
                long[] issuers = P11KeyStore.findObjects(session, attrs);
                boolean destroyIt = false;
                if (issuers == null || issuers.length == 0) {
                    destroyIt = true;
                } else if (issuers.length == 1 && next.equals(iCert = this.loadCert(session, issuers[0]))) {
                    destroyIt = true;
                }
                if (destroyIt) {
                    this.token.p11.C_DestroyObject(session.id(), ch[0]);
                    if (debug == null) continue;
                    debug.println("destroyChain destroyed cert in chain with subject [" + next.getSubjectX500Principal() + "]");
                    continue;
                }
                if (debug == null) continue;
                debug.println("destroyChain did not destroy shared cert in chain with subject [" + next.getSubjectX500Principal() + "]");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroySkey(String alias) throws PKCS11Exception, KeyStoreException {
        Session session = null;
        try {
            session = this.token.getOpSession();
            THandle h = this.getTokenObject(session, ATTR_CLASS_SKEY, null, alias);
            if (h.type != ATTR_CLASS_SKEY) {
                if (debug != null) {
                    debug.println("destroySkey did not find secret key with CKA_LABEL [" + alias + "]");
                }
                boolean bl = false;
                return bl;
            }
            this.token.p11.C_DestroyObject(session.id(), h.handle);
            boolean bl = true;
            return bl;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyPkey(byte[] cka_id) throws PKCS11Exception, KeyStoreException {
        Session session = null;
        try {
            session = this.token.getOpSession();
            THandle h = this.getTokenObject(session, ATTR_CLASS_PKEY, cka_id, null);
            if (h.type != ATTR_CLASS_PKEY) {
                if (debug != null) {
                    debug.println("destroyPkey did not find private key with CKA_ID [" + P11KeyStore.getID(cka_id) + "]");
                }
                boolean bl = false;
                return bl;
            }
            this.token.p11.C_DestroyObject(session.id(), h.handle);
            boolean bl = true;
            return bl;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    private String getID(String alias, X509Certificate cert) {
        X500Principal issuer = cert.getIssuerX500Principal();
        BigInteger serialNum = cert.getSerialNumber();
        return alias + ALIAS_SEP + issuer.getName("CANONICAL") + ALIAS_SEP + serialNum.toString();
    }

    private static String getID(byte[] bytes) {
        boolean printable = true;
        for (int i = 0; i < bytes.length; ++i) {
            if (DerValue.isPrintableStringChar((char)bytes[i])) continue;
            printable = false;
            break;
        }
        if (!printable) {
            return "0x" + Functions.toHexString(bytes);
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return "0x" + Functions.toHexString(bytes);
        }
    }

    private THandle getTokenObject(Session session, CK_ATTRIBUTE type, byte[] cka_id, String cka_label) throws PKCS11Exception, KeyStoreException {
        CK_ATTRIBUTE[] attrs = type == ATTR_CLASS_SKEY ? new CK_ATTRIBUTE[]{ATTR_SKEY_TOKEN_TRUE, new CK_ATTRIBUTE(3L, cka_label), type} : new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, new CK_ATTRIBUTE(258L, cka_id), type};
        long[] h = P11KeyStore.findObjects(session, attrs);
        if (h.length == 0) {
            if (debug != null) {
                if (type == ATTR_CLASS_SKEY) {
                    debug.println("getTokenObject did not find secret key with CKA_LABEL [" + cka_label + "]");
                } else if (type == ATTR_CLASS_CERT) {
                    debug.println("getTokenObject did not find cert with CKA_ID [" + P11KeyStore.getID(cka_id) + "]");
                } else {
                    debug.println("getTokenObject did not find private key with CKA_ID [" + P11KeyStore.getID(cka_id) + "]");
                }
            }
        } else {
            if (h.length == 1) {
                return new THandle(h[0], type);
            }
            if (type == ATTR_CLASS_SKEY) {
                ArrayList<THandle> list = new ArrayList<THandle>(h.length);
                for (int i = 0; i < h.length; ++i) {
                    CK_ATTRIBUTE[] label = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                    this.token.p11.C_GetAttributeValue(session.id(), h[i], label);
                    if (label[0].pValue == null || !cka_label.equals(new String(label[0].getCharArray()))) continue;
                    list.add(new THandle(h[i], ATTR_CLASS_SKEY));
                }
                if (list.size() == 1) {
                    return (THandle)list.get(0);
                }
                throw new KeyStoreException("invalid KeyStore state: found " + list.size() + " secret keys sharing CKA_LABEL [" + cka_label + "]");
            }
            if (type == ATTR_CLASS_CERT) {
                throw new KeyStoreException("invalid KeyStore state: found " + h.length + " certificates sharing CKA_ID " + P11KeyStore.getID(cka_id));
            }
            throw new KeyStoreException("invalid KeyStore state: found " + h.length + " private keys sharing CKA_ID " + P11KeyStore.getID(cka_id));
        }
        return new THandle(-1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mapLabels() throws PKCS11Exception, CertificateException, KeyStoreException {
        CK_ATTRIBUTE[] trustedAttr = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(134L)};
        Session session = null;
        try {
            long[] handles;
            session = this.token.getOpSession();
            ArrayList<byte[]> pkeyIDs = new ArrayList<byte[]>();
            CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_PKEY};
            for (long handle : handles = P11KeyStore.findObjects(session, attrs)) {
                attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                this.token.p11.C_GetAttributeValue(session.id(), handle, attrs);
                if (attrs[0].pValue == null) continue;
                pkeyIDs.add(attrs[0].getByteArray());
            }
            HashMap<String, HashSet<AliasInfo>> certMap = new HashMap<String, HashSet<AliasInfo>>();
            attrs = new CK_ATTRIBUTE[]{ATTR_TOKEN_TRUE, ATTR_CLASS_CERT};
            for (long handle : handles = P11KeyStore.findObjects(session, attrs)) {
                HashSet<AliasInfo> infoSet;
                boolean cka_trusted;
                X509Certificate cert;
                byte[] cka_id;
                String cka_label;
                block19: {
                    block18: {
                        attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                        cka_label = null;
                        cka_id = null;
                        try {
                            this.token.p11.C_GetAttributeValue(session.id(), handle, attrs);
                            if (attrs[0].pValue != null) {
                                cka_label = new String(attrs[0].getCharArray());
                            }
                        }
                        catch (PKCS11Exception pe) {
                            if (pe.getErrorCode() == 18L) break block18;
                            throw pe;
                        }
                    }
                    attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                    this.token.p11.C_GetAttributeValue(session.id(), handle, attrs);
                    if (attrs[0].pValue == null) {
                        if (cka_label == null) {
                            continue;
                        }
                    } else {
                        if (cka_label == null) {
                            cka_label = P11KeyStore.getID(attrs[0].getByteArray());
                        }
                        cka_id = attrs[0].getByteArray();
                    }
                    cert = this.loadCert(session, handle);
                    cka_trusted = false;
                    if (CKA_TRUSTED_SUPPORTED) {
                        try {
                            this.token.p11.C_GetAttributeValue(session.id(), handle, trustedAttr);
                            cka_trusted = trustedAttr[0].getBoolean();
                        }
                        catch (PKCS11Exception pe) {
                            if (pe.getErrorCode() != 18L) break block19;
                            CKA_TRUSTED_SUPPORTED = false;
                            if (debug == null) break block19;
                            debug.println("CKA_TRUSTED attribute not supported");
                        }
                    }
                }
                if ((infoSet = certMap.get(cka_label)) == null) {
                    infoSet = new HashSet(2);
                    certMap.put(cka_label, infoSet);
                }
                infoSet.add(new AliasInfo(cka_label, cka_id, cka_trusted, cert));
            }
            HashMap<String, AliasInfo> sKeyMap = new HashMap<String, AliasInfo>();
            attrs = new CK_ATTRIBUTE[]{ATTR_SKEY_TOKEN_TRUE, ATTR_CLASS_SKEY};
            for (long handle : handles = P11KeyStore.findObjects(session, attrs)) {
                attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                this.token.p11.C_GetAttributeValue(session.id(), handle, attrs);
                if (attrs[0].pValue == null) continue;
                String cka_label = new String(attrs[0].getCharArray());
                if (sKeyMap.get(cka_label) == null) {
                    sKeyMap.put(cka_label, new AliasInfo(cka_label));
                    continue;
                }
                throw new KeyStoreException("invalid KeyStore state: found multiple secret keys sharing same CKA_LABEL [" + cka_label + "]");
            }
            ArrayList<AliasInfo> matchedCerts = this.mapPrivateKeys(pkeyIDs, certMap);
            boolean sharedLabel = this.mapCerts(matchedCerts, certMap);
            this.mapSecretKeys(sKeyMap);
            int n = sharedLabel ? 1 : 0;
            return n != 0;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    private ArrayList<AliasInfo> mapPrivateKeys(ArrayList<byte[]> pkeyIDs, HashMap<String, HashSet<AliasInfo>> certMap) throws PKCS11Exception, CertificateException {
        this.aliasMap = new HashMap();
        ArrayList<AliasInfo> matchedCerts = new ArrayList<AliasInfo>();
        for (byte[] pkeyID : pkeyIDs) {
            boolean foundMatch = false;
            Set<String> certLabels = certMap.keySet();
            for (String certLabel : certLabels) {
                HashSet<AliasInfo> infoSet = certMap.get(certLabel);
                for (AliasInfo aliasInfo : infoSet) {
                    if (!Arrays.equals(pkeyID, aliasInfo.id)) continue;
                    if (infoSet.size() == 1) {
                        aliasInfo.matched = true;
                        this.aliasMap.put(certLabel, aliasInfo);
                    } else {
                        aliasInfo.matched = true;
                        this.aliasMap.put(this.getID(certLabel, aliasInfo.cert), aliasInfo);
                    }
                    matchedCerts.add(aliasInfo);
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) continue;
                break;
            }
            if (foundMatch || debug == null) continue;
            debug.println("did not find match for private key with CKA_ID [" + P11KeyStore.getID(pkeyID) + "] (ignoring entry)");
        }
        return matchedCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mapCerts(ArrayList<AliasInfo> matchedCerts, HashMap<String, HashSet<AliasInfo>> certMap) throws PKCS11Exception, CertificateException {
        for (AliasInfo aliasInfo : matchedCerts) {
            Session session = null;
            try {
                session = this.token.getOpSession();
                AliasInfo.access$802(aliasInfo, this.loadChain(session, aliasInfo.cert));
            }
            finally {
                this.token.releaseSession(session);
            }
        }
        boolean sharedLabel = false;
        Set<String> certLabels = certMap.keySet();
        for (String certLabel : certLabels) {
            HashSet<AliasInfo> infoSet = certMap.get(certLabel);
            for (AliasInfo aliasInfo : infoSet) {
                if (aliasInfo.matched) {
                    aliasInfo.trusted = false;
                    continue;
                }
                if (!CKA_TRUSTED_SUPPORTED || !aliasInfo.trusted || !this.mapTrustedCert(certLabel, aliasInfo, infoSet)) continue;
                sharedLabel = true;
            }
        }
        return sharedLabel;
    }

    private boolean mapTrustedCert(String certLabel, AliasInfo aliasInfo, HashSet<AliasInfo> infoSet) {
        boolean sharedLabel = false;
        aliasInfo.type = P11KeyStore.ATTR_CLASS_CERT;
        aliasInfo.trusted = true;
        if (infoSet.size() == 1) {
            this.aliasMap.put(certLabel, aliasInfo);
        } else {
            sharedLabel = true;
            this.aliasMap.put(this.getID(certLabel, aliasInfo.cert), aliasInfo);
        }
        return sharedLabel;
    }

    private void mapSecretKeys(HashMap<String, AliasInfo> sKeyMap) throws KeyStoreException {
        for (String label : sKeyMap.keySet()) {
            if (!this.aliasMap.containsKey(label)) continue;
            throw new KeyStoreException("invalid KeyStore state: found secret key sharing CKA_LABEL [" + label + "] with another token object");
        }
        this.aliasMap.putAll(sKeyMap);
    }

    private void dumpTokenMap() {
        Set<String> aliases = this.aliasMap.keySet();
        System.out.println("Token Alias Map:");
        if (aliases.isEmpty()) {
            System.out.println("  [empty]");
        } else {
            for (String s : aliases) {
                System.out.println("  " + s + this.aliasMap.get(s));
            }
        }
    }

    private void checkWrite() throws KeyStoreException {
        if (this.writeDisabled) {
            throw new KeyStoreException("This PKCS11KeyStore does not support write capabilities");
        }
    }

    private static long[] findObjects(Session session, CK_ATTRIBUTE[] attrs) throws PKCS11Exception {
        long[] h;
        Token token = session.token;
        long[] handles = LONG0;
        token.p11.C_FindObjectsInit(session.id(), attrs);
        while ((h = token.p11.C_FindObjects(session.id(), 100L)).length != 0) {
            handles = P11Util.concat(handles, h);
        }
        token.p11.C_FindObjectsFinal(session.id());
        return handles;
    }

    static {
        ATTR_SKEY_TOKEN_TRUE = ATTR_TOKEN_TRUE = new CK_ATTRIBUTE(1L, true);
        ATTR_TRUSTED_TRUE = new CK_ATTRIBUTE(134L, true);
        ATTR_PRIVATE_TRUE = new CK_ATTRIBUTE(2L, true);
        debug = Debug.getInstance("pkcs11keystore");
        CKA_TRUSTED_SUPPORTED = true;
        LONG0 = new long[0];
    }

    private static class THandle {
        private final long handle;
        private final CK_ATTRIBUTE type;

        private THandle(long handle, CK_ATTRIBUTE type) {
            this.handle = handle;
            this.type = type;
        }
    }

    private static class PasswordCallbackHandler
    implements CallbackHandler {
        private char[] password;

        private PasswordCallbackHandler(char[] password) {
            if (password != null) {
                this.password = (char[])password.clone();
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (!(callbacks[0] instanceof PasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[0]);
            }
            PasswordCallback pc = (PasswordCallback)callbacks[0];
            pc.setPassword(this.password);
        }

        protected void finalize() throws Throwable {
            if (this.password != null) {
                Arrays.fill(this.password, ' ');
            }
            super.finalize();
        }
    }

    private static class AliasInfo {
        private CK_ATTRIBUTE type = null;
        private String label = null;
        private byte[] id = null;
        private boolean trusted = false;
        private X509Certificate cert = null;
        private X509Certificate[] chain = null;
        private boolean matched = false;

        public AliasInfo(String label) {
            this.type = ATTR_CLASS_SKEY;
            this.label = label;
        }

        public AliasInfo(String label, byte[] id, boolean trusted, X509Certificate cert) {
            this.type = ATTR_CLASS_PKEY;
            this.label = label;
            this.id = id;
            this.trusted = trusted;
            this.cert = cert;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.type == ATTR_CLASS_PKEY) {
                sb.append("\ttype=[private key]\n");
            } else if (this.type == ATTR_CLASS_SKEY) {
                sb.append("\ttype=[secret key]\n");
            } else if (this.type == ATTR_CLASS_CERT) {
                sb.append("\ttype=[trusted cert]\n");
            }
            sb.append("\tlabel=[" + this.label + "]\n");
            if (this.id == null) {
                sb.append("\tid=[null]\n");
            } else {
                sb.append("\tid=" + P11KeyStore.getID(this.id) + "\n");
            }
            sb.append("\ttrusted=[" + this.trusted + "]\n");
            sb.append("\tmatched=[" + this.matched + "]\n");
            if (this.cert == null) {
                sb.append("\tcert=[null]\n");
            } else {
                sb.append("\tcert=[\tsubject: " + this.cert.getSubjectX500Principal() + "\n\t\tissuer: " + this.cert.getIssuerX500Principal() + "\n\t\tserialNum: " + this.cert.getSerialNumber().toString() + "]");
            }
            return sb.toString();
        }

        static /* synthetic */ X509Certificate[] access$802(AliasInfo x0, X509Certificate[] x1) {
            x0.chain = x1;
            return x1;
        }
    }
}

