/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwhat.jnativehook;

import com.github.kwhat.jnativehook.GlobalScreen;
import com.github.kwhat.jnativehook.NativeLibraryLocator;
import com.github.kwhat.jnativehook.NativeSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class DefaultLibraryLocator
implements NativeLibraryLocator {
    private static final Logger log = Logger.getLogger(GlobalScreen.class.getPackage().getName());

    @Override
    public Iterator<File> getLibraries() {
        ArrayList<File> libraries = new ArrayList<File>(1);
        String libName = System.getProperty("jnativehook.lib.name", "JNativeHook");
        String basePackage = GlobalScreen.class.getPackage().getName().replace('.', '/');
        String libNativeArch = NativeSystem.getArchitecture().toString().toLowerCase();
        String libNativeName = System.mapLibraryName(libName).replaceAll("\\.jnilib$", "\\.dylib");
        String libResourcePath = "/" + basePackage + "/lib/" + NativeSystem.getFamily().toString().toLowerCase() + "/" + libNativeArch + "/" + libNativeName;
        URL classLocation = GlobalScreen.class.getProtectionDomain().getCodeSource().getLocation();
        File libFile = null;
        File classFile = new File(classLocation.getPath());
        if (classFile.isFile()) {
            String libPath = classFile.getParentFile().getPath();
            InputStream jarInputStream = GlobalScreen.class.getResourceAsStream(libResourcePath);
            if (jarInputStream == null) {
                throw new RuntimeException("Unable to extract the native library " + libResourcePath + "!\n");
            }
            libFile = new File(libPath, libNativeName);
            if (!libFile.exists()) {
                try {
                    int size;
                    FileOutputStream libOutputStream = new FileOutputStream(libFile);
                    byte[] buffer = new byte[4096];
                    while ((size = jarInputStream.read(buffer)) != -1) {
                        libOutputStream.write(buffer, 0, size);
                    }
                    jarInputStream.close();
                    libOutputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                log.fine("Extracted library: " + libFile.getPath() + ".\n");
            }
        } else {
            libFile = Paths.get(classFile.getAbsolutePath(), libResourcePath.toString()).toFile();
        }
        if (!libFile.exists()) {
            throw new RuntimeException("Unable to locate JNI library at " + libFile.getPath() + "!\n");
        }
        log.fine("Loading library: " + libFile.getPath() + ".\n");
        libraries.add(libFile);
        return libraries.iterator();
    }
}

