/*
 * Decompiled with CFR 0.152.
 */
package com.github.kyriosdata.exemplo;

import java.time.LocalDate;

public final class Calendario {
    public static final int MAIOR_DIA = 31;
    public static final int JANEIRO = 1;
    public static final int FEVEREIRO = 2;
    public static final int DEZEMBRO = 12;
    public static final int DIAS_DA_SEMANA = 7;
    public static final int CALENDARIO_GREGORIANO = 1753;
    public static String[] semana = new String[]{"segunda-feira", "ter\u00e7a-feira", "quarta-feira", "quinta-feira", "sexta-feira", "s\u00e1bado", "domingo"};

    protected Calendario() {
    }

    public static int diaDaSemana(int dia, int mes, int ano) {
        int m = mes;
        int a = ano;
        if (dia < 1 || dia > 31) {
            throw new IllegalArgumentException("dia inv\u00e1lido");
        }
        if (mes < 1 || mes > 12) {
            throw new IllegalArgumentException("m\u00eas inv\u00e1lido");
        }
        if (ano < 1753) {
            throw new IllegalArgumentException("ano inv\u00e1lido");
        }
        if (mes == 1 || mes == 2) {
            m += 12;
            --a;
        }
        int s = dia + 2 * m + 3 * (m + 1) / 5 + a + a / 4 - a / 100 + a / 400;
        return s % 7;
    }

    public static String diaDaSemanaParaHoje() {
        LocalDate hoje = LocalDate.now();
        int dia = hoje.getDayOfMonth();
        int mes = hoje.getMonthValue();
        int ano = hoje.getYear();
        int diaDaSemana = Calendario.diaDaSemana(dia, mes, ano);
        return String.format("Hoje \u00e9 %s\n", semana[diaDaSemana]);
    }
}

