/*
 * Decompiled with CFR 0.152.
 */
package test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.net.InetSocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import kcp.ChannelConfig;
import kcp.KcpClient;
import kcp.KcpListener;
import kcp.Ukcp;

public class KcpDisconnectExampleClient
implements KcpListener {
    private static final AtomicInteger id = new AtomicInteger();

    public static void main(String[] args) {
        final ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(1024);
        channelConfig.setRcvwnd(1024);
        channelConfig.setMtu(1400);
        channelConfig.setConv(55);
        channelConfig.setUseConvChannel(true);
        final KcpClient kcpClient = new KcpClient();
        kcpClient.init(channelConfig);
        final KcpDisconnectExampleClient kcpClientRttExample = new KcpDisconnectExampleClient();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    try {
                        channelConfig.setConv(id.incrementAndGet());
                        kcpClient.connect(new InetSocketAddress("127.0.0.1", 10031), channelConfig, (KcpListener)kcpClientRttExample);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, 1000L, 1000L);
    }

    public void onConnected(Ukcp ukcp) {
        for (int i = 0; i < 100; ++i) {
            ByteBuf byteBuf = UnpooledByteBufAllocator.DEFAULT.buffer(1024);
            byteBuf.writeInt(i);
            byte[] bytes = new byte[1020];
            byteBuf.writeBytes(bytes);
            ukcp.write(byteBuf);
            byteBuf.release();
        }
    }

    public void handleReceive(ByteBuf byteBuf, Ukcp ukcp) {
        if (byteBuf.getInt(0) == 99) {
            ukcp.close();
        }
    }

    public void handleException(Throwable ex, Ukcp kcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp kcp) {
        System.out.println("\u8fde\u63a5\u65ad\u5f00\u4e86");
    }
}

