/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.backblaze.erasure.fec.Snmp;
import io.netty.buffer.ByteBuf;
import io.netty.channel.DefaultEventLoop;
import kcp.ChannelConfig;
import kcp.KcpListener;
import kcp.KcpServer;
import kcp.Ukcp;

public class KcpPingPongExampleServer
implements KcpListener {
    static DefaultEventLoop logicThread = new DefaultEventLoop();
    int i = 0;
    long start = System.currentTimeMillis();

    public static void main(String[] args) {
        KcpPingPongExampleServer kcpRttExampleServer = new KcpPingPongExampleServer();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(1024);
        channelConfig.setRcvwnd(1024);
        channelConfig.setMtu(1400);
        channelConfig.setAckNoDelay(false);
        channelConfig.setTimeoutMillis(10000L);
        KcpServer kcpServer = new KcpServer();
        kcpServer.init((KcpListener)kcpRttExampleServer, channelConfig, new int[]{10001});
    }

    public void onConnected(Ukcp ukcp) {
        System.out.println("\u6709\u8fde\u63a5\u8fdb\u6765" + Thread.currentThread().getName() + ukcp.user().getRemoteAddress());
    }

    public void handleReceive(ByteBuf buf, Ukcp kcp) {
        ByteBuf newBuf = buf.retainedDuplicate();
        logicThread.execute(() -> {
            try {
                ++this.i;
                long now = System.currentTimeMillis();
                if (now - this.start > 1000L) {
                    System.out.println("\u6536\u5230\u6d88\u606f time: " + (now - this.start) + "  message :" + this.i);
                    this.start = now;
                    this.i = 0;
                }
                kcp.write(newBuf);
                newBuf.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void handleException(Throwable ex, Ukcp kcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp kcp) {
        System.out.println(Snmp.snmp.toString());
        Snmp.snmp = new Snmp();
        System.out.println("\u8fde\u63a5\u65ad\u5f00\u4e86");
    }
}

