/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.backblaze.erasure.fec.Snmp;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.net.InetSocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import kcp.ChannelConfig;
import kcp.KcpClient;
import kcp.KcpListener;
import kcp.Ukcp;

public class KcpReconnectExampleClient
implements KcpListener {
    int j = 0;

    public static void main(String[] args) {
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(1024);
        channelConfig.setRcvwnd(1024);
        channelConfig.setMtu(1400);
        channelConfig.setConv(55);
        channelConfig.setUseConvChannel(true);
        final KcpClient kcpClient = new KcpClient();
        kcpClient.init(channelConfig);
        KcpReconnectExampleClient kcpClientRttExample = new KcpReconnectExampleClient();
        final Ukcp ukcp = kcpClient.connect(new InetSocketAddress("127.0.0.1", 10021), channelConfig, (KcpListener)kcpClientRttExample);
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                kcpClient.reconnect(ukcp);
            }
        }, 1000L, 1000L);
    }

    public void onConnected(Ukcp ukcp) {
        for (int i = 0; i < 100; ++i) {
            ByteBuf byteBuf = UnpooledByteBufAllocator.DEFAULT.buffer(1024);
            byteBuf.writeInt(i++);
            byte[] bytes = new byte[1020];
            byteBuf.writeBytes(bytes);
            ukcp.write(byteBuf);
            byteBuf.release();
        }
    }

    public void handleReceive(ByteBuf byteBuf, Ukcp ukcp) {
        ukcp.write(byteBuf);
        int id = byteBuf.getInt(0);
        ++this.j;
        if (this.j % 100000 == 0) {
            System.out.println(Snmp.snmp.toString());
            System.out.println("\u6536\u5230\u4e86 \u8fd4\u56de\u56de\u53bb" + this.j);
        }
    }

    public void handleException(Throwable ex, Ukcp kcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp kcp) {
        System.out.println("\u8fde\u63a5\u65ad\u5f00\u4e86");
    }
}

