/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.backblaze.erasure.FecAdapt;
import com.backblaze.erasure.fec.Snmp;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kcp.ChannelConfig;
import kcp.KcpClient;
import kcp.KcpListener;
import kcp.Ukcp;

public class KcpRttExampleClient
implements KcpListener {
    private final ByteBuf data = Unpooled.buffer((int)200);
    private int[] rtts;
    private volatile int count;
    private ScheduledExecutorService scheduleSrv;
    private ScheduledFuture<?> future = null;
    private final long startTime;

    public KcpRttExampleClient() {
        int i;
        for (i = 0; i < this.data.capacity(); ++i) {
            this.data.writeByte((int)((byte)i));
        }
        this.rtts = new int[300];
        for (i = 0; i < this.rtts.length; ++i) {
            this.rtts[i] = -1;
        }
        this.startTime = System.currentTimeMillis();
        this.scheduleSrv = new ScheduledThreadPoolExecutor(1);
    }

    public static void main(String[] args) {
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(512);
        channelConfig.setRcvwnd(512);
        channelConfig.setMtu(512);
        channelConfig.setAckNoDelay(true);
        channelConfig.setConv(55);
        channelConfig.setFecAdapt(new FecAdapt(3, 1));
        channelConfig.setCrc32Check(true);
        KcpClient kcpClient = new KcpClient();
        kcpClient.init(channelConfig);
        KcpRttExampleClient kcpClientRttExample = new KcpRttExampleClient();
        kcpClient.connect(new InetSocketAddress("127.0.0.1", 20003), channelConfig, (KcpListener)kcpClientRttExample);
    }

    public void onConnected(Ukcp ukcp) {
        this.future = this.scheduleSrv.scheduleWithFixedDelay(() -> {
            ByteBuf byteBuf = this.rttMsg(++this.count);
            ukcp.write(byteBuf);
            byteBuf.release();
            if (this.count >= this.rtts.length) {
                this.future.cancel(true);
                byteBuf = this.rttMsg(-1);
                ukcp.write(byteBuf);
                byteBuf.release();
            }
        }, 20L, 20L, TimeUnit.MILLISECONDS);
    }

    public void handleReceive(ByteBuf byteBuf, final Ukcp ukcp) {
        short curCount = byteBuf.readShort();
        if (curCount == -1) {
            this.scheduleSrv.schedule(new Runnable(){

                @Override
                public void run() {
                    int sum = 0;
                    for (int rtt : KcpRttExampleClient.this.rtts) {
                        sum += rtt;
                    }
                    System.out.println("average: " + sum / KcpRttExampleClient.this.rtts.length);
                    System.out.println(Snmp.snmp.toString());
                    ukcp.close();
                    System.exit(0);
                }
            }, 3L, TimeUnit.SECONDS);
        } else {
            int idx = curCount - 1;
            long time = byteBuf.readInt();
            if (this.rtts[idx] != -1) {
                System.out.println("???");
            }
            this.rtts[idx] = (int)(System.currentTimeMillis() - this.startTime - time);
            System.out.println("rtt : " + curCount + "  " + this.rtts[idx]);
        }
    }

    public void handleException(Throwable ex, Ukcp kcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp kcp) {
        this.scheduleSrv.shutdown();
        try {
            this.scheduleSrv.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int sum = 0;
        int max = 0;
        for (int rtt : this.rtts) {
            if (rtt > max) {
                max = rtt;
            }
            sum += rtt;
        }
        System.out.println("average: " + sum / this.rtts.length + " max:" + max);
        System.out.println(Snmp.snmp.toString());
        System.out.println("lost percent: " + Snmp.snmp.RetransSegs.doubleValue() / Snmp.snmp.OutPkts.doubleValue());
    }

    public ByteBuf rttMsg(int count) {
        ByteBuf buf = Unpooled.buffer((int)10);
        buf.writeShort(count);
        buf.writeInt((int)(System.currentTimeMillis() - this.startTime));
        int dataLen = this.data.readableBytes();
        buf.writeShort(dataLen);
        buf.writeBytes(this.data, this.data.readerIndex(), dataLen);
        return buf;
    }
}

