/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.backblaze.erasure.FecAdapt;
import com.backblaze.erasure.fec.Snmp;
import io.netty.buffer.ByteBuf;
import kcp.ChannelConfig;
import kcp.KcpListener;
import kcp.KcpServer;
import kcp.Ukcp;

public class KcpRttExampleServer
implements KcpListener {
    public static void main(String[] args) {
        KcpRttExampleServer kcpRttExampleServer = new KcpRttExampleServer();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(512);
        channelConfig.setRcvwnd(512);
        channelConfig.setMtu(512);
        channelConfig.setFecAdapt(new FecAdapt(3, 1));
        channelConfig.setAckNoDelay(true);
        channelConfig.setTimeoutMillis(10000L);
        channelConfig.setUseConvChannel(true);
        channelConfig.setCrc32Check(true);
        KcpServer kcpServer = new KcpServer();
        kcpServer.init((KcpListener)kcpRttExampleServer, channelConfig, new int[]{20003});
    }

    public void onConnected(Ukcp ukcp) {
        System.out.println("\u6709\u8fde\u63a5\u8fdb\u6765" + Thread.currentThread().getName() + ukcp.user().getRemoteAddress());
    }

    public void handleReceive(ByteBuf buf, Ukcp kcp) {
        short curCount = buf.getShort(buf.readerIndex());
        System.out.println(Thread.currentThread().getName() + "  \u6536\u5230\u6d88\u606f " + curCount);
        kcp.write(buf);
        if (curCount == -1) {
            kcp.close();
        }
    }

    public void handleException(Throwable ex, Ukcp kcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp kcp) {
        System.out.println(Snmp.snmp.toString());
        Snmp.snmp = new Snmp();
    }
}

