/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.backblaze.erasure.fec.Snmp;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetSocketAddress;
import kcp.ChannelConfig;
import kcp.KcpClient;
import kcp.KcpListener;
import kcp.Ukcp;
import threadPool.IMessageExecutorPool;
import threadPool.disruptor.DisruptorExecutorPool;

public class SpeedExampleClient
implements KcpListener {
    private static final int messageSize = 2048;
    private long start = System.currentTimeMillis();

    public static void main(String[] args) {
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 30, 2, true);
        channelConfig.setSndwnd(2048);
        channelConfig.setRcvwnd(2048);
        channelConfig.setMtu(1400);
        channelConfig.setAckNoDelay(true);
        channelConfig.setConv(55);
        channelConfig.setiMessageExecutorPool((IMessageExecutorPool)new DisruptorExecutorPool(Runtime.getRuntime().availableProcessors() / 2));
        channelConfig.setCrc32Check(false);
        channelConfig.setWriteBufferSize(channelConfig.getMtu() * 300000);
        KcpClient kcpClient = new KcpClient();
        kcpClient.init(channelConfig);
        SpeedExampleClient speedExampleClient = new SpeedExampleClient();
        kcpClient.connect(new InetSocketAddress("127.0.0.1", 20004), channelConfig, (KcpListener)speedExampleClient);
    }

    public void onConnected(Ukcp ukcp) {
        new Thread(() -> {
            while (true) {
                long now;
                if ((now = System.currentTimeMillis()) - this.start >= 1000L) {
                    System.out.println("\u8017\u65f6 :" + (now - this.start) + " \u53d1\u9001\u6570\u636e: " + Snmp.snmp.OutBytes.doubleValue() / 1024.0 / 1024.0 + "MB \u6709\u6548\u6570\u636e: " + Snmp.snmp.BytesSent.doubleValue() / 1024.0 / 1024.0 + " MB");
                    System.out.println(Snmp.snmp.toString());
                    Snmp.snmp = new Snmp();
                    this.start = now;
                }
                ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(2048);
                byteBuf.writeBytes(new byte[2048]);
                if (!ukcp.write(byteBuf)) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                byteBuf.release();
            }
        }).start();
    }

    public void handleReceive(ByteBuf byteBuf, Ukcp ukcp) {
    }

    public void handleException(Throwable ex, Ukcp kcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp kcp) {
    }
}

