/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.backblaze.erasure.fec.Snmp;
import io.netty.buffer.ByteBuf;
import kcp.ChannelConfig;
import kcp.KcpListener;
import kcp.KcpServer;
import kcp.Ukcp;
import threadPool.IMessageExecutorPool;
import threadPool.disruptor.DisruptorExecutorPool;

public class SpeedExampleServer
implements KcpListener {
    long start = System.currentTimeMillis();
    long inBytes = 0L;

    public static void main(String[] args) {
        SpeedExampleServer speedExampleServer = new SpeedExampleServer();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 30, 2, true);
        channelConfig.setSndwnd(2048);
        channelConfig.setRcvwnd(2048);
        channelConfig.setMtu(1400);
        channelConfig.setiMessageExecutorPool((IMessageExecutorPool)new DisruptorExecutorPool(Runtime.getRuntime().availableProcessors() / 2));
        channelConfig.setAckNoDelay(true);
        channelConfig.setTimeoutMillis(5000L);
        channelConfig.setUseConvChannel(true);
        channelConfig.setCrc32Check(false);
        KcpServer kcpServer = new KcpServer();
        kcpServer.init((KcpListener)speedExampleServer, channelConfig, new int[]{20004});
    }

    public void onConnected(Ukcp ukcp) {
        System.out.println("\u6709\u8fde\u63a5\u8fdb\u6765" + Thread.currentThread().getName() + ukcp.user().getRemoteAddress());
    }

    public void handleReceive(ByteBuf buf, Ukcp kcp) {
        this.inBytes += (long)buf.readableBytes();
        long now = System.currentTimeMillis();
        if (now - this.start >= 1000L) {
            System.out.println("\u8017\u65f6 :" + (now - this.start) + " \u63a5\u6536\u6570\u636e: " + Snmp.snmp.InBytes.doubleValue() / 1024.0 / 1024.0 + "MB \u6709\u6548\u6570\u636e: " + (double)this.inBytes / 1024.0 / 1024.0 + " MB");
            System.out.println(Snmp.snmp.BytesReceived.doubleValue() / 1024.0 / 1024.0);
            System.out.println(Snmp.snmp.toString());
            this.inBytes = 0L;
            Snmp.snmp = new Snmp();
            this.start = now;
        }
    }

    public void handleException(Throwable ex, Ukcp kcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp kcp) {
        System.out.println(Snmp.snmp.toString());
        Snmp.snmp = new Snmp();
    }
}

