/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.backblaze.erasure.fec.Snmp;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetSocketAddress;
import kcp.ChannelConfig;
import kcp.KcpClient;
import kcp.KcpListener;
import kcp.Ukcp;
import test.TimerThreadPool;

public class KcpLockStepSynchronizationClient
implements KcpListener {
    public static void main(String[] args) {
        String ip = "49.232.119.183";
        if (args.length > 0) {
            ip = args[0];
        }
        int number = 1;
        if (args.length > 1) {
            number = Integer.parseInt(args[1]);
        }
        KcpClient kcpClient = new KcpClient();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(300);
        channelConfig.setRcvwnd(300);
        channelConfig.setMtu(500);
        channelConfig.setAckNoDelay(false);
        channelConfig.setCrc32Check(true);
        channelConfig.setTimeoutMillis(10000L);
        kcpClient.init(channelConfig);
        KcpLockStepSynchronizationClient lockStepSynchronizationClient = new KcpLockStepSynchronizationClient();
        for (int i = 0; i < number; ++i) {
            kcpClient.connect(new InetSocketAddress(ip, 10009), channelConfig, (KcpListener)lockStepSynchronizationClient);
        }
        TimerThreadPool.scheduleWithFixedDelay(() -> {
            long inSegs = Snmp.snmp.InSegs.longValue();
            if (inSegs == 0L) {
                inSegs = 1L;
            }
            System.out.println("\u6bcf\u79d2\u6536\u5305" + (double)Snmp.snmp.InBytes.longValue() / 1024.0 / 1024.0 * 8.0 + " M \u4e22\u5305\u7387 " + (double)Snmp.snmp.LostSegs.longValue() / (double)inSegs);
            System.out.println("\u6bcf\u79d2\u53d1\u5305" + (double)Snmp.snmp.OutBytes.longValue() / 1024.0 / 1024.0 * 8.0 + " M");
            System.out.println(Snmp.snmp.toString());
            System.out.println();
            Snmp.snmp = new Snmp();
        }, 1000L);
    }

    public void onConnected(Ukcp ukcp) {
        TimerThreadPool.scheduleWithFixedDelay(() -> {
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.directBuffer(20);
            byteBuf.writeBytes(new byte[20]);
            ukcp.write(byteBuf);
            byteBuf.release();
        }, 50L);
    }

    public void handleReceive(ByteBuf byteBuf, Ukcp ukcp) {
    }

    public void handleException(Throwable ex, Ukcp ukcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp ukcp) {
        System.out.println("\u8fde\u63a5\u65ad\u5f00\u4e86" + ukcp.user().getRemoteAddress());
    }
}

