/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.backblaze.erasure.fec.Snmp;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import kcp.ChannelConfig;
import kcp.KcpListener;
import kcp.KcpServer;
import kcp.Ukcp;
import test.IWriter;
import test.Player;
import test.Room;
import test.RoomManager;
import test.TimerThreadPool;

public class KcpLockStepSynchronizationServer
implements KcpListener {
    private RoomManager roomManager;

    public static void main(String[] args) {
        KcpLockStepSynchronizationServer kcpLockStepSynchronizationServer = new KcpLockStepSynchronizationServer();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(300);
        channelConfig.setRcvwnd(300);
        channelConfig.setMtu(500);
        channelConfig.setAckNoDelay(false);
        channelConfig.setCrc32Check(true);
        channelConfig.setTimeoutMillis(10000L);
        KcpServer kcpServer = new KcpServer();
        kcpServer.init((KcpListener)kcpLockStepSynchronizationServer, channelConfig, new int[]{10009});
        kcpLockStepSynchronizationServer.roomManager = new RoomManager();
        TimerThreadPool.scheduleWithFixedDelay(() -> {
            try {
                long inSegs = Snmp.snmp.InSegs.longValue();
                if (inSegs == 0L) {
                    inSegs = 1L;
                }
                System.out.println("\u6bcf\u79d2\u6536\u5305" + (double)Snmp.snmp.InBytes.longValue() / 1024.0 / 1024.0 * 8.0 + " M \u4e22\u5305\u7387 " + (double)Snmp.snmp.LostSegs.longValue() / (double)inSegs);
                System.out.println("\u6bcf\u79d2\u53d1\u5305" + (double)Snmp.snmp.OutBytes.longValue() / 1024.0 / 1024.0 * 8.0 + " M");
                System.out.println(Snmp.snmp.toString());
                System.out.println();
                Snmp.snmp = new Snmp();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 1000L);
    }

    public void onConnected(final Ukcp ukcp) {
        System.out.println("\u6709\u8fde\u63a5\u8fdb\u6765" + ukcp.user());
        Player player = new Player(new IWriter(){

            @Override
            public void write(ByteBuf byteBuf) {
                ukcp.write(byteBuf);
            }
        });
        ukcp.user().setCache((Object)player);
        this.roomManager.joinRoom(player);
    }

    public void handleReceive(ByteBuf byteBuf, Ukcp ukcp) {
        Player player = (Player)ukcp.user().getCache();
        Room room = this.roomManager.getRoom(player.getId());
        ByteBuf byteBufAllocator = ByteBufAllocator.DEFAULT.directBuffer(20);
        byteBuf.readBytes(byteBufAllocator);
        byteBufAllocator.readerIndex(0);
        byteBufAllocator.writerIndex(20);
        room.getiMessageExecutor().execute(() -> player.getMessages().add(byteBufAllocator));
    }

    public void handleException(Throwable ex, Ukcp ukcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp ukcp) {
        Player player = (Player)ukcp.user().getCache();
        this.roomManager.remove(player.getId());
        System.out.println("\u8fde\u63a5\u65ad\u5f00\u4e86" + ukcp.user().getRemoteAddress());
    }
}

