/*
 * Decompiled with CFR 0.152.
 */
package test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import test.Player;
import threadPool.IMessageExecutor;
import threadPool.ITask;

public class Room
implements Runnable,
ITask {
    Map<Integer, Player> players = new ConcurrentHashMap<Integer, Player>();
    private IMessageExecutor iMessageExecutor;
    private volatile boolean executed;

    public Map<Integer, Player> getPlayers() {
        return this.players;
    }

    public void setPlayers(Map<Integer, Player> players) {
        this.players = players;
    }

    public IMessageExecutor getiMessageExecutor() {
        return this.iMessageExecutor;
    }

    public void setiMessageExecutor(IMessageExecutor iMessageExecutor) {
        this.iMessageExecutor = iMessageExecutor;
    }

    public void execute() {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.directBuffer(2048);
        boolean needSend = false;
        for (Player player : this.players.values()) {
            for (ByteBuf message : player.getMessages()) {
                needSend = true;
                byteBuf.writeBytes(message);
            }
            player.getMessages().clear();
        }
        if (!needSend) {
            byteBuf.release();
            return;
        }
        for (Player player : this.players.values()) {
            ByteBuf b = byteBuf.retain();
            player.write(b);
        }
        byteBuf.release();
    }

    @Override
    public void run() {
        this.iMessageExecutor.execute((ITask)this);
    }
}

