/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import test.Player;
import test.Room;
import test.TimerThreadPool;
import threadPool.disruptor.DisruptorExecutorPool;

public class RoomManager {
    Map<Integer, Room> playerRooms = new ConcurrentHashMap<Integer, Room>();
    DisruptorExecutorPool disruptorExecutorPool = new DisruptorExecutorPool(1);

    public void remove(Integer playerId) {
        this.playerRooms.remove(playerId);
    }

    public Room getRoom(Integer playerId) {
        return this.playerRooms.get(playerId);
    }

    public synchronized void joinRoom(Player player) {
        Room room = null;
        for (Room value : this.playerRooms.values()) {
            if (value.getPlayers().size() == 8) continue;
            if (room == null) {
                room = value;
                continue;
            }
            if (room.getPlayers().size() <= value.getPlayers().size()) continue;
            room = value;
        }
        if (room == null) {
            room = new Room();
            room.setiMessageExecutor(this.disruptorExecutorPool.getIMessageExecutor());
            TimerThreadPool.scheduleWithFixedDelay(room, 50L);
        }
        this.playerRooms.put(player.getId(), room);
        room.getPlayers().put(player.getId(), player);
    }
}

