/*
 * Decompiled with CFR 0.152.
 */
package test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import test.TimerThreadPool;
import test.tcp.NetConnector;
import test.tcp.TcpChannelInitializer;

@ChannelHandler.Sharable
public class TcpLockStepSynchronizationClient
extends SimpleChannelInboundHandler<ByteBuf> {
    public static void main(String[] args) {
        TcpLockStepSynchronizationClient tcpLockStepSynchronizationClient = new TcpLockStepSynchronizationClient();
        String ip = "127.0.0.1";
        if (args.length > 0) {
            ip = args[0];
        }
        int number = 100;
        if (args.length > 1) {
            number = Integer.parseInt(args[1]);
        }
        NetConnector netConnector = new NetConnector(new TcpChannelInitializer(tcpLockStepSynchronizationClient));
        try {
            for (int i = 0; i < number; ++i) {
                netConnector.connect(new InetSocketAddress(ip, 11009));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        TimerThreadPool.scheduleWithFixedDelay(() -> {
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.directBuffer(20);
            byteBuf.writeBytes(new byte[20]);
            ctx.channel().writeAndFlush((Object)byteBuf);
        }, 50L);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        System.out.println("\u8fde\u63a5\u65ad\u5f00\u4e86" + ctx.channel().remoteAddress());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
    }
}

