/*
 * Decompiled with CFR 0.152.
 */
package test;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import test.Player;
import test.Room;
import test.RoomManager;
import test.tcp.NetAcceptor;
import test.tcp.TcpChannelInitializer;

@ChannelHandler.Sharable
public class TcpLockStepSynchronizationServer
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final RoomManager roomManager = new RoomManager();
    public static final AttributeKey<Player> playerAttributeKey = AttributeKey.newInstance((String)"player");

    public static void main(String[] args) {
        TcpLockStepSynchronizationServer tcpLockStepSynchronizationServer = new TcpLockStepSynchronizationServer();
        TcpChannelInitializer tcpChannelInitializer = new TcpChannelInitializer(tcpLockStepSynchronizationServer);
        new NetAcceptor(tcpChannelInitializer, new InetSocketAddress(11009));
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        System.out.println("\u6709\u8fde\u63a5\u8fdb\u6765" + ctx.channel().remoteAddress());
        Player player = new Player(byteBuf -> ctx.channel().writeAndFlush((Object)byteBuf));
        Attribute playerAttribute = ctx.channel().attr(playerAttributeKey);
        playerAttribute.set((Object)player);
        roomManager.joinRoom(player);
    }

    private Player getPlayer(ChannelHandlerContext ctx) {
        Attribute playerAttribute = ctx.channel().attr(playerAttributeKey);
        return (Player)playerAttribute.get();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Player player = this.getPlayer(ctx);
        roomManager.remove(player.getId());
        System.out.println("\u8fde\u63a5\u65ad\u5f00\u4e86" + ctx.channel().remoteAddress());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
        Player player = this.getPlayer(channelHandlerContext);
        Room room = roomManager.getRoom(player.getId());
        ByteBuf byteBuf1 = ByteBufAllocator.DEFAULT.directBuffer(20);
        byteBuf.readBytes(byteBuf1);
        byteBuf1.readerIndex(0);
        byteBuf1.writerIndex(20);
        room.getiMessageExecutor().execute(() -> player.getMessages().add(byteBuf1));
    }
}

