/*
 * Decompiled with CFR 0.152.
 */
package test.TpsTest;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetSocketAddress;
import java.util.Map;
import kcp.ChannelConfig;
import kcp.KcpClient;
import kcp.KcpListener;
import kcp.Ukcp;
import test.TimerThreadPool;
import test.TpsTest.TpsChannelClientCache;
import test.TpsTest.TpsCounter;

public class KcpGameTestClient
implements KcpListener {
    TpsCounter tpsCounter = new TpsCounter();

    public static void main(String[] args) {
        String ip = "127.0.0.1";
        if (args.length > 0) {
            ip = args[0];
        }
        int number = 100;
        if (args.length > 1) {
            number = Integer.parseInt(args[1]);
        }
        KcpClient kcpClient = new KcpClient();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(300);
        channelConfig.setRcvwnd(300);
        channelConfig.setMtu(500);
        channelConfig.setAckNoDelay(false);
        channelConfig.setCrc32Check(true);
        channelConfig.setTimeoutMillis(10000L);
        kcpClient.init(channelConfig);
        KcpGameTestClient kcpGameTestClient = new KcpGameTestClient();
        for (int i = 0; i < number; ++i) {
            kcpClient.connect(new InetSocketAddress(ip, 10019), channelConfig, (KcpListener)kcpGameTestClient);
        }
        TimerThreadPool.scheduleWithFixedDelay(() -> kcpGameTestClient.tpsCounter.count(), 5000L);
    }

    public void onConnected(Ukcp ukcp) {
        TpsChannelClientCache tpsChannelCache = new TpsChannelClientCache();
        ukcp.user().setCache((Object)tpsChannelCache);
        TimerThreadPool.scheduleWithFixedDelay(() -> {
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.directBuffer(4);
            int packetId = tpsChannelCache.getIndex();
            byteBuf.writeInt(++packetId);
            byteBuf.writeBytes(new byte[40]);
            tpsChannelCache.setIndex(packetId);
            tpsChannelCache.getPacketTime().put(packetId, System.currentTimeMillis());
            this.tpsCounter.add(0);
            ukcp.write(byteBuf);
            byteBuf.release();
        }, 100L);
    }

    public void handleReceive(ByteBuf byteBuf, Ukcp ukcp) {
        int size = byteBuf.readShort();
        for (int i = 0; i < size; ++i) {
            int packetId = byteBuf.readInt();
            TpsChannelClientCache tpsChannelCache = (TpsChannelClientCache)ukcp.user().getCache();
            Map<Integer, Long> packetTime = tpsChannelCache.getPacketTime();
            this.tpsCounter.set(0, (int)(System.currentTimeMillis() - packetTime.remove(packetId)));
        }
    }

    public void handleException(Throwable ex, Ukcp ukcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp ukcp) {
        System.out.println("\u8fde\u63a5\u65ad\u5f00\u4e86" + ukcp.user().getRemoteAddress());
    }
}

