/*
 * Decompiled with CFR 0.152.
 */
package test.TpsTest;

import com.backblaze.erasure.fec.Snmp;
import io.netty.buffer.ByteBuf;
import kcp.ChannelConfig;
import kcp.KcpListener;
import kcp.KcpServer;
import kcp.Ukcp;
import test.TimerThreadPool;
import test.TpsTest.GameTestRoomManager;
import test.TpsTest.TestRoom;
import test.TpsTest.TpsChannelServerCache;

public class KcpGameTestServer
implements KcpListener {
    private GameTestRoomManager roomManager;

    public static void main(String[] args) {
        KcpGameTestServer kcpGameTestServer = new KcpGameTestServer();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(300);
        channelConfig.setRcvwnd(300);
        channelConfig.setMtu(500);
        channelConfig.setAckNoDelay(false);
        channelConfig.setCrc32Check(true);
        channelConfig.setTimeoutMillis(10000L);
        KcpServer kcpServer = new KcpServer();
        kcpServer.init((KcpListener)kcpGameTestServer, channelConfig, new int[]{10019});
        kcpGameTestServer.roomManager = new GameTestRoomManager();
        TimerThreadPool.scheduleWithFixedDelay(() -> {
            try {
                long inSegs = Snmp.snmp.InSegs.longValue();
                if (inSegs == 0L) {
                    inSegs = 1L;
                }
                System.out.println("\u6bcf\u79d2\u6536\u5305" + (double)Snmp.snmp.InBytes.longValue() / 1024.0 / 1024.0 * 8.0 + " M \u4e22\u5305\u7387 " + (double)Snmp.snmp.LostSegs.longValue() / (double)inSegs);
                System.out.println("\u6bcf\u79d2\u53d1\u5305" + (double)Snmp.snmp.OutBytes.longValue() / 1024.0 / 1024.0 * 8.0 + " M");
                System.out.println("\u623f\u95f4\u6570 " + kcpGameTestServer.roomManager.getRooms().size());
                int playerCount = 0;
                for (TestRoom value : kcpGameTestServer.roomManager.getRooms().values()) {
                    playerCount += value.size();
                }
                System.out.println("\u603b\u4eba\u6570\u6570 " + playerCount);
                System.out.println(Snmp.snmp.toString());
                System.out.println();
                Snmp.snmp = new Snmp();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 1000L);
    }

    public void onConnected(Ukcp ukcp) {
        System.out.println("\u6709\u8fde\u63a5\u8fdb\u6765" + ukcp.user());
        TpsChannelServerCache tpsChannelServerCache = new TpsChannelServerCache();
        ukcp.user().setCache((Object)tpsChannelServerCache);
        this.roomManager.addClient(ukcp);
    }

    public void handleReceive(ByteBuf byteBuf, Ukcp ukcp) {
        TpsChannelServerCache tpsChannelServerCache = (TpsChannelServerCache)ukcp.user().getCache();
        int packId = byteBuf.readInt();
        tpsChannelServerCache.addPackId(packId);
    }

    public void handleException(Throwable ex, Ukcp ukcp) {
        ex.printStackTrace();
    }

    public void handleClose(Ukcp ukcp) {
        this.roomManager.remove(ukcp);
        System.out.println("\u8fde\u63a5\u65ad\u5f00\u4e86" + ukcp.user().getRemoteAddress());
    }
}

