/*
 * Decompiled with CFR 0.152.
 */
package test.TpsTest;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kcp.Ukcp;
import test.TpsTest.TpsChannelServerCache;

public class TestRoom
implements Runnable {
    private static final AtomicInteger roomIdInc = new AtomicInteger();
    private int roomId;
    private CopyOnWriteArrayList<Ukcp> ukcps = new CopyOnWriteArrayList();

    public TestRoom() {
        this.roomId = roomIdInc.incrementAndGet();
    }

    public int size() {
        return this.ukcps.size();
    }

    public int getRoomId() {
        return this.roomId;
    }

    @Override
    public void run() {
        TpsChannelServerCache tpsChannelServerCache;
        int packIdCount = 0;
        for (Ukcp ukcp : this.ukcps) {
            tpsChannelServerCache = (TpsChannelServerCache)ukcp.user().getCache();
            packIdCount += tpsChannelServerCache.size();
        }
        packIdCount *= 44;
        for (Ukcp ukcp : this.ukcps) {
            tpsChannelServerCache = (TpsChannelServerCache)ukcp.user().getCache();
            List<Integer> packIds = tpsChannelServerCache.getSendPackIds();
            int size = packIds.size();
            ByteBuf byteBuf = ByteBufAllocator.DEFAULT.directBuffer(packIdCount + 4 * size + 2);
            byteBuf.writeShort(size);
            for (Integer packId : packIds) {
                byteBuf.writeInt(packId.intValue());
            }
            byteBuf.writeBytes(new byte[packIdCount]);
            ukcp.write(byteBuf);
            byteBuf.release();
        }
    }

    public CopyOnWriteArrayList<Ukcp> getUkcps() {
        return this.ukcps;
    }

    public void setUkcps(CopyOnWriteArrayList<Ukcp> ukcps) {
        this.ukcps = ukcps;
    }
}

