/*
 * Decompiled with CFR 0.152.
 */
package test.TpsTest;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.TpsTest.Tps;

public class TpsCounter {
    private static final Logger logger = LoggerFactory.getLogger(TpsCounter.class);
    private Map<Integer, Tps> cmds = new ConcurrentHashMap<Integer, Tps>();

    public void add(int cmd) {
        Tps tps = this.cmds.computeIfAbsent(cmd, integer -> new Tps(cmd, new LongAdder(), new LongAdder(), 0.0f, new AtomicLong(), new LongAdder(), new AtomicLong(), new LongAdder()));
        tps.getSend().increment();
        tps.setCmd(cmd);
    }

    public void set(int cmd, int delay) {
        Tps tps = this.cmds.get(cmd);
        tps.getRecieve().increment();
        tps.getMaxDelay().getAndUpdate(operand -> Math.max((long)delay, operand));
        tps.getSumDelay().add(delay);
        tps.getMinDelay().getAndUpdate(operand -> Math.min((long)delay, operand));
    }

    public void count() {
        for (Map.Entry<Integer, Tps> tpsEntry : this.cmds.entrySet()) {
            int cmd = tpsEntry.getKey();
            Tps tps = tpsEntry.getValue();
            long receive = tps.getRecieve().sum();
            long send = tps.getSend().sum();
            if (receive > 0L) {
                long xDelay = tps.getSumDelay().sum() / receive;
                float rate = (float)receive * 1.0f / (float)send;
                float tpss = 1000.0f;
                if (xDelay != 0L) {
                    tpss = 1000L / xDelay;
                }
                logger.error("Tps \u547d\u4ee4\u53f7:{} \u53d1\u5305\u6570:{} \u6536\u5305\u6570:{} \u6210\u529f\u7387:{}  \u5ef6\u65f6\uff08\u6700\u5927:{}ms\u3001\u5e73\u5747:{}ms\u3001\u6700\u5c0f:{}ms\uff09tps:{}", new Object[]{cmd, receive, send, Float.valueOf(rate), tps.getMaxDelay().get(), xDelay, tps.getMinDelay().get(), Float.valueOf(tpss)});
            }
            this.cmds.put(cmd, new Tps(cmd, new LongAdder(), new LongAdder(), 0.0f, new AtomicLong(), new LongAdder(), new AtomicLong(), new LongAdder()));
        }
    }
}

