/*
 * Decompiled with CFR 0.152.
 */
package test.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import test.tcp.TcpChannelInitializer;

public class NetAcceptor {
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ServerBootstrap b = new ServerBootstrap();
    private Channel channel;

    public NetAcceptor(TcpChannelInitializer tcpChannelInitializer, InetSocketAddress address) {
        boolean epoll = Epoll.isAvailable();
        this.bossGroup = epoll ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        this.workerGroup = epoll ? new EpollEventLoopGroup() : new NioEventLoopGroup();
        this.b.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        this.b.childOption(ChannelOption.SO_SNDBUF, (Object)2048);
        this.b.childOption(ChannelOption.SO_RCVBUF, (Object)8096);
        this.b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.b.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        Class serverSocketChannelClass = epoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
        ((ServerBootstrap)this.b.group(this.bossGroup, this.workerGroup).channel(serverSocketChannelClass)).childHandler((ChannelHandler)tcpChannelInitializer);
        try {
            this.channel = this.b.bind((SocketAddress)address).sync().channel();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.workerGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
            throw new RuntimeException("error", e);
        }
    }

    public void shutdown() {
        this.channel.close();
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }

    public Channel getChannel() {
        return this.channel;
    }
}

