/*
 * Decompiled with CFR 0.152.
 */
package test.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import test.tcp.TcpChannelInitializer;

public class NetConnector {
    private EventLoopGroup group = new NioEventLoopGroup();
    private Bootstrap b = new Bootstrap();
    private Channel channel;

    public NetConnector(TcpChannelInitializer tcpChannelInitializer) {
        ((Bootstrap)((Bootstrap)this.b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)tcpChannelInitializer);
        this.b.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.b.option(ChannelOption.SO_SNDBUF, (Object)2048);
        this.b.option(ChannelOption.SO_RCVBUF, (Object)8096);
        this.b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
    }

    public Channel connect(InetSocketAddress ... address) throws InterruptedException {
        int n = 0;
        InetSocketAddress[] inetSocketAddressArray = address;
        int n2 = inetSocketAddressArray.length;
        if (n < n2) {
            InetSocketAddress addr = inetSocketAddressArray[n];
            ChannelFuture future = this.b.connect((SocketAddress)addr);
            future.sync();
            return future.channel();
        }
        return null;
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
    }

    public Channel getChannel() {
        return this.channel;
    }
}

