/*
 * Decompiled with CFR 0.152.
 */
package com.labbol.api.support.client;

import com.labbol.api.support.client.APIClient;
import com.labbol.api.support.client.DefaultAPIClient;
import com.labbol.api.support.exception.APIException;
import com.labbol.api.support.request.APIRequest;
import com.labbol.api.support.request.APIRequestInterceptor;
import com.labbol.api.support.response.APIResponse;
import java.io.IOException;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class APIClientFactory {
    public static final APIClient createSpringMvcDefaultAPIClient(String serverUrl, String appKey, String appSecret) {
        try {
            return APIClientFactory.createDefaultAPIClient(serverUrl, appKey, appSecret, () -> ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest());
        }
        catch (Exception e) {
            throw new RuntimeException("\u5f53\u524d\u672a\u4f7f\u7528SpringMvc\u6846\u67b6\uff01", e);
        }
    }

    public static final APIClient createDefaultAPIClient(String serverUrl, String appKey, String appSecret, final Supplier<HttpServletRequest> requestHolder) {
        DefaultAPIClient apiClient = new DefaultAPIClient(serverUrl, appKey, appSecret);
        apiClient.addAPIRequestInterceptor(new APIRequestInterceptor(){

            @Override
            public void process(APIRequest<? extends APIResponse> request) throws APIException, IOException {
                if (StringUtils.isNotBlank((CharSequence)request.getSchemaTag())) {
                    return;
                }
                HttpServletRequest httpServletRequest = (HttpServletRequest)requestHolder.get();
                HttpSession session = httpServletRequest.getSession();
                request.setSchemaTag((String)session.getAttribute("SCHEMA_TAG"));
            }
        });
        return apiClient;
    }
}

