/*
 * Decompiled with CFR 0.152.
 */
package com.labbol.api.support.client;

import com.labbol.api.support.client.APIClient;
import com.labbol.api.support.request.APIRequestInterceptor;
import com.labbol.api.support.response.APIResponseInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.yelong.http.client.DefaultHttpClient;
import org.yelong.http.client.HttpClient;

public abstract class AbstractAPIClient
implements APIClient {
    private final List<APIRequestInterceptor> apiRequestInterceptors = new ArrayList<APIRequestInterceptor>();
    private final List<APIResponseInterceptor> apiResponseInterceptors = new ArrayList<APIResponseInterceptor>();
    protected HttpClient httpClient;

    public AbstractAPIClient() {
        this((HttpClient)new DefaultHttpClient());
    }

    public AbstractAPIClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void addAPIRequestInterceptor(APIRequestInterceptor apiRequestInterceptor) {
        this.apiRequestInterceptors.add(apiRequestInterceptor);
    }

    @Override
    public void removeAPIRequestInterceptor(APIRequestInterceptor apiRequestInterceptor) {
        this.apiRequestInterceptors.remove(apiRequestInterceptor);
    }

    @Override
    public List<APIRequestInterceptor> getAPIRequestInterceptors() {
        return this.apiRequestInterceptors;
    }

    @Override
    public void addAPIResponseInterceptor(APIResponseInterceptor apiResponseInterceptor) {
        this.apiResponseInterceptors.add(apiResponseInterceptor);
    }

    @Override
    public void removeAPIResponseInterceptor(APIResponseInterceptor apiResponseInterceptor) {
        this.apiResponseInterceptors.remove(apiResponseInterceptor);
    }

    @Override
    public List<APIResponseInterceptor> getAPIResponseInterceptors() {
        return this.apiResponseInterceptors;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public void setHttpClient(HttpClient httpClient) {
        Objects.requireNonNull(httpClient);
        this.httpClient = httpClient;
    }
}

