/*
 * Decompiled with CFR 0.152.
 */
package com.labbol.api.support.client;

import com.labbol.api.support.client.AbstractAPIClient;
import com.labbol.api.support.exception.APIException;
import com.labbol.api.support.request.APIRequest;
import com.labbol.api.support.request.APIRequestInterceptor;
import com.labbol.api.support.response.APIResponse;
import com.labbol.api.support.response.APIResponseInterceptor;
import com.labbol.api.support.sign.SignSupportUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.yelong.http.exception.HttpException;
import org.yelong.http.request.HttpRequest;
import org.yelong.http.response.HttpResponse;

public class DefaultAPIClient
extends AbstractAPIClient {
    private final String serverUrl;
    private String appKey;
    private String appSecret;

    public DefaultAPIClient(String serverUrl, String appKey, String appSecret) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    @Override
    public <T extends APIResponse> T execute(APIRequest<T> request) throws APIException, IOException {
        request.setServerUrl(this.serverUrl);
        APIResponse apiResponse = null;
        try {
            request.check();
            for (APIRequestInterceptor apiIRequestInterceptor : this.getAPIRequestInterceptors()) {
                apiIRequestInterceptor.process(request);
            }
            HttpRequest httpRequest = request.getHttpRequest();
            HashMap<String, String> headers = new HashMap<String, String>(3);
            Long timestamp = request.getTimestamp();
            if (null == timestamp) {
                timestamp = System.currentTimeMillis();
            }
            headers.put("appKey", this.appKey);
            headers.put("timestamp", timestamp.toString());
            headers.put("schemaTag", request.getSchemaTag());
            String contentStr = httpRequest.getFileItems().isEmpty() ? httpRequest.getContentStr() : null;
            String sign = SignSupportUtils.generateSign(httpRequest.getParams(), headers, contentStr, this.appSecret);
            httpRequest.addHeader("sign", sign);
            httpRequest.addHeaders(headers);
            HttpResponse httpResponse = this.httpClient.execute(httpRequest);
            Constructor<T> constructor = request.getResponseClass().getConstructor(HttpResponse.class);
            apiResponse = (APIResponse)constructor.newInstance(httpResponse);
            for (APIResponseInterceptor apiResponseInterceptor : this.getAPIResponseInterceptors()) {
                apiResponseInterceptor.process(apiResponse);
            }
        }
        catch (APIException e) {
            throw e;
        }
        catch (HttpException e) {
            throw new APIException(e);
        }
        catch (Exception e) {
            throw new APIException(e);
        }
        return (T)apiResponse;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }
}

