/*
 * Decompiled with CFR 0.152.
 */
package com.labbol.api.support.request;

import com.labbol.api.support.exception.APIRuleException;
import com.labbol.api.support.request.AbstractAPIRequest;
import com.labbol.api.support.request.QueryAPIRequest;
import com.labbol.api.support.request.queryinfo.QueryFilterInfo;
import com.labbol.api.support.request.queryinfo.QueryInfo;
import com.labbol.api.support.request.queryinfo.QuerySortInfo;
import com.labbol.api.support.response.QueryAPIResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.yelong.http.request.HttpRequest;

public abstract class AbstractQueryAPIRequest<T extends QueryAPIResponse<?>>
extends AbstractAPIRequest<T>
implements QueryAPIRequest<T> {
    private QueryInfo queryInfo = new QueryInfo();

    public AbstractQueryAPIRequest(String apiMethodName, String method) {
        super(apiMethodName, method);
        this.httpRequest.setContentType("application/json");
    }

    @Override
    public QueryAPIRequest<T> setQueryInfo(QueryInfo queryInfo) {
        Objects.requireNonNull(queryInfo);
        this.queryInfo = queryInfo;
        return this;
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public QueryAPIRequest<T> startPage(int pageNum, int pageSize) {
        this.queryInfo.setPageNum(pageNum);
        this.queryInfo.setPageSize(pageSize);
        return null;
    }

    @Override
    public QueryAPIRequest<T> addQueryFilterInfo(QueryFilterInfo queryFilterInfo) {
        this.queryInfo.addFilter(queryFilterInfo);
        return this;
    }

    @Override
    public QueryAPIRequest<T> addQueryFilterInfos(List<QueryFilterInfo> queryFilterInfos) {
        for (QueryFilterInfo queryFilterInfo : queryFilterInfos) {
            this.addQueryFilterInfo(queryFilterInfo);
        }
        return this;
    }

    @Override
    public QueryAPIRequest<T> addQueryFilterInfo(String fieldName, String operator) {
        return this.addQueryFilterInfo(new QueryFilterInfo(fieldName, operator));
    }

    @Override
    public QueryAPIRequest<T> addQueryFilterInfo(String fieldName, String operator, Object value) {
        if (null == value || value instanceof String && StringUtils.isEmpty((CharSequence)((String)value))) {
            return this;
        }
        return this.addQueryFilterInfo(new QueryFilterInfo(fieldName, operator, value));
    }

    @Override
    public QueryAPIRequest<T> addQueryFilterInfo(String fieldName, String operator, Object value, Object secondValue) {
        if (null == value || null == secondValue) {
            return this;
        }
        return this.addQueryFilterInfo(new QueryFilterInfo(fieldName, operator, value, secondValue));
    }

    @Override
    public QueryAPIRequest<T> addQuerySortInfo(QuerySortInfo querySortInfo) {
        this.queryInfo.addSort(querySortInfo);
        return this;
    }

    @Override
    public QueryAPIRequest<T> addQuerySortInfos(List<QuerySortInfo> querySortInfos) {
        for (QuerySortInfo querySortInfo : querySortInfos) {
            this.addQuerySortInfo(querySortInfo);
        }
        return this;
    }

    @Override
    public QueryAPIRequest<T> addQuerySortInfo(String sortField, String direction) {
        this.queryInfo.addSort(sortField, direction);
        return this;
    }

    @Override
    public void check() throws APIRuleException {
        Integer pageNum = this.queryInfo.getPageNum();
        Integer pageSize = this.queryInfo.getPageSize();
        if (pageNum == null || pageSize == null) {
            throw new APIRuleException("40", "\u5206\u9875\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a!\u8bf7\u8c03\u7528startPage\u65b9\u6cd5!");
        }
    }

    @Override
    public HttpRequest getHttpRequest() throws IOException {
        HashMap<String, QueryInfo> map = new HashMap<String, QueryInfo>(1);
        map.put("queryInfo", this.queryInfo);
        this.gson.toJson(map);
        this.httpRequest.setContent(this.gson.toJson(map).getBytes(this.httpRequest.getCharset()));
        return this.httpRequest;
    }
}

