/*
 * Decompiled with CFR 0.152.
 */
package com.labbol.api.support.response;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.labbol.api.support.Constants;
import com.labbol.api.support.response.APIResponse;
import com.labbol.api.support.utils.GsonHolder;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.yelong.http.response.HttpResponse;

public class AbstractAPIResponse
implements APIResponse {
    protected final Gson gson = GsonHolder.getGson();
    private static final String ERROR_RESPONSE_ROOT_NODE = "error_response";
    private String errorCode;
    private String errorMsg;
    protected HttpResponse httpResponse;

    public AbstractAPIResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        String contentStr = httpResponse.getContentStr();
        try {
            Map errorResponse;
            Map map = (Map)this.gson.fromJson(contentStr, new TypeToken<Map<String, Object>>(){}.getType());
            if (MapUtils.isNotEmpty((Map)map) && MapUtils.isNotEmpty((Map)(errorResponse = (Map)map.get(ERROR_RESPONSE_ROOT_NODE)))) {
                this.errorCode = (String)errorResponse.get("code");
                this.errorMsg = (String)errorResponse.get("msg");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == this.errorMsg) {
            this.errorMsg = Constants.DEFAULT_ERROR_MSG;
        }
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean isSuccess() {
        return this.getErrorCode() == null && this.httpResponse.getResponseCode() == 200;
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }
}

