/*
 * Decompiled with CFR 0.152.
 */
package com.labbol.api.support.sign;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class SignSupportUtils {
    private static final String MD5 = "MD5";

    public static String generateSign(Map<String, String> parameterMap, Map<String, String> headerMap, String body, String appSecret) throws Exception {
        if (headerMap.isEmpty()) {
            throw new Exception("headerMap is empty");
        }
        if (StringUtils.isBlank((CharSequence)appSecret)) {
            throw new Exception("appSecret is empty");
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("appSecret", appSecret);
        requestMap.putAll(headerMap);
        if (!parameterMap.isEmpty()) {
            requestMap.putAll(parameterMap);
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            requestMap.put("requestBody", body);
        }
        return SignSupportUtils.encryptMap(requestMap);
    }

    private static String encryptMap(Map<String, String> map) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String md5Str = null;
        StringBuilder encryptStr = new StringBuilder();
        if (!map.isEmpty()) {
            System.out.println("\u53c2\u4e0e\u751f\u6210sign\u7684\u503c=======================" + map.toString());
            Object[] keys = map.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                String value = map.get(key);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                encryptStr.append((String)key).append(value);
            }
            System.out.println("sign\u7684\u503c======================" + encryptStr.toString());
            MessageDigest md = MessageDigest.getInstance(MD5);
            md.update(encryptStr.toString().getBytes("utf-8"));
            byte[] b = md.digest();
            md5Str = SignSupportUtils.byteArrayToHex(b);
        }
        return md5Str;
    }

    private static String byteArrayToHex(byte[] bytes) {
        char[] hexReferChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        int index = 0;
        for (byte b : bytes) {
            hexChars[index++] = hexReferChars[b >>> 4 & 0xF];
            hexChars[index++] = hexReferChars[b & 0xF];
        }
        return new String(hexChars);
    }
}

