/*
 * Decompiled with CFR 0.152.
 */
package com.labbol.api.support.utils;

import com.labbol.api.support.exception.APIRuleException;
import org.yelong.commons.beans.BeanUtilsE;

public class RequestCheckUtils {
    public static void checkNotEmpty(Object value, String fieldName) throws APIRuleException {
        if (value == null) {
            throw new APIRuleException("40", "client-error:Missing required arguments:" + fieldName + "");
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            throw new APIRuleException("40", "client-error:Missing required arguments:" + fieldName + "");
        }
    }

    public static void checkBeanFieldNotEmpty(Object bean, String fieldName) throws APIRuleException {
        Object value = RequestCheckUtils.getProperty(bean, fieldName);
        if (value == null) {
            throw new APIRuleException("40", "client-error:Missing required arguments:" + bean.getClass().getSimpleName() + "." + fieldName + "");
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            throw new APIRuleException("40", "client-error:Missing required arguments:" + bean.getClass().getSimpleName() + "." + fieldName + "");
        }
    }

    public static void checkBeanFieldNotEmpty(Object bean, String[] fieldNames) throws APIRuleException {
        for (String fieldName : fieldNames) {
            RequestCheckUtils.checkBeanFieldNotEmpty(bean, fieldName);
        }
    }

    private static Object getProperty(Object bean, String propertyName) {
        try {
            return BeanUtilsE.getProperty((Object)bean, (String)propertyName);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

