/*
 * Decompiled with CFR 0.152.
 */
package com.github.lalyos.jfiglet;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class FigletFont {
    public char hardblank;
    public int height = -1;
    public int heightWithoutDescenders = -1;
    public int maxLine = -1;
    public int smushMode = -1;
    public char[][][] font = new char[1024][][];
    public String fontName = null;
    public static final int MAX_CHARS = 1024;

    public char[][][] getFont() {
        return this.font;
    }

    public char[][] getChar(int c) {
        return this.font[c];
    }

    public String getCharLineString(int c, int l) {
        if (this.font[c][l] == null) {
            return null;
        }
        String ret = new String(this.font[c][l]);
        return ret.substring(1);
    }

    public FigletFont(InputStream stream) {
        try {
            DataInputStream data = new DataInputStream(new BufferedInputStream(stream));
            String dummyS = data.readLine();
            StringTokenizer st = new StringTokenizer(dummyS, " ");
            String s = st.nextToken();
            this.hardblank = s.charAt(s.length() - 1);
            this.height = Integer.parseInt(st.nextToken());
            this.heightWithoutDescenders = Integer.parseInt(st.nextToken());
            this.maxLine = Integer.parseInt(st.nextToken());
            this.smushMode = Integer.parseInt(st.nextToken());
            int dummyI = Integer.parseInt(st.nextToken());
            st = new StringTokenizer(data.readLine(), " ");
            this.fontName = st.hasMoreElements() ? st.nextToken() : "";
            for (int i = 0; i < dummyI - 1; ++i) {
                dummyS = data.readLine();
            }
            int charCode = 31;
            while (dummyS != null) {
                ++charCode;
                for (int h = 0; h < this.height; ++h) {
                    dummyS = data.readLine();
                    if (dummyS == null) continue;
                    int iNormal = charCode;
                    boolean abnormal = true;
                    if (h == 0) {
                        try {
                            String codeTag = dummyS.concat(" ").split(" ")[0];
                            charCode = codeTag.length() > 2 && "x".equals(codeTag.substring(1, 2)) ? Integer.parseInt(codeTag.substring(2), 16) : Integer.parseInt(codeTag);
                        }
                        catch (NumberFormatException e) {
                            abnormal = false;
                        }
                        if (abnormal) {
                            dummyS = data.readLine();
                        } else {
                            charCode = iNormal;
                        }
                    }
                    if (h == 0) {
                        this.font[charCode] = new char[this.height][];
                    }
                    int t = dummyS.length() - 1 - (h == this.height - 1 ? 1 : 0);
                    if (this.height == 1) {
                        ++t;
                    }
                    this.font[charCode][h] = new char[t];
                    for (int l = 0; l < t; ++l) {
                        char a = dummyS.charAt(l);
                        this.font[charCode][h][l] = a == this.hardblank ? 32 : (int)a;
                    }
                }
            }
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    public static String convertOneLine(String message) {
        String result = "";
        try {
            InputStream stream = FigletFont.class.getClassLoader().getResourceAsStream("standard.flf");
            FigletFont figletFont = new FigletFont(stream);
            for (int l = 0; l < figletFont.height; ++l) {
                for (int c = 0; c < message.length(); ++c) {
                    result = result + figletFont.getCharLineString(message.charAt(c), l);
                }
                result = result + '\n';
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String text = "JFIGLET";
        if (args.length < 1) {
            System.out.println("Usage: java -jar jfiglet.jar <text-to-convert>");
        } else {
            text = args[0];
        }
        System.out.println(FigletFont.convertOneLine(text));
    }
}

