/*
 * Decompiled with CFR 0.152.
 */
package com.github.lalyos.jfiglet;

import com.github.lalyos.jfiglet.Smushing;
import com.github.lalyos.jfiglet.SmushingRulesToApply;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;

public class FigletFont {
    public char hardblank;
    public int height = -1;
    public int heightWithoutDescenders = -1;
    public int maxLine = -1;
    public int smushMode = -1;
    public Integer printDirection = null;
    public Integer fullLayout = null;
    public Integer codetagCount = null;
    public char[][][] font = new char[1024][][];
    public String fontName = "";
    SmushingRulesToApply smushingRulesToApply;
    public static final int MAX_CHARS = 1024;
    public static final int REGULAR_CHARS = 102;

    public char[][][] getFont() {
        return this.font;
    }

    public char[][] getChar(int c) {
        return this.font[c];
    }

    public String getCharLineString(int c, int l) {
        if (this.font[c][l] == null) {
            return null;
        }
        return new String(this.font[c][l]).replace(this.hardblank, ' ');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FigletFont(InputStream stream) throws IOException {
        BufferedReader data = null;
        try {
            data = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(stream), "UTF-8"));
            String dummyS = data.readLine();
            StringTokenizer st = new StringTokenizer(dummyS, " ");
            String s = st.nextToken();
            this.hardblank = s.charAt(s.length() - 1);
            this.height = Integer.parseInt(st.nextToken());
            this.heightWithoutDescenders = Integer.parseInt(st.nextToken());
            this.maxLine = Integer.parseInt(st.nextToken());
            this.smushMode = Integer.parseInt(st.nextToken());
            int commentLines = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                this.printDirection = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.fullLayout = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.codetagCount = Integer.parseInt(st.nextToken());
            }
            this.smushingRulesToApply = Smushing.getRulesToApply(this.smushMode, this.fullLayout);
            if (commentLines > 0 && (st = new StringTokenizer(data.readLine(), " ")).hasMoreElements()) {
                this.fontName = st.nextToken();
            }
            int[] charsTo = new int[102];
            int j = 0;
            int c = 32;
            while (c <= 126) {
                charsTo[j++] = c++;
            }
            for (int additional : new int[]{196, 214, 220, 228, 246, 252, 223}) {
                charsTo[j++] = additional;
            }
            for (int i = 0; i < commentLines - 1; ++i) {
                dummyS = data.readLine();
            }
            int charPos = 0;
            while (dummyS != null) {
                int charCode;
                if (charPos < 102) {
                    charCode = charsTo[charPos++];
                } else {
                    dummyS = data.readLine();
                    if (dummyS == null) continue;
                    charCode = this.convertCharCode(dummyS);
                }
                for (int h = 0; h < this.height; ++h) {
                    dummyS = data.readLine();
                    if (dummyS == null) continue;
                    if (h == 0) {
                        this.font[charCode] = new char[this.height][];
                    }
                    int t = dummyS.length() - 1 - (h == this.height - 1 ? 1 : 0);
                    if (this.height == 1) {
                        ++t;
                    }
                    this.font[charCode][h] = new char[t];
                    for (int l = 0; l < t; ++l) {
                        char a;
                        this.font[charCode][h][l] = a = dummyS.charAt(l);
                    }
                }
            }
        }
        finally {
            if (data != null) {
                data.close();
            }
        }
    }

    int convertCharCode(String input) {
        String codeTag = input.concat(" ").split(" ")[0];
        if (codeTag.matches("^0[xX][0-9a-fA-F]+$")) {
            return Integer.parseInt(codeTag.substring(2), 16);
        }
        if (codeTag.matches("^0[0-7]+$")) {
            return Integer.parseInt(codeTag.substring(1), 8);
        }
        return Integer.parseInt(codeTag);
    }

    public String convert(String message) {
        char[][] convertedMessage = Smushing.convert(this, message);
        StringBuilder result = new StringBuilder();
        for (int l = 0; l < this.height; ++l) {
            result.append(convertedMessage[l]);
            result.append('\n');
        }
        return result.toString().replace(this.hardblank, ' ');
    }

    public static String convertOneLine(InputStream fontFileStream, String message) throws IOException {
        return new FigletFont(fontFileStream).convert(message);
    }

    public static String convertOneLine(String message) throws IOException {
        return FigletFont.convertOneLine(FigletFont.class.getClassLoader().getResourceAsStream("standard.flf"), message);
    }

    public static String convertOneLine(File fontFile, String message) throws IOException {
        return FigletFont.convertOneLine(new FileInputStream(fontFile), message);
    }

    public static String convertOneLine(String fontPath, String message) throws IOException {
        InputStream fontStream = null;
        fontStream = fontPath.startsWith("classpath:") ? FigletFont.class.getResourceAsStream(fontPath.substring(10)) : (fontPath.startsWith("http://") || fontPath.startsWith("https://") ? new URL(fontPath).openStream() : new FileInputStream(fontPath));
        return FigletFont.convertOneLine(fontStream, message);
    }

    FigletFont withSmushingRulesToApply(SmushingRulesToApply smushingRulesToApply) {
        this.smushingRulesToApply = smushingRulesToApply;
        return this;
    }
}

