/*
 * Decompiled with CFR 0.152.
 */
package com.lambdatest.tunnel;

import com.lambdatest.tunnel.TunnelException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;

class TunnelBinary {
    private static final String BIN_URL = "https://downloads.lambdatest.com/tunnel/v3/";
    private String httpPath;
    private static String binaryPath;
    private String store;
    private String binFileName;
    private String downloadFileName;
    String destParentDir;
    private boolean isOSWindows;
    private final String[] orderedPaths = new String[]{System.getProperty("user.dir") + "/.lambdatest", System.getProperty("user.home") + "/.lambdatest", System.getProperty("java.io.tmpdir")};

    TunnelBinary(String binaryPathFromUser) throws TunnelException {
        this.initialize();
        this.getBinary(binaryPathFromUser);
        this.checkBinary(binaryPathFromUser);
    }

    private static void downloadZipFile(String urlStr, String file) throws IOException {
        try {
            int count;
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            InputStream in = conn.getInputStream();
            FileOutputStream out = new FileOutputStream(file);
            byte[] b = new byte[1024];
            while ((count = in.read(b)) >= 0) {
                out.write(b, 0, count);
            }
            out.close();
            out.flush();
            out.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initialize() throws TunnelException {
        String osname = System.getProperty("os.name").toLowerCase();
        this.isOSWindows = osname.contains("windows");
        if (this.isOSWindows) {
            String arch = System.getProperty("os.arch");
            this.binFileName = "windows/" + (arch.contains("64") ? "64bit/LT_Windows.zip" : "32bit/LT_Windows.zip");
            this.downloadFileName = arch.contains("64") ? "/LT_Windows.zip" : "/LT_Windows.zip";
        } else if (osname.contains("mac") || osname.contains("darwin")) {
            String arch = System.getProperty("os.arch");
            this.binFileName = "mac/" + (arch.contains("64") ? "64bit/LT_Mac.zip" : "32bit/LT_Mac.zip");
            this.downloadFileName = arch.contains("64") ? "/LT_Mac.zip" : "/LT_Mac.zip";
        } else if (osname.contains("linux")) {
            String arch = System.getProperty("os.arch");
            this.binFileName = "linux/" + (arch.contains("64") ? "64bit/LT_Linux.zip" : "32bit/LT_Linux.zip");
            this.downloadFileName = arch.contains("64") ? "/LT_Linux.zip" : "/LT_Linux.zip";
        } else {
            throw new TunnelException("Failed to detect OS type");
        }
        this.httpPath = BIN_URL + this.binFileName;
    }

    private void checkBinary(String binaryPathFromUser) throws TunnelException {
        boolean binaryWorking = this.validateBinary(binaryPathFromUser);
        if (!binaryWorking) {
            File binary_file = new File(binaryPath);
            if (binary_file.exists()) {
                binary_file.delete();
            }
            throw new TunnelException("LambdaTestTunnel binary is corrupt");
        }
    }

    private boolean validateBinary(String binaryPathFromUser) throws TunnelException {
        String url = this.httpPath;
        if (binaryPathFromUser == null) {
            try {
                File tunnelZip = new File(this.store + this.downloadFileName);
                if (!tunnelZip.exists()) {
                    TunnelBinary.downloadZipFile(url, this.store + this.downloadFileName);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("Extracting the Zipped Tunnel");
            TunnelBinary.unzip(this.destParentDir + this.downloadFileName, this.destParentDir);
        }
        try {
            System.out.println(binaryPath);
            this.changePermissions(binaryPath);
            ProcessBuilder pb = new ProcessBuilder(binaryPath, "--version");
            Process process = pb.start();
            BufferedReader stdoutbr = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String stdout = "";
            String line = "";
            while ((line = stdoutbr.readLine()) != null) {
                stdout = stdout + line;
            }
            process.waitFor();
            System.out.println("version: " + stdout);
            return true;
        }
        catch (IOException ex) {
            throw new TunnelException(ex.toString());
        }
        catch (InterruptedException ex) {
            throw new TunnelException(ex.toString());
        }
    }

    public static Boolean isZip(String source) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(source, "r");
        long n = raf.readInt();
        raf.close();
        if (n == 1347093252L) {
            System.out.println("Should be a zip file");
            return true;
        }
        System.out.println("Not a zip file");
        return false;
    }

    public static void unzip(String source, String destination) {
        try {
            if (!TunnelBinary.isZip(source).booleanValue()) {
                return;
            }
            ZipFile zipFile = new ZipFile(source);
            zipFile.extractAll(destination);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getBinary(String binaryPathFromUser) throws TunnelException {
        if (binaryPathFromUser != null) {
            binaryPath = binaryPathFromUser;
            System.out.println("Binary Path provided by user");
            return;
        }
        this.store = this.destParentDir = this.getAvailableDirectory();
        binaryPath = this.destParentDir + "/LT";
        if (this.isOSWindows) {
            binaryPath = binaryPath + ".exe";
        }
        if (!new File(binaryPath).exists()) {
            System.out.println("Downloading Fresh Tunnel Package");
            System.out.println(binaryPath);
        } else {
            System.out.println("Found Existing Tunnel Package");
        }
    }

    private String getAvailableDirectory() throws TunnelException {
        for (int i = 0; i < this.orderedPaths.length; ++i) {
            String path = this.orderedPaths[i];
            if (!this.makePath(path)) continue;
            return path;
        }
        throw new TunnelException("No Available Directory To Store Tunnel Package");
    }

    private boolean makePath(String path) {
        try {
            if (!new File(path).exists()) {
                new File(path).mkdirs();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void downloadBinary(String destParentDir) throws TunnelException {
        try {
            if (!new File(destParentDir).exists()) {
                new File(destParentDir).mkdirs();
            }
            URL url = new URL(this.httpPath);
            String source = destParentDir + "/LT";
            if (this.isOSWindows) {
                source = source + ".exe";
            }
            File f = new File(source);
            System.out.println("Url: " + url);
            FileUtils.copyURLToFile((URL)url, (File)f);
            this.changePermissions(binaryPath);
        }
        catch (Exception e) {
            throw new TunnelException("Error While Downloading Tunnel Package");
        }
    }

    public void changePermissions(String path) {
        File f = new File(path);
        f.setExecutable(true, true);
        f.setReadable(true, true);
        f.setWritable(true, true);
    }

    public static String getBinaryPath() {
        return binaryPath;
    }
}

