/*
 * Decompiled with CFR 0.152.
 */
package com.lambdatest.tunnel;

import com.lambdatest.tunnel.TunnelBinary;
import com.lambdatest.tunnel.TunnelException;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class Tunnel {
    private static final List<String> IGNORE_KEYS = Arrays.asList("user", "key", "infoAPIPort", "binarypath");
    List<String> command;
    private Map<String, String> startOptions;
    private String binaryPath;
    private int stackCount = 0;
    private boolean isOSWindows;
    private boolean tunnelFlag = true;
    private boolean controlFlag = false;
    private static int infoAPIPortValue = 0;
    static Queue<String> Q = new LinkedList<String>();
    private TunnelProcess proc = null;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public Tunnel() {
        this.parameters.put("bypassHosts", "--bypassHosts");
        this.parameters.put("callbackURL", "--callbackURL");
        this.parameters.put("config", "--config");
        this.parameters.put("controller", "--controller");
        this.parameters.put("egress-only ", "--egress-only ");
        this.parameters.put("dir", "--dir");
        this.parameters.put("dns", "--dns");
        this.parameters.put("emulateChrome", "--emulateChrome");
        this.parameters.put("env", "--env");
        this.parameters.put("help", "--help");
        this.parameters.put("infoAPIPort", "--infoAPIPort");
        this.parameters.put("ingress-only", "--ingress-only");
        this.parameters.put("key", "--key");
        this.parameters.put("localDomains", "--local-domains");
        this.parameters.put("logFile", "--logFile");
        this.parameters.put("mitm", "--mitm");
        this.parameters.put("mode", "--mode");
        this.parameters.put("noProxy", "--no-proxy");
        this.parameters.put("pidfile", "--pidfile");
        this.parameters.put("port", "--port");
        this.parameters.put("proxyHost", "--proxy-host");
        this.parameters.put("proxyPass", "--proxy-pass");
        this.parameters.put("proxyPort", "--proxy-port");
        this.parameters.put("proxyUser", "--proxy-user");
        this.parameters.put("sharedTunnel", "--shared-tunnel");
        this.parameters.put("sshConnType", "--sshConnType");
        this.parameters.put("tunnelName", "--tunnelName");
        this.parameters.put("user", "--user");
        this.parameters.put("v", "--v");
        this.parameters.put("version", "--version");
    }

    public void start(Map<String, String> options) throws Exception {
        this.startOptions = options;
        TunnelBinary tunnelBinary = new TunnelBinary();
        this.binaryPath = tunnelBinary.getBinaryPath();
        infoAPIPortValue = options.containsKey("infoAPIPort") && options.get("infoAPIPort").matches("^[0-9]+") ? Integer.parseInt(options.get("infoAPIPort")) : Tunnel.findAvailablePort();
        Tunnel.clearTheFile();
        this.passParametersToTunnel(this.startOptions, "start");
        this.proc = this.runCommand(this.command);
        Q.add(String.valueOf(infoAPIPortValue));
    }

    public void verifyTunnelStarted(Map<String, String> options) {
        try {
            if (options.get("user") == null || options.get("user") == "" || options.get("key") == null || options.get("key") == "") {
                this.controlFlag = true;
                throw new TunnelException("Username/AccessKey Cannot Be Empty");
            }
            String ltcbin = System.getProperty("user.dir");
            List<String> lines = Files.readAllLines(Paths.get(ltcbin + "/tunnel.log", new String[0]));
            for (String line : lines) {
                if (line.contains("Err: Unable to authenticate user")) {
                    this.tunnelFlag = false;
                    this.controlFlag = true;
                    throw new TunnelException("Invalid Username/AccessKey");
                }
                if (!line.contains("Tunnel ID")) continue;
                System.out.println("Tunnel Started Successfully");
                this.controlFlag = true;
                break;
            }
            if (!this.controlFlag) {
                throw new TunnelException("Unable to Start Tunnel");
            }
        }
        catch (TunnelException | IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() throws Exception {
        if (!this.tunnelFlag) {
            return;
        }
        this.stackCount = Q.size();
        while (this.stackCount != 0) {
            Tunnel.stopTunnel();
            --this.stackCount;
        }
        this.stackCount = 0;
        this.passParametersToTunnel(this.startOptions, "stop");
        this.proc.waitFor();
    }

    private static Integer findAvailablePort() throws IOException {
        ServerSocket s = new ServerSocket(0);
        s.close();
        return s.getLocalPort();
    }

    public static void clearTheFile() throws IOException {
        FileWriter fwOb = new FileWriter("tunnel.log", false);
        PrintWriter pwOb = new PrintWriter((Writer)fwOb, false);
        pwOb.flush();
        pwOb.close();
        fwOb.close();
    }

    public static void stopTunnel() throws TunnelException {
        try {
            URL urlForDeleteRequest = new URL("http://127.0.0.1:" + Q.poll() + "/api/v1.0/stop");
            HttpURLConnection connection = (HttpURLConnection)urlForDeleteRequest.openConnection();
            connection.setRequestMethod("DELETE");
            connection.connect();
            InputStream inputStream = connection.getInputStream();
            if (connection.getResponseCode() == 200) {
                System.out.println("Tunnel Closed Successfully");
            }
        }
        catch (IOException e) {
            throw new TunnelException("Unable to Close Tunnel");
        }
    }

    private void passParametersToTunnel(Map<String, String> options, String opCode) throws IOException, TunnelException {
        this.command = new ArrayList<String>();
        this.command.add(this.binaryPath);
        this.command.add("--user");
        if (options.get("user") != null) {
            this.command.add(options.get("user"));
        }
        this.command.add("--key");
        if (options.get("key") != null) {
            this.command.add(options.get("key"));
        }
        this.command.add("--infoAPIPort");
        this.command.add(String.valueOf(infoAPIPortValue));
        for (Map.Entry<String, String> opt : options.entrySet()) {
            String parameter = opt.getKey().trim();
            if (IGNORE_KEYS.contains(parameter)) continue;
            if (this.parameters.get(parameter) != null) {
                this.command.add(this.parameters.get(parameter));
            } else {
                this.command.add("--" + parameter);
            }
            if (opt.getValue() == null) continue;
            this.command.add(opt.getValue().trim());
        }
    }

    protected TunnelProcess runCommand(List<String> command) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        final Process process = processBuilder.start();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                if (line.contains("Err: Unable to authenticate user")) {
                    this.tunnelFlag = false;
                    this.controlFlag = true;
                    throw new TunnelException("Invalid Username/AccessKey");
                }
                if (!line.contains("Tunnel ID")) continue;
                System.out.println("Tunnel Started Successfully");
                this.controlFlag = true;
                break;
            }
        }
        catch (TunnelException | IOException ex) {
            System.out.println(ex.getMessage());
        }
        return new TunnelProcess(){

            @Override
            public InputStream getInputStream() {
                return process.getInputStream();
            }

            @Override
            public InputStream getErrorStream() {
                return process.getErrorStream();
            }

            @Override
            public int waitFor() throws Exception {
                return process.waitFor();
            }
        };
    }

    public static interface TunnelProcess {
        public InputStream getInputStream();

        public InputStream getErrorStream();

        public int waitFor() throws Exception;
    }
}

