/*
 * Decompiled with CFR 0.152.
 */
package com.lambdatest;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class KillPort {
    public static void killProcess(int port) {
        int pid = KillPort.getPid(port);
        if (pid == 0) {
            return;
        }
        String[] command = new String[]{"taskkill", "/F", "/T", "/PID", Integer.toString(pid)};
        if (System.getProperty("os.name").startsWith("Linux")) {
            String[] cmd = new String[]{"kill", "-9", Integer.toString(pid)};
            command = cmd;
        }
        try {
            Process killer = Runtime.getRuntime().exec(command);
            int result = killer.waitFor();
            System.out.println();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static int getPid(int port) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return KillPort.getPidWin(port);
        }
        return KillPort.getPidLinux(port);
    }

    public static int getPidWin(int port) {
        String[] command = new String[]{"netstat", "-on"};
        try {
            Process netstat = Runtime.getRuntime().exec(command);
            StringBuilder conectionList = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(netstat.getInputStream());
            char[] buffer = new char[1024];
            int n = reader.read(buffer);
            while (n != -1) {
                conectionList.append(buffer, 0, n);
                n = reader.read(buffer);
            }
            ((Reader)reader).close();
            String[] conections = conectionList.toString().split("\n");
            int portIdx = 10000;
            String pid = null;
            for (String conection : conections) {
                String state;
                int stateIdx;
                int idx = conection.indexOf(":" + port);
                if (idx == -1 || idx > portIdx || (stateIdx = conection.indexOf(state = "ESTABLISHED")) == -1) continue;
                portIdx = idx;
                idx = stateIdx + state.length();
                pid = conection.substring(idx).trim();
            }
            if (pid != null) {
                return Integer.valueOf(pid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static int getPidLinux(int port) {
        String[] command = new String[]{"netstat", "-anp"};
        try {
            Process netstat = Runtime.getRuntime().exec(command);
            StringBuilder conectionList = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(netstat.getInputStream());
            char[] buffer = new char[1024];
            int n = reader.read(buffer);
            while (n != -1) {
                conectionList.append(buffer, 0, n);
                n = reader.read(buffer);
            }
            ((Reader)reader).close();
            String[] conections = conectionList.toString().split("\n");
            String pid = null;
            for (String conection : conections) {
                int idx;
                if (!conection.contains(":" + port) || !conection.contains("/soffice.bin")) continue;
                int idx2 = idx = conection.indexOf("/soffice.bin");
                while (Character.isDigit(conection.charAt(--idx2))) {
                }
                pid = conection.substring(idx2 + 1, idx);
            }
            if (pid != null) {
                return Integer.valueOf(pid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

