/*
 * Decompiled with CFR 0.152.
 */
package com.lambdatest.tunnel;

import com.lambdatest.KillPort;
import com.lambdatest.tunnel.TestDaemonThread1;
import com.lambdatest.tunnel.TunnelBinary;
import com.lambdatest.tunnel.TunnelException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Tunnel {
    private static final List<String> IGNORE_KEYS = Arrays.asList("user", "key", "infoAPIPort", "binarypath", "load-balanced", "mitm", "pacfile", "mTLSHosts", "clientKey", "clientCert", "allowHosts", "verbose", "serverDomain", "usePrivateIp");
    private boolean tunnelFlag = false;
    private int infoAPIPortValue;
    private Map<String, String> parameters;
    private String TunnelID;
    private Integer tunnelCount = 0;
    TunnelBinary tunnelBinary;
    private Process process = null;
    private ReentrantLock mutex = new ReentrantLock();
    TestDaemonThread1 t1 = new TestDaemonThread1();

    public Tunnel() throws TunnelException {
        this.parameters = new HashMap<String, String>();
        this.parameters.put("bypassHosts", "--bypassHosts");
        this.parameters.put("callbackURL", "--callbackURL");
        this.parameters.put("config", "--config");
        this.parameters.put("controller", "--controller");
        this.parameters.put("egress-only ", "--egress-only ");
        this.parameters.put("dir", "--dir");
        this.parameters.put("dns", "--dns");
        this.parameters.put("emulateChrome", "--emulateChrome");
        this.parameters.put("env", "--env");
        this.parameters.put("help", "--help");
        this.parameters.put("infoAPIPort", "--infoAPIPort");
        this.parameters.put("ingress-only", "--ingress-only");
        this.parameters.put("key", "--key");
        this.parameters.put("localDomains", "--local-domains");
        this.parameters.put("logFile", "--logFile");
        this.parameters.put("mode", "--mode");
        this.parameters.put("noProxy", "--no-proxy");
        this.parameters.put("pidfile", "--pidfile");
        this.parameters.put("port", "--port");
        this.parameters.put("proxyHost", "--proxy-host");
        this.parameters.put("proxyPass", "--proxy-pass");
        this.parameters.put("proxyPort", "--proxy-port");
        this.parameters.put("proxyUser", "--proxy-user");
        this.parameters.put("sharedTunnel", "--shared-tunnel");
        this.parameters.put("sshConnType", "--sshConnType");
        this.parameters.put("tunnelName", "--tunnelName");
        this.parameters.put("user", "--user");
        this.parameters.put("load-balanced", "--load-balanced");
        this.parameters.put("v", "--v");
        this.parameters.put("version", "--version");
        this.parameters.put("basicAuth", "--basic-auth");
        this.parameters.put("mitm", "--mitm");
        this.parameters.put("skip-upgrade", "--skip-upgrade");
        this.parameters.put("pacfile", "--pacfile");
        this.parameters.put("mTLSHosts", "--mTLSHosts");
        this.parameters.put("clientKey", "--clientKey");
        this.parameters.put("clientCert", "--clientCert");
        this.parameters.put("allowHosts", "--allowHosts");
        this.parameters.put("verbose", "--verbose");
        this.parameters.put("serverDomain", "--server-domain");
        this.parameters.put("usePrivateIp", "--use-private-ip");
    }

    public synchronized Boolean start(Map<String, String> options) {
        try {
            this.tunnelBinary = new TunnelBinary(options.get("binary"));
            this.mutex.lock();
            this.infoAPIPortValue = options.containsKey("infoAPIPort") && options.get("infoAPIPort").matches("^[0-9]+") ? Integer.parseInt(options.get("infoAPIPort")) : Tunnel.findAvailablePort();
            this.t1.setDaemon(true);
            this.t1.start();
            System.out.println("infoAPIPortValue: " + this.infoAPIPortValue);
            Tunnel.clearTheFile();
            this.verifyTunnelStarted(options, this.infoAPIPortValue);
            System.out.println("tunnel Verified");
            if (options.get("load-balanced") != "" && options.get("load-balanced") != null && (options.get("tunnelName") == "" || options.get("tunnelName") == null)) {
                options.put("tunnelName", "Maven_Tunnel_LambdaTest_" + options.get("key"));
            }
            try {
                for (int i = 0; i < 5; ++i) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
            String tunnelBinaryPath = "";
            if (options.get("binary") != null) {
                tunnelBinaryPath = tunnelBinaryPath + options.get("binary");
            } else {
                Tunnel tunnel = this;
                String path = tunnel.tunnelBinary.getBinaryPath();
                tunnelBinaryPath = tunnelBinaryPath + path;
            }
            boolean isWhiteSpaceInBinaryPath = tunnelBinaryPath.contains(" ");
            System.out.println("white space detected in binary path : " + isWhiteSpaceInBinaryPath);
            if (isWhiteSpaceInBinaryPath) {
                System.out.println("white space detected in binary path : " + tunnelBinaryPath);
                String[] command = this.passParametersToTunnelV2(options);
                this.runCommandV2(command);
            } else {
                String command = this.passParametersToTunnel(options);
                this.runCommand(command);
            }
            this.mutex.unlock();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void verifyTunnelStarted(Map<String, String> options, int infoAPIPortValue) throws TunnelException {
        if (options.get("user") == null || options.get("user") == "" || options.get("key") == null || options.get("key") == "") {
            this.tunnelFlag = false;
            throw new TunnelException("Username/AccessKey Cannot Be Empty");
        }
    }

    public synchronized void stop() throws Exception {
        if (!this.tunnelFlag) {
            return;
        }
        this.mutex.lock();
        this.stopTunnel();
        this.process.waitFor();
        this.mutex.unlock();
    }

    private static Integer findAvailablePort() throws IOException {
        ServerSocket s = new ServerSocket(0);
        s.close();
        return s.getLocalPort();
    }

    public static void clearTheFile() throws IOException {
        FileWriter fwOb = new FileWriter("tunnel.log", false);
        PrintWriter pwOb = new PrintWriter((Writer)fwOb, false);
        pwOb.flush();
        pwOb.close();
        fwOb.close();
    }

    public void stopTunnel() throws TunnelException {
        try {
            String deleteEndpoint = "http://127.0.0.1:" + String.valueOf(this.infoAPIPortValue) + "/api/v1.0/stop";
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpDelete httpDelete = new HttpDelete(deleteEndpoint);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpDelete);
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
            }
            Path pathOfFile = Paths.get(this.t1.port + ".txt", new String[0]);
            boolean result = Files.deleteIfExists(pathOfFile);
            if (result) {
                System.out.println("File is deleted");
            } else {
                System.out.println("File does not exists");
            }
            KillPort killPort = new KillPort();
            KillPort.killProcess(this.t1.port);
            System.out.println("Tunnel closed successfully && Port process killed");
        }
        catch (Exception e) {
            throw new TunnelException("Tunnel with ID: " + this.TunnelID + " has been closed!");
        }
    }

    public String passParametersToTunnel(Map<String, String> options) {
        String command = "";
        if (options.get("binary") != null) {
            command = command + options.get("binary");
        } else {
            Tunnel tunnel = this;
            String binaryPath = tunnel.tunnelBinary.getBinaryPath();
            command = command + binaryPath;
        }
        command = command + " --user ";
        if (options.get("user") != null) {
            command = command + options.get("user");
        }
        command = command + " --key ";
        if (options.get("key") != null) {
            command = command + options.get("key");
        }
        command = command + " --infoAPIPort ";
        command = command + String.valueOf(this.infoAPIPortValue);
        System.out.println("options load " + options.get("load-balanced"));
        if (options.get("load-balanced") != "" && options.get("load-balanced") != null) {
            command = command + " --load-balanced ";
        }
        if (options.get("skip-upgrade") != "" && options.get("skip-upgrade") != null) {
            command = command + " --skip-upgrade ";
        }
        if (options.get("basicAuth") != "" && options.get("basicAuth") != null) {
            command = command + " --basic-auth ";
            command = command + options.get("basicAuth");
        }
        if (options.get("mitm") != "" && options.get("mitm") != null) {
            command = command + " --mitm ";
        }
        if (options.get("pacfile") != "" && options.get("pacfile") != null) {
            command = command + " --pacfile ";
            command = command + options.get("pacfile");
        }
        if (options.get("mTLSHosts") != "" && options.get("mTLSHosts") != null) {
            command = command + " --mTLSHosts ";
            command = command + options.get("mTLSHosts");
        }
        if (options.get("clientKey") != "" && options.get("clientKey") != null) {
            command = command + " --clientKey ";
            command = command + options.get("clientKey");
        }
        if (options.get("clientCert") != "" && options.get("clientCert") != null) {
            command = command + " --clientCert ";
            command = command + options.get("clientCert");
        }
        if (options.get("allowHosts") != "" && options.get("allowHosts") != null) {
            command = command + " --allowHosts ";
            command = command + options.get("allowHosts");
        }
        if (options.get("serverDomain") != "" && options.get("serverDomain") != null) {
            command = command + " --server-domain ";
            command = command + options.get("serverDomain");
        }
        if (options.get("verbose") != "" && options.get("verbose") != null) {
            command = command + " --verbose ";
        }
        if (options.get("usePrivateIp") != "" && options.get("usePrivateIp") != null) {
            command = command + " --use-private-ip ";
        }
        if (this.t1.port != null) {
            command = command + " --callbackURL http://127.0.0.1:" + String.valueOf(this.t1.port);
        }
        for (Map.Entry<String, String> opt : options.entrySet()) {
            String parameter = opt.getKey().trim();
            if (IGNORE_KEYS.contains(parameter) || this.parameters.get(parameter) == null) continue;
            command = command + " " + this.parameters.get(parameter) + " ";
            if (opt.getValue() == null) continue;
            command = command + opt.getValue().trim();
        }
        return command;
    }

    public String[] passParametersToTunnelV2(Map<String, String> options) {
        ArrayList<String> commandArray = new ArrayList<String>();
        if (options.get("binary") != null) {
            commandArray.add(options.get("binary"));
        } else {
            Tunnel tunnel = this;
            commandArray.add(tunnel.tunnelBinary.getBinaryPath());
        }
        commandArray.add("--user");
        if (options.get("user") != null) {
            commandArray.add(options.get("user"));
        }
        commandArray.add("--key");
        if (options.get("key") != null) {
            commandArray.add(options.get("key"));
        }
        commandArray.add("--infoAPIPort");
        commandArray.add(String.valueOf(this.infoAPIPortValue));
        System.out.println("options load " + options.get("load-balanced"));
        if (options.get("load-balanced") != "" && options.get("load-balanced") != null) {
            commandArray.add("--load-balanced");
        }
        if (options.get("skip-upgrade") != "" && options.get("skip-upgrade") != null) {
            commandArray.add("--skip-upgrade");
        }
        if (options.get("basicAuth") != "" && options.get("basicAuth") != null) {
            commandArray.add("--basic-auth");
            commandArray.add(options.get("basicAuth"));
        }
        if (options.get("mitm") != "" && options.get("mitm") != null) {
            commandArray.add("--mitm");
        }
        if (options.get("pacfile") != "" && options.get("pacfile") != null) {
            commandArray.add("--pacfile");
            commandArray.add(options.get("pacfile"));
        }
        if (options.get("mTLSHosts") != "" && options.get("mTLSHosts") != null) {
            commandArray.add("--mTLSHosts");
            commandArray.add(options.get("mTLSHosts"));
        }
        if (options.get("clientKey") != "" && options.get("clientKey") != null) {
            commandArray.add("--clientKey");
            commandArray.add(options.get("clientKey"));
        }
        if (options.get("clientCert") != "" && options.get("clientCert") != null) {
            commandArray.add("--clientCert");
            commandArray.add(options.get("clientCert"));
        }
        if (options.get("allowHosts") != "" && options.get("allowHosts") != null) {
            commandArray.add("--allowHosts");
            commandArray.add(options.get("allowHosts"));
        }
        if (options.get("serverDomain") != "" && options.get("serverDomain") != null) {
            commandArray.add("--server-domain");
            commandArray.add(options.get("serverDomain"));
        }
        if (options.get("verbose") != "" && options.get("verbose") != null) {
            commandArray.add("--verbose");
        }
        if (options.get("usePrivateIp") != "" && options.get("usePrivateIp") != null) {
            commandArray.add("--use-private-ip");
        }
        if (this.t1.port != null) {
            commandArray.add("--callbackURL");
            commandArray.add("http://127.0.0.1:" + String.valueOf(this.t1.port));
        }
        for (Map.Entry<String, String> opt : options.entrySet()) {
            String parameter = opt.getKey().trim();
            if (IGNORE_KEYS.contains(parameter) || this.parameters.get(parameter) == null) continue;
            commandArray.add(this.parameters.get(parameter));
            if (opt.getValue() == null) continue;
            commandArray.add(opt.getValue().trim());
        }
        String[] commandV2 = commandArray.toArray(new String[commandArray.size()]);
        return commandV2;
    }

    public void runCommand(String command) throws IOException {
        try {
            long start;
            Runtime run = Runtime.getRuntime();
            this.process = run.exec(command);
            Boolean update = false;
            long end = start = System.currentTimeMillis();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    block10: {
                        if (line.contains("Downloading update")) {
                            update = true;
                        } else {
                            if (update.booleanValue()) {
                                System.out.println("Tunnel is updated. restarting...");
                                this.runCommand(command);
                            }
                            try {
                                BufferedReader br;
                                if (this.t1.port == null || (br = new BufferedReader(new FileReader(String.valueOf(this.t1.port) + ".txt"))).readLine() == null) break block10;
                                this.tunnelFlag = true;
                                System.out.println("Tunnel Started Successfully");
                                break;
                            }
                            catch (Exception e) {
                                System.out.println("Not found any file");
                            }
                        }
                    }
                    System.out.println(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void runCommandV2(String[] command) throws IOException {
        try {
            long start;
            System.out.println("Command String: " + command);
            Runtime run = Runtime.getRuntime();
            this.process = run.exec(command);
            Boolean update = false;
            long end = start = System.currentTimeMillis();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    block10: {
                        if (line.contains("Downloading update")) {
                            update = true;
                        } else {
                            if (update.booleanValue()) {
                                System.out.println("Tunnel is updated. restarting...");
                                this.runCommandV2(command);
                            }
                            try {
                                BufferedReader br;
                                if (this.t1.port == null || (br = new BufferedReader(new FileReader(String.valueOf(this.t1.port) + ".txt"))).readLine() == null) break block10;
                                this.tunnelFlag = true;
                                System.out.println("Tunnel Started Successfully");
                                break;
                            }
                            catch (Exception e) {
                                System.out.println("Not found any file");
                            }
                        }
                    }
                    System.out.println(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

